/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.authentication;

import be.personify.iam.scim.authentication.AuthenticationUtils;
import be.personify.iam.scim.util.CryptUtils;
import be.personify.iam.scim.util.TokenUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.util.Base64Utils;

public class PropertyFileAuthenticationFilter
implements Filter {
    private static final String SERVER = "Server";
    private static final String ROLE_READ = "read";
    private static final String ROLE_WRITE = "write";
    private static final Logger logger = LogManager.getLogger(PropertyFileAuthenticationFilter.class);
    @Autowired
    private TokenUtils tokenUtils;
    @Autowired
    private CryptUtils cryptUtils;
    @Autowired
    private AuthenticationUtils authenticationUtils;
    private final List<String> PUBLIC_ENDPOINTS = Arrays.asList("/scim/v2/token", "/scim/v2/Me");
    private final String serverDescription = PropertyFileAuthenticationFilter.class.getPackage().getImplementationTitle() + " " + PropertyFileAuthenticationFilter.class.getPackage().getImplementationVersion();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String[] auth;
        HttpServletRequest req = (HttpServletRequest)request;
        ((HttpServletResponse)response).addHeader(SERVER, this.serverDescription);
        String header = req.getHeader("Authorization");
        boolean filtered = false;
        if (this.PUBLIC_ENDPOINTS.contains(req.getRequestURI())) {
            chain.doFilter(request, response);
            filtered = true;
        } else if (header != null && (auth = header.split(" ")).length == 2) {
            String method = req.getMethod();
            if (auth[0].equalsIgnoreCase("Basic")) {
                String credential = new String(Base64Utils.decode((byte[])auth[1].getBytes()));
                if (this.authenticationUtils.getBasicAuthUsers() != null && this.authenticationUtils.getBasicAuthUsers().containsKey(credential)) {
                    filtered = this.checkRole(request, response, chain, filtered, credential, method, this.authenticationUtils.getBasicAuthUsers());
                }
            } else if (auth[0].equalsIgnoreCase("Bearer")) {
                String token = auth[1];
                logger.debug("token {}", (Object)token);
                if (this.tokenUtils.isValid(token)) {
                    String decrypted = this.cryptUtils.decrypt(token, TokenUtils.SALT);
                    String[] parts = decrypted.split(":");
                    String clientId = parts[0];
                    token = this.getClientIdWithCredential(clientId, this.authenticationUtils.getBearerAuthUsers());
                    filtered = this.checkRole(request, response, chain, filtered, token, method, this.authenticationUtils.getBearerAuthUsers());
                }
            }
        }
        if (!filtered) {
            HttpServletResponse resp = (HttpServletResponse)response;
            resp.reset();
            resp.setStatus(401);
            resp.flushBuffer();
        }
    }

    private boolean checkRole(ServletRequest request, ServletResponse response, FilterChain chain, boolean filtered, String credential, String method, Map<String, List<String>> users) throws IOException, ServletException {
        List<String> roles = users.get(credential);
        if (roles != null) {
            if (method.equals(HttpMethod.GET.name())) {
                if (roles.contains(ROLE_READ)) {
                    chain.doFilter(request, response);
                    filtered = true;
                }
            } else if (roles.contains(ROLE_WRITE)) {
                chain.doFilter(request, response);
                filtered = true;
            }
        }
        return filtered;
    }

    private String getClientIdWithCredential(String clientId, Map<String, List<String>> users) {
        for (String key : users.keySet()) {
            if (!key.startsWith(clientId + ":")) continue;
            return key;
        }
        return null;
    }
}

