/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.init;

import be.personify.iam.scim.authentication.AuthenticationUtils;
import be.personify.iam.scim.rest.PatchUtils;
import be.personify.iam.scim.schema.SchemaReader;
import be.personify.iam.scim.util.CryptUtils;
import be.personify.iam.scim.util.PropertyFactory;
import be.personify.iam.scim.util.TokenUtils;
import javax.servlet.Filter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.filter.CommonsRequestLoggingFilter;

@Configuration
@EnableScheduling
@EnableAsync
public class SpringConfig {
    @Bean
    public FilterRegistrationBean<Filter> authenticationFilters() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        try {
            Filter filter = this.authenticationUtils().getFilterImplementation();
            registrationBean.setFilter(filter);
            return registrationBean;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Bean
    public CryptUtils cryptUtils() {
        return new CryptUtils();
    }

    @Bean
    public TokenUtils tokenUtils() {
        return new TokenUtils();
    }

    @Bean
    public AuthenticationUtils authenticationUtils() {
        return new AuthenticationUtils();
    }

    @Bean
    public PropertyFactory propertyFactory() {
        return new PropertyFactory();
    }

    @Bean
    public SchemaReader schemaReader() {
        return new SchemaReader();
    }

    @Bean
    public PatchUtils patchUtils() {
        return new PatchUtils();
    }

    @Bean
    public CommonsRequestLoggingFilter logFilter() {
        CommonsRequestLoggingFilter filter = new CommonsRequestLoggingFilter();
        filter.setIncludeQueryString(true);
        filter.setIncludePayload(true);
        filter.setMaxPayloadLength(10000);
        filter.setIncludeHeaders(false);
        filter.setAfterMessagePrefix("REQUEST DATA : ");
        return filter;
    }
}

