/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.rest;

import be.personify.iam.scim.rest.Controller;
import be.personify.iam.scim.schema.Schema;
import be.personify.iam.scim.schema.SchemaException;
import be.personify.iam.scim.schema.SchemaReader;
import be.personify.iam.scim.storage.ConstraintViolationException;
import be.personify.iam.scim.storage.StorageImplementationFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
public class BulkController
extends Controller {
    private static final Logger logger = LogManager.getLogger(BulkController.class);
    private static final String SCHEMA = "urn:ietf:params:scim:api:messages:2.0:BulkRequest";
    @Autowired
    private StorageImplementationFactory storageImplementationFactory;
    @Value(value="${scim.bulk.maxPayloadSize:1048576}")
    private int maxPayloadSize;
    @Value(value="${scim.bulk.maxOperations:1000}")
    private int maxOperations;
    @Autowired
    private SchemaReader schemaReader;

    @PostMapping(path={"/scim/v2/Bulk"}, produces={"application/scim+json", "application/json"})
    public ResponseEntity<Map<String, Object>> post(@RequestBody Map<String, Object> objects, HttpServletRequest request, HttpServletResponse response) {
        long contentLenth = request.getContentLength();
        if (contentLenth > (long)this.maxPayloadSize) {
            return this.showError(HttpStatus.PAYLOAD_TOO_LARGE.value(), "The size of the bulk operation (" + contentLenth + ") exceeds the maxPayloadSize (" + this.maxPayloadSize + ")", null);
        }
        List schemas = this.extractSchemas(objects);
        if (schemas.contains(SCHEMA)) {
            return this.postBulk(objects, request, response);
        }
        return this.invalidSchemaForResource(schemas, null);
    }

    protected ResponseEntity<Map<String, Object>> postBulk(Map<String, Object> bulk, HttpServletRequest request, HttpServletResponse response) {
        long start = System.currentTimeMillis();
        List operations = (List)bulk.get("Operations");
        if (operations.size() > this.maxOperations) {
            return this.showError(HttpStatus.PAYLOAD_TOO_LARGE.value(), "The number of bulk operations (" + operations.size() + ") exceeds the maxOperations (" + this.maxOperations + ")", null);
        }
        ArrayList resultOperations = new ArrayList();
        String method = null;
        String bulkId = null;
        String path = null;
        Map entity = null;
        for (Map operation : operations) {
            entity = (Map)operation.get("data");
            List schemas = this.extractSchemas(entity);
            Schema schema = this.schemaReader.getSchema((String)schemas.get(0));
            method = (String)operation.get("method");
            bulkId = (String)operation.get("bulkId");
            path = (String)operation.get("path");
            logger.info("operation {} {} {}", (Object)method, (Object)path, (Object)bulkId);
            Map<String, String> operationResult = new HashMap();
            if (method.equalsIgnoreCase("POST")) {
                try {
                    this.schemaReader.validate(schema, entity, true, request.getMethod());
                    String id = this.createId(entity);
                    entity.put("id", id);
                    String location = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).build().toUriString() + "/" + id;
                    Date now = new Date();
                    this.createMeta(now, id, entity, schema.getName(), location);
                    this.storageImplementationFactory.getStorageImplementation(schema).create(id, entity);
                    operationResult = this.composeResultMap(method, bulkId, HttpStatus.CREATED);
                    operationResult.put("location", location);
                    operationResult.put("version", this.createVersion(now));
                }
                catch (SchemaException se) {
                    logger.error("error validating", (Throwable)se);
                    operationResult = this.composeResultMap(method, bulkId, HttpStatus.BAD_REQUEST);
                }
                catch (ConstraintViolationException e) {
                    logger.error("constraint error", (Throwable)e);
                    operationResult = this.composeResultMap(method, bulkId, HttpStatus.BAD_REQUEST);
                }
            }
            resultOperations.add(operationResult);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("schemas", new String[]{"urn:ietf:params:scim:api:messages:2.0:BulkResponse"});
        result.put("Operations", resultOperations);
        logger.info("operation {} {} {} completed in [{}ms]", (Object)method, path, bulkId, (Object)(System.currentTimeMillis() - start));
        return new ResponseEntity(result, HttpStatus.OK);
    }

    private Map<String, Object> composeResultMap(String method, String bulkId, HttpStatus status) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("method", method);
        result.put("bulkId", bulkId);
        HashMap<String, String> statusMap = new HashMap<String, String>();
        statusMap.put("code", "" + status.value());
        result.put("status", statusMap);
        return result;
    }
}

