/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.rest;

import be.personify.iam.scim.rest.PatchUtils;
import be.personify.iam.scim.schema.Schema;
import be.personify.iam.scim.schema.SchemaAttribute;
import be.personify.iam.scim.schema.SchemaException;
import be.personify.iam.scim.schema.SchemaReader;
import be.personify.iam.scim.storage.ConfigurationException;
import be.personify.iam.scim.storage.ConstraintViolationException;
import be.personify.iam.scim.storage.DataException;
import be.personify.iam.scim.storage.Storage;
import be.personify.iam.scim.storage.StorageImplementationFactory;
import be.personify.iam.scim.util.Constants;
import be.personify.iam.scim.util.PropertyFactory;
import be.personify.iam.scim.util.ScimErrorType;
import be.personify.util.SearchCriteria;
import be.personify.util.SearchCriteriaUtil;
import be.personify.util.SearchCriterium;
import be.personify.util.SearchOperation;
import be.personify.util.StringUtils;
import be.personify.util.exception.InvalidFilterException;
import be.personify.util.scim.PatchOperation;
import be.personify.util.scim.ScimMutability;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.util.UriComponentsBuilder;

public class Controller {
    private static final String SORT_ORDER = "SortOrder";
    private static final String SORT_BY = "SortBy";
    private static final String SCHEMA_VALIDATION = "schema validation : ";
    private static final Logger logger = LogManager.getLogger(Controller.class);
    @Value(value="${scim.allowIdOnCreate:true}")
    private boolean allowIdOnCreate;
    @Value(value="${scim.returnGroupsOnUser:true}")
    private boolean returnGroupsOnUser;
    @Value(value="${scim.returnGroupsOnUser.max:100}")
    private int returnGroupsMax;
    @Value(value="${scim.returnGroupsOnUser.includedFields:id,displayName}")
    private String returnGroupsIncludedFields;
    @Autowired
    private PropertyFactory propertyFactory;
    private Map<String, String> defaultSort = new HashMap();
    private List<String> returnGroupsIncludedFieldsArray = null;
    @Autowired
    private StorageImplementationFactory storageImplementationFactory;
    private SearchCriteriaUtil searchCriteriaUtil = new SearchCriteriaUtil();
    @Autowired
    private SchemaReader schemaReader;
    @Autowired
    private PatchUtils patchUtils;

    protected ResponseEntity<Map<String, Object>> post(Map<String, Object> entity, HttpServletRequest request, HttpServletResponse response, Schema schema, String attributes, String excludedAttributes) {
        long start = System.currentTimeMillis();
        try {
            this.schemaReader.validate(schema, entity, true, request.getMethod());
            String id = this.createId(entity);
            entity.put("id", id);
            String location = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).build().toUriString() + "/" + id;
            this.createMeta(new Date(), id, entity, schema.getName(), location);
            response.addHeader("Location", location);
            this.storageImplementationFactory.getStorageImplementation(schema).create(id, entity);
            logger.info("resource of type {} with id {} created in {} ms", (Object)schema.getName(), (Object)id, (Object)(System.currentTimeMillis() - start));
            return new ResponseEntity((Object)this.filterAttributes(schema, entity, this.getListFromString(attributes), excludedAttributes), HttpStatus.CREATED);
        }
        catch (SchemaException e) {
            logger.error("invalid schema in {} ms : {}", (Object)(System.currentTimeMillis() - start), (Object)e.getMessage());
            return this.showError(400, SCHEMA_VALIDATION + e.getMessage(), ScimErrorType.invalidSyntax);
        }
        catch (ConstraintViolationException e) {
            logger.error("constraint violation in {} ms : {}", (Object)(System.currentTimeMillis() - start), (Object)e.getMessage());
            return this.showError(409, SCHEMA_VALIDATION + e.getMessage(), ScimErrorType.uniqueness);
        }
        catch (ConfigurationException | DataException e) {
            return this.showError(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage());
        }
    }

    protected ResponseEntity<Map<String, Object>> put(String id, Map<String, Object> entity, HttpServletRequest request, HttpServletResponse response, Schema schema, String attributes, String excludedAttributes) {
        long start = System.currentTimeMillis();
        try {
            logger.info("schema {} ", (Object)schema);
            this.schemaReader.validate(schema, entity, true, request.getMethod());
            if (!entity.get("id").equals(id)) {
                return this.showError(400, "id [" + entity.get("id") + "] given in the data does not match the one in the url [" + id + "]");
            }
            Map existingUser = this.storageImplementationFactory.getStorageImplementation(schema).get(id);
            if (existingUser == null) {
                return this.showError(404, "resource of type " + schema.getName() + " with id " + id + " can not be updated");
            }
            entity.put("meta", existingUser.get("meta"));
            String location = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).build().toUriString();
            this.createMeta(new Date(), id, entity, schema.getName(), location);
            response.addHeader("Location", location);
            this.storageImplementationFactory.getStorageImplementation(schema).update(id, entity);
            logger.info("resource of type {} with id {} updated in {} ms", (Object)schema.getName(), (Object)id, (Object)(System.currentTimeMillis() - start));
            return new ResponseEntity((Object)this.filterAttributes(schema, entity, this.getListFromString(attributes), excludedAttributes), HttpStatus.OK);
        }
        catch (SchemaException e) {
            logger.error("invalid schema in {} ms : {}", (Object)(System.currentTimeMillis() - start), (Object)e.getMessage());
            return this.showError(400, SCHEMA_VALIDATION + e.getMessage(), ScimErrorType.invalidSyntax);
        }
        catch (ConstraintViolationException e) {
            logger.error("constraint violation", (Throwable)e);
            return this.showError(409, SCHEMA_VALIDATION + e.getMessage(), ScimErrorType.uniqueness);
        }
        catch (ConfigurationException | DataException e) {
            return this.showError(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage());
        }
    }

    protected ResponseEntity<Map<String, Object>> patch(String id, Map<String, Object> patchRequest, HttpServletRequest request, HttpServletResponse response, Schema schema, String attributes, String excludedAttributes) {
        long start = System.currentTimeMillis();
        try {
            this.schemaReader.validate(schema, patchRequest, false, request.getMethod());
            if (!patchRequest.containsKey("Operations")) {
                return this.showError(400, "no operations present");
            }
            String location = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).build().toUriString();
            Map existingEntity = this.storageImplementationFactory.getStorageImplementation(schema).get(id);
            if (existingEntity == null) {
                return this.showError(404, "resource of type " + schema.getName() + " with id " + id + " can not be updated");
            }
            patchRequest.put("meta", existingEntity.get("meta"));
            response.addHeader("Location", location);
            List operations = (List)patchRequest.get("Operations");
            PatchOperation opType = null;
            String path = null;
            Object value = null;
            for (Map operation : operations) {
                if (!operation.containsKey("op")) {
                    return this.showError(404, "Invalid Operation : " + operation);
                }
                opType = PatchOperation.valueOf((String)((String)operation.get("op")).toLowerCase());
                if (opType == null) {
                    return this.showError(404, "Invalid Operation" + operation);
                }
                path = (String)operation.get("path");
                value = operation.get("value");
                if (!this.canPerformAction(schema, opType, path)) {
                    return this.showError(403, "operation " + opType + " is not allowed for path " + path);
                }
                this.patchUtils.patchEntity(existingEntity, opType, path, value, schema);
            }
            this.createMeta(new Date(), id, existingEntity, schema.getName(), location);
            this.storageImplementationFactory.getStorageImplementation(schema).update(id, existingEntity);
            logger.info("resource of type {} with id {} patched in {} ms", (Object)schema.getName(), (Object)id, (Object)(System.currentTimeMillis() - start));
            return new ResponseEntity((Object)this.filterAttributes(schema, existingEntity, this.getListFromString(attributes), excludedAttributes), HttpStatus.OK);
        }
        catch (SchemaException e) {
            logger.error("invalid schema in {} ms : {}", (Object)(System.currentTimeMillis() - start), (Object)e.getMessage());
            return this.showError(400, SCHEMA_VALIDATION + e.getMessage(), ScimErrorType.invalidSyntax);
        }
        catch (ConstraintViolationException e) {
            logger.error("constraint violation", (Throwable)e);
            return this.showError(409, SCHEMA_VALIDATION + e.getMessage(), ScimErrorType.uniqueness);
        }
        catch (ConfigurationException | DataException e) {
            return this.showError(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage());
        }
    }

    protected ResponseEntity<Map<String, Object>> get(String id, HttpServletRequest request, HttpServletResponse response, Schema schema, String attributes, String excludedAttributes) {
        long start = System.currentTimeMillis();
        try {
            Map object = this.storageImplementationFactory.getStorageImplementation(schema).get(id);
            ResponseEntity result = null;
            if (object != null) {
                List includeList = this.getListFromString(attributes);
                object = this.filterAttributes(schema, object, includeList, excludedAttributes);
                if (this.haveToIncludeGroups(schema, includeList, excludedAttributes)) {
                    logger.debug("have to include groups");
                    Schema groupsSchema = this.schemaReader.getSchemaByResourceType("Group");
                    List groupSearch = this.storageImplementationFactory.getStorageImplementation(groupsSchema).search(new SearchCriteria(new SearchCriterium[]{new SearchCriterium("members.value", (Object)id, SearchOperation.ENDS_WITH)}), 1, this.returnGroupsMax, null, null);
                    if (this.returnGroupsIncludedFieldsArray == null) {
                        this.returnGroupsIncludedFieldsArray = Arrays.asList(this.returnGroupsIncludedFields.split(","));
                    }
                    ArrayList<Map> filteredGroups = new ArrayList<Map>();
                    for (Map m : groupSearch) {
                        filteredGroups.add(this.filterAttributes(groupsSchema, m, this.returnGroupsIncludedFieldsArray, null));
                    }
                    object.put("groups", filteredGroups);
                }
            } else {
                return this.showError(HttpStatus.NOT_FOUND.value(), "the resource with id " + id + " is not found");
            }
            result = new ResponseEntity((Object)object, HttpStatus.OK);
            response.addHeader("Location", UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).build().toUriString());
            logger.info("resource of type {} with id {} fetched in {} ms", (Object)schema.getName(), (Object)id, (Object)(System.currentTimeMillis() - start));
            return result;
        }
        catch (ConfigurationException | DataException e) {
            return this.showError(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage());
        }
    }

    private boolean haveToIncludeGroups(Schema schema, List<String> includeList, String excludedAttributes) {
        if (schema.getName().equalsIgnoreCase("User") && this.returnGroupsOnUser && (excludedAttributes == null || !excludedAttributes.contains("groups"))) {
            logger.debug("have to return groups");
            return true;
        }
        return false;
    }

    protected ResponseEntity<Map<String, Object>> search(Integer startIndex, Integer count, Schema schema, String filter) {
        return this.search(startIndex, count, schema, filter, null, null, null, null);
    }

    protected ResponseEntity<Map<String, Object>> search(Integer startIndex, Integer count, Schema schema, String filter, String sortBy, String sortOrder, String attributes, String excludedAttributes) {
        long start = System.currentTimeMillis();
        try {
            SearchCriteria searchCriteria = this.searchCriteriaUtil.composeSearchCriteriaFromSCIMFilter(filter);
            Storage storage = this.storageImplementationFactory.getStorageImplementation(schema);
            List includeList = this.getListFromString(attributes);
            if (StringUtils.isEmpty((String)sortBy)) {
                sortBy = this.getSearchDefault(schema, SORT_BY);
            }
            if (StringUtils.isEmpty((String)sortOrder)) {
                sortOrder = this.getSearchDefault(schema, SORT_ORDER);
            }
            List dataFetched = storage.search(searchCriteria, startIndex.intValue(), count.intValue(), sortBy, sortOrder, includeList);
            ArrayList<Map> data = new ArrayList<Map>();
            if (dataFetched != null) {
                for (Map entity : dataFetched) {
                    data.add(this.filterAttributes(schema, entity, includeList, excludedAttributes));
                }
                ResponseEntity result = null;
                HashMap<String, Object> responseObject = new HashMap<String, Object>();
                responseObject.put("schemas", new String[]{"urn:ietf:params:scim:api:messages:2.0:ListResponse"});
                responseObject.put("startIndex", startIndex);
                responseObject.put("itemsPerPage", count);
                responseObject.put("totalResults", storage.count(searchCriteria));
                responseObject.put("Resources", data);
                result = new ResponseEntity(responseObject, HttpStatus.OK);
                logger.info("resources of type {} start [{}] count[{}] filter [{}] fetched in {} ms", (Object)schema.getName(), (Object)startIndex, (Object)count, (Object)filter, (Object)(System.currentTimeMillis() - start));
                return result;
            }
            throw new DataException("null value returned from storage layer implemetation, should be empty list");
        }
        catch (InvalidFilterException ife) {
            return this.showError(HttpStatus.BAD_REQUEST.value(), "the filter [" + filter + "] is not correct : " + ife.getMessage(), ScimErrorType.invalidFilter);
        }
        catch (ConfigurationException | DataException e) {
            return this.showError(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage());
        }
    }

    protected ResponseEntity<?> delete(String id, Schema schema) {
        long start = System.currentTimeMillis();
        Map m = this.storageImplementationFactory.getStorageImplementation(schema).get(id);
        ResponseEntity result = null;
        if (m != null) {
            boolean deleted = this.storageImplementationFactory.getStorageImplementation(schema).delete(id);
            if (!deleted) {
                return this.showError(400, "could not delete resource of type " + schema.getName() + " with id " + id);
            }
        } else {
            return this.showError(HttpStatus.NOT_FOUND.value(), "the resource with id " + id + " is not found");
        }
        result = new ResponseEntity(HttpStatus.NO_CONTENT);
        logger.info("resource of type {} with id {} deleted in {} ms", (Object)schema.getName(), (Object)id, (Object)(System.currentTimeMillis() - start));
        return result;
    }

    protected void createMeta(Date date, String id, Map<String, Object> user, String resourceType, String location) {
        logger.debug("create meta {} {} {} {} {}", (Object)date, (Object)id, user, (Object)resourceType, (Object)location);
        Map<String, String> map = new HashMap<String, String>();
        String formattedDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US).format(date);
        if (user.containsKey("meta")) {
            map = (Map)user.get("meta");
            if (map == null) {
                map = new HashMap();
            }
        } else {
            map.put("created", formattedDate);
        }
        map.put("resourceType", resourceType);
        map.put("lastModified", formattedDate);
        map.put("version", this.createVersion(date));
        map.put("location", location);
        user.put("meta", map);
    }

    private String getSearchDefault(Schema schema, String type) {
        String kk = schema.getName() + "." + type;
        if (this.defaultSort.containsKey(kk)) {
            return (String)this.defaultSort.get(kk);
        }
        String key = "scim.search." + schema.getName() + ".default" + type;
        String value = this.propertyFactory.getProperty(key);
        if (StringUtils.isEmpty((String)value)) {
            value = "";
        }
        logger.info("putting default sort for type {} schema {} to value {}", (Object)type, (Object)schema.getName(), (Object)value);
        this.defaultSort.put(kk, value);
        return value;
    }

    protected String createVersion(Date date) {
        return "" + date.getTime();
    }

    protected ResponseEntity<Map<String, Object>> showError(int status, String detail) {
        return this.showError(status, detail, null);
    }

    protected ResponseEntity<Map<String, Object>> showError(int status, String detail, ScimErrorType scimType) {
        HashMap<String, Object> error = new HashMap<String, Object>();
        error.put("schemas", Constants.SCHEMA_ERROR);
        if (scimType != null) {
            error.put("scimType", scimType);
        }
        error.put("detail", detail);
        error.put("status", "" + status);
        return new ResponseEntity(error, HttpStatus.valueOf((int)status));
    }

    protected Map<String, Object> filterAttributes(Schema schema, Map<String, Object> entity, List<String> includeList, String excludedAttributes) {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        copy.putAll(entity);
        List excludeList = this.getListFromString(excludedAttributes);
        for (SchemaAttribute attribute : schema.getAttributes()) {
            if (attribute.getReturned().equalsIgnoreCase("never")) {
                copy.remove(attribute.getName());
            }
            if (includeList != null && includeList.size() > 0) {
                if (attribute.getReturned().equalsIgnoreCase("always") || includeList.contains(attribute.getName())) continue;
                copy.remove(attribute.getName());
                continue;
            }
            if (excludeList == null || excludeList.size() <= 0 || attribute.getReturned().equalsIgnoreCase("always") || !excludeList.contains(attribute.getName())) continue;
            copy.remove(attribute.getName());
        }
        if (includeList != null && includeList.size() > 0) {
            if (!includeList.contains("meta")) {
                copy.remove("meta");
            }
        } else if (excludeList != null && excludeList.size() > 0 && excludeList.contains("meta")) {
            copy.remove("meta");
        }
        return copy;
    }

    protected List<String> getListFromString(String attributes) {
        if (!StringUtils.isEmpty((String)attributes)) {
            return Arrays.asList(attributes.split(","));
        }
        return null;
    }

    protected String createId(Map<String, Object> object) {
        Object id = object.get("id");
        if (this.allowIdOnCreate) {
            return id != null ? id.toString() : UUID.randomUUID().toString();
        }
        return UUID.randomUUID().toString();
    }

    protected List<String> extractSchemas(Map<String, Object> user) {
        return (List)user.get("schemas");
    }

    protected ResponseEntity<Map<String, Object>> invalidSchemaForResource(List<String> schemas, String resourceType) {
        return this.showError(400, "for type " + resourceType + " content is not compliant with schemas " + schemas.toString(), ScimErrorType.invalidSyntax);
    }

    protected ResponseEntity<Map<String, Object>> invalidSchemaForResource(String resourceType, String requiredSchema) {
        return this.showError(400, "for patching " + resourceType + ", given schemas is not containing " + requiredSchema, ScimErrorType.invalidSyntax);
    }

    private boolean canPerformAction(Schema schema, PatchOperation operation, String path) {
        if (path != null && path.indexOf(".") != -1) {
            SchemaAttribute attribute = schema.getAttribute(path);
            if (attribute != null && !StringUtils.isEmpty((String)attribute.getMutability())) {
                ScimMutability mutability = ScimMutability.valueOf((String)attribute.getMutability());
                if (operation == PatchOperation.add ? mutability == ScimMutability.immutable || mutability == ScimMutability.readOnly : (operation == PatchOperation.remove ? mutability == ScimMutability.immutable || mutability == ScimMutability.readOnly : operation == PatchOperation.replace && (mutability == ScimMutability.immutable || mutability == ScimMutability.readOnly))) {
                    return false;
                }
            }
            if (attribute.isRequired() && operation == PatchOperation.remove) {
                return false;
            }
        }
        return true;
    }
}

