/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.rest;

import be.personify.iam.scim.rest.Controller;
import be.personify.iam.scim.schema.Schema;
import be.personify.iam.scim.schema.SchemaReader;
import be.personify.util.StringUtils;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
public class MeController
extends Controller {
    @Autowired
    private SchemaReader schemaReader;

    private Schema getSchema() {
        return this.schemaReader.getSchemaByResourceType("User");
    }

    @PutMapping(path={"/scim/v2/Me"}, produces={"application/scim+json", "application/json"})
    public ResponseEntity<Map<String, Object>> putMe(@RequestBody Map<String, Object> entity, @RequestParam(required=false, name="attributes") String attributes, @RequestParam(required=false, name="excludedAttributes") String excludedAttributes, HttpServletRequest request, HttpServletResponse response) {
        Map result = this.getAndValidateUserName(request, this.getSchema());
        if (!StringUtils.isEmpty((Object)result)) {
            if (result.get("id").equals(entity.get("id"))) {
                return this.put(result.get("id").toString(), entity, request, response, this.getSchema(), attributes, excludedAttributes);
            }
            return this.showError(HttpStatus.UNAUTHORIZED.value(), "not authorized to update user with id " + entity.get("id"), null);
        }
        return this.showError(HttpStatus.UNAUTHORIZED.value(), "no valid authorization subject found", null);
    }

    @GetMapping(path={"/scim/v2/Me"}, produces={"application/scim+json", "application/json"})
    public ResponseEntity<Map<String, Object>> getMe(@RequestParam(required=false, name="attributes") String attributes, @RequestParam(required=false, name="excludedAttributes") String excludedAttributes, HttpServletRequest request, HttpServletResponse response) {
        Map result = this.getAndValidateUserName(request, this.getSchema());
        if (!StringUtils.isEmpty((Object)result)) {
            ResponseEntity responseEntity = new ResponseEntity((Object)this.filterAttributes(this.getSchema(), result, this.getListFromString(attributes), excludedAttributes), HttpStatus.OK);
            String requestUrl = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).build().toUriString();
            requestUrl = requestUrl.substring(0, requestUrl.lastIndexOf("/Me") + 1) + "Users/" + result.get("id");
            response.addHeader("Location", requestUrl);
            return responseEntity;
        }
        return this.showError(HttpStatus.UNAUTHORIZED.value(), "no valid authorization subject found", null);
    }

    @DeleteMapping(path={"/scim/v2/Me"})
    public ResponseEntity<?> delete(@PathVariable String resourceType, @PathVariable String id) {
        return this.showError(HttpStatus.NOT_IMPLEMENTED.value(), "the delete against the /Me endpoint is not yet implemented", null);
    }

    @PostMapping(path={"/scim/v2/Me"}, produces={"application/scim+json", "application/json"})
    public ResponseEntity<Map<String, Object>> post(@RequestBody Map<String, Object> entity, @RequestParam(required=false, name="attributes") String attributes, @RequestParam(required=false, name="excludedAttributes") String excludedAttributes, HttpServletRequest request, HttpServletResponse response) {
        return this.showError(HttpStatus.NOT_IMPLEMENTED.value(), "the post to the /Me endpoint is not yet implemented", null);
    }

    @PatchMapping(path={"/scim/v2/Me"}, produces={"application/scim+json", "application/json"})
    public ResponseEntity<Map<String, Object>> patchMe(@RequestBody Map<String, Object> entity, @RequestParam(required=false, name="attributes") String attributes, @RequestParam(required=false, name="excludedAttributes") String excludedAttributes, HttpServletRequest request, HttpServletResponse response) {
        return this.showError(HttpStatus.NOT_IMPLEMENTED.value(), "the patch against the /Me endpoint is not yet implemented", null);
    }

    private Map<String, Object> getAndValidateUserName(HttpServletRequest request, Schema schema) {
        String credential;
        String[] parts;
        String[] auth;
        String header = request.getHeader("Authorization");
        if (header != null && (auth = header.split(" ")).length == 2 && auth[0].equalsIgnoreCase("Basic") && (parts = (credential = new String(Base64Utils.decode((byte[])auth[1].getBytes()))).split(":")).length == 2) {
            String userName = parts[0];
            String password = parts[1];
            ResponseEntity result = this.search(Integer.valueOf(1), Integer.valueOf(1), schema, "userName eq " + userName + " and password eq " + password);
            if ((Long)((Map)result.getBody()).get("totalResults") == 1L) {
                Map searchResult = (Map)result.getBody();
                return (Map)((ArrayList)searchResult.get("Resources")).get(0);
            }
        }
        return null;
    }
}

