/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.rest;

import be.personify.iam.provisioning.connectors.scim.schema.SchemaAttributeType;
import be.personify.iam.scim.schema.Schema;
import be.personify.iam.scim.schema.SchemaAttribute;
import be.personify.iam.scim.schema.SchemaReader;
import be.personify.util.StringUtils;
import be.personify.util.scim.PatchOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class PatchUtils {
    @Autowired
    private SchemaReader schemaReader;
    private static final Logger logger = LogManager.getLogger(PatchUtils.class);

    public void patchEntity(Map<String, Object> existingEntity, PatchOperation opType, String path, Object value, Schema schema) {
        Object entry = null;
        if (opType == PatchOperation.add) {
            logger.info("adding {} to {}", value, (Object)path);
            entry = this.getPath(path, existingEntity, true, schema);
            logger.info(entry.getClass().getName() + " {} ", entry);
            if (entry instanceof List) {
                List eList = (List)entry;
                logger.info("its a list {}", (Object)eList);
                if (value instanceof List) {
                    List ll = (List)value;
                    for (Object o : ll) {
                        if (eList.contains(o)) continue;
                        eList.add(o);
                    }
                } else if (value instanceof Map) {
                    eList.add(value);
                }
            } else if (entry instanceof Map) {
                logger.info("its a map");
                Map eMap = (Map)entry;
                if (value instanceof Map) {
                    logger.info("value is a map");
                    Map aMap = (Map)value;
                    for (String key : aMap.keySet()) {
                        logger.info("key {}", (Object)key);
                        if (eMap.containsKey(key)) {
                            Object e1 = eMap.get(key);
                            if (e1 instanceof List) {
                                Collection c = (Collection)aMap.get(key);
                                logger.info("c {}", (Object)c);
                                List currentList = (List)e1;
                                logger.info("currentList {}", (Object)currentList);
                                for (Object co : c) {
                                    logger.info("co {}", co);
                                    if (currentList.contains(co)) continue;
                                    ((List)e1).add(co);
                                }
                                continue;
                            }
                            eMap.put(key, aMap.get(key));
                            continue;
                        }
                        eMap.put(key, aMap.get(key));
                    }
                } else if (value instanceof List) {
                    logger.info("entry {} path {} list {}", entry, (Object)path, value);
                    eMap.put(path, value);
                }
            } else {
                logger.error("Cannot perform add patch: path {} value {} on {}", (Object)path, value);
            }
        } else if (opType == PatchOperation.remove) {
            logger.info("removing {} from {}", value, (Object)path);
            List segs = this.getPathSegments(path);
            if (segs.size() == 1) {
                if (value instanceof List) {
                    List entriesToRemove = (List)value;
                    logger.info("entriesToRemove {}", (Object)entriesToRemove);
                    Object existingAttribute = existingEntity.get(path);
                    if (existingAttribute instanceof List) {
                        logger.info("existing attribute is a list", existingAttribute);
                        List existingAttributeList = (List)existingAttribute;
                        ArrayList newList = new ArrayList();
                        for (Object oo : existingAttributeList) {
                            logger.info("oo {}", oo);
                            if (oo instanceof Map) {
                                logger.info("oo is a map");
                                Map ooo = (Map)oo;
                                for (Object ee : entriesToRemove) {
                                    if (!(ee instanceof Map) || this.areEqual(ooo, (Map)ee)) continue;
                                    logger.info("ooo {} not equals ee {}", (Object)ooo, (Object)((Map)ee));
                                    newList.add(oo);
                                }
                            }
                            if (entriesToRemove.contains(oo)) continue;
                        }
                        existingEntity.put(path, newList);
                    }
                } else {
                    existingEntity.remove(path);
                }
            } else {
                logger.error("Cannot perform remove patch: path {} value {} ", (Object)path, value);
            }
        } else if (opType == PatchOperation.replace) {
            logger.debug("replace {} with {}", (Object)path, value);
            entry = this.getPath(path, existingEntity, false, schema);
            if (entry instanceof Map) {
                ((Map)entry).putAll((Map)value);
            } else if (entry instanceof List) {
                List list = (List)entry;
                list.clear();
                list.addAll((List)value);
            } else {
                logger.error("Cannot perform replace patch: path {} value {}", (Object)path, value);
            }
        }
    }

    private Object getPath(String path, Map<String, Object> entity, boolean createTree, Schema schema) {
        if (StringUtils.isEmpty((String)path)) {
            return entity;
        }
        List segs = this.getPathSegments(path);
        Cloneable current = entity;
        while (!segs.isEmpty()) {
            String seg = (String)segs.remove(0);
            logger.info(current.getClass().getName() + " {} ", (Object)seg);
            if (current instanceof Map) {
                String conditions = "";
                logger.info("seg {}", (Object)seg);
                if (seg.endsWith("]")) {
                    int startCondition = seg.indexOf("[");
                    conditions = seg.substring(startCondition, seg.length());
                    seg = seg.substring(0, startCondition);
                    logger.info("conditions {} seg {}", (Object)conditions, (Object)seg);
                }
                current = current.get(seg);
                logger.info("current {}", (Object)current);
                boolean empty = false;
                if (current instanceof List && ((List)((Object)current)).size() == 0) {
                    logger.info("empty list");
                    empty = true;
                }
                if ((current == null || empty) && createTree) {
                    logger.info("seg {}", (Object)seg);
                    SchemaAttribute attribute = schema.getAttribute(seg);
                    if (attribute.isMultiValued()) {
                        logger.info("multivalued {}", (Object)attribute.isMultiValued());
                        logger.info("attribute {} type {}", (Object)attribute, (Object)attribute.getType());
                        if (SchemaAttributeType.fromString((String)attribute.getType()) == SchemaAttributeType.COMPLEX) {
                            logger.info("it's complex");
                            if (current instanceof Map) {
                                ArrayList list = new ArrayList();
                                HashMap newObject = new HashMap();
                                list.add(newObject);
                                ((Map)((Object)current)).put(seg, list);
                                current = newObject;
                            } else if (current == null || current instanceof List) {
                                ArrayList l = new ArrayList();
                                entity.put(path, l);
                                current = l;
                            }
                        }
                    }
                    logger.info("seg {} attribute {}", (Object)seg, (Object)attribute);
                    continue;
                }
                if (current instanceof List && ((List)((Object)current)).size() != 0) continue;
            }
            if (current instanceof List) {
                logger.info("list seg {}", (Object)seg);
                continue;
            }
            return null;
        }
        return current;
    }

    public List<String> getPathSegments(String path) {
        ArrayList<String> rest = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)path) && !path.contains(".")) {
            rest.add(path);
            return rest;
        }
        if (!StringUtils.isEmpty((String)path)) {
            rest.addAll(Arrays.asList(path.split("\\.")));
            return rest;
        }
        return rest;
    }

    private boolean areEqual(Map first, Map second) {
        if (first.size() != second.size()) {
            return false;
        }
        for (Object key : first.keySet()) {
            if (second.containsKey(key)) {
                if (first.get(key).equals(second.get(key))) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

