/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.rest;

import be.personify.iam.scim.rest.Controller;
import be.personify.iam.scim.schema.Schema;
import be.personify.iam.scim.schema.SchemaReader;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SchemaController
extends Controller {
    @Autowired
    private SchemaReader schemaReader;

    @PostMapping(path={"/scim/v2/{resourceType}s"}, produces={"application/scim+json", "application/json"})
    public ResponseEntity<Map<String, Object>> post(@PathVariable String resourceType, @RequestBody Map<String, Object> entity, @RequestParam(required=false, name="attributes") String attributes, @RequestParam(required=false, name="excludedAttributes") String excludedAttributes, HttpServletRequest request, HttpServletResponse response) {
        Schema schema = this.schemaReader.getSchemaByResourceType(resourceType);
        if (schema != null) {
            List schemas = this.extractSchemas(entity);
            if (schemas != null && schemas.size() > 0) {
                if (schemas.contains(schema.getId())) {
                    return this.post(entity, request, response, schema, attributes, excludedAttributes);
                }
                return this.invalidSchemaForResource(schemas, resourceType);
            }
            return this.post(entity, request, response, schema, attributes, excludedAttributes);
        }
        return this.showError(HttpStatus.NOT_FOUND.value(), "the resource of type " + resourceType + " is not found", null);
    }

    @PutMapping(path={"/scim/v2/{resourceType}s/{id}"}, produces={"application/scim+json", "application/json"})
    public ResponseEntity<Map<String, Object>> put(@PathVariable String resourceType, @PathVariable String id, @RequestBody Map<String, Object> entity, @RequestParam(required=false, name="attributes") String attributes, @RequestParam(required=false, name="excludedAttributes") String excludedAttributes, HttpServletRequest request, HttpServletResponse response) {
        Schema schema = this.schemaReader.getSchemaByResourceType(resourceType);
        if (schema != null) {
            List schemas = this.extractSchemas(entity);
            if (schemas != null && schemas.size() > 0) {
                if (schemas.contains(schema.getId())) {
                    return this.put(id, entity, request, response, schema, attributes, excludedAttributes);
                }
                return this.invalidSchemaForResource(schemas, resourceType);
            }
            return this.put(id, entity, request, response, schema, attributes, excludedAttributes);
        }
        return this.showError(HttpStatus.NOT_FOUND.value(), "the resource of type " + resourceType + " is not found", null);
    }

    @PatchMapping(path={"/scim/v2/{resourceType}s/{id}"}, produces={"application/scim+json", "application/json"})
    public ResponseEntity<Map<String, Object>> patch(@PathVariable String resourceType, @PathVariable String id, @RequestBody Map<String, Object> entity, @RequestParam(required=false, name="attributes") String attributes, @RequestParam(required=false, name="excludedAttributes") String excludedAttributes, HttpServletRequest request, HttpServletResponse response) {
        Schema schema = this.schemaReader.getSchemaByResourceType(resourceType);
        if (schema != null) {
            List schemas = this.extractSchemas(entity);
            if (schemas.contains("urn:ietf:params:scim:api:messages:2.0:PatchOp")) {
                return this.patch(id, entity, request, response, schema, attributes, excludedAttributes);
            }
            return this.invalidSchemaForResource(resourceType, "urn:ietf:params:scim:api:messages:2.0:PatchOp");
        }
        return this.showError(HttpStatus.NOT_FOUND.value(), "the resource of type " + resourceType + " is not found", null);
    }

    @GetMapping(path={"/scim/v2/{resourceType}s/{id}"}, produces={"application/scim+json", "application/json"})
    public ResponseEntity<Map<String, Object>> get(@PathVariable String resourceType, @PathVariable String id, @RequestParam(required=false, name="attributes") String attributes, @RequestParam(required=false, name="excludedAttributes") String excludedAttributes, HttpServletRequest request, HttpServletResponse response) {
        Schema schema = this.schemaReader.getSchemaByResourceType(resourceType);
        if (schema != null) {
            return this.get(id, request, response, schema, attributes, excludedAttributes);
        }
        return this.showError(HttpStatus.NOT_FOUND.value(), "the resource of type " + resourceType + " is not found", null);
    }

    @GetMapping(path={"/scim/v2/{resourceType}s"}, produces={"application/scim+json", "application/json"})
    public ResponseEntity<Map<String, Object>> search(@PathVariable String resourceType, @RequestParam(required=false, name="startIndex", defaultValue="1") Integer startIndex, @RequestParam(required=false, name="count", defaultValue="200") Integer count, @RequestParam(required=false, name="filter") String filter, @RequestParam(required=false, name="sortBy") String sortBy, @RequestParam(required=false, name="sortOrder") String sortOrder, @RequestParam(required=false, name="attributes") String attributes, @RequestParam(required=false, name="excludedAttributes") String excludedAttributes, HttpServletRequest request, HttpServletResponse response) {
        Schema schema = this.schemaReader.getSchemaByResourceType(resourceType);
        if (schema != null) {
            return this.search(startIndex, count, schema, filter, sortBy, sortOrder, attributes, excludedAttributes);
        }
        return this.showError(HttpStatus.NOT_FOUND.value(), "the resource of type " + resourceType + " is not found", null);
    }

    @DeleteMapping(path={"/scim/v2/{resourceType}s/{id}"})
    public ResponseEntity<?> delete(@PathVariable String resourceType, @PathVariable String id) {
        Schema schema = this.schemaReader.getSchemaByResourceType(resourceType);
        if (schema != null) {
            return this.delete(id, schema);
        }
        return this.showError(HttpStatus.NOT_FOUND.value(), "the resource of type " + resourceType + " is not found", null);
    }
}

