/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.rest;

import be.personify.iam.scim.authentication.AuthenticationUtils;
import be.personify.iam.scim.rest.Controller;
import be.personify.iam.scim.util.TokenUtils;
import be.personify.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Base64Utils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TokenController
extends Controller {
    private static final Logger logger = LogManager.getLogger(TokenController.class);
    @Autowired
    private AuthenticationUtils authenticationUtils;
    @Autowired
    private TokenUtils tokenUtils;
    @Value(value="${scim.authentication.propertyfile.method.bearer.lifeTimeInSeconds:60}")
    private long lifeTimeInSeconds;

    @RequestMapping(path={"/scim/v2/token"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<?> tokenInfo(@RequestBody(required=false) MultiValueMap<String, Object> entity, HttpServletRequest request) {
        long start = System.currentTimeMillis();
        logger.debug("entity {}", entity);
        if (entity != null && entity.containsKey((Object)"grant_type")) {
            logger.debug("grant_type found");
            if (((List)entity.get((Object)"grant_type")).get(0).equals("client_credentials")) {
                String header = request.getHeader("Authorization");
                String credentials = this.extractCredentials(entity, header);
                if (!StringUtils.isEmpty((String)credentials) && credentials.contains(":")) {
                    if (this.authenticationUtils.getBearerAuthUsers().containsKey(credentials)) {
                        String[] cc = credentials.split(":");
                        HashMap<String, Object> response = new HashMap<String, Object>();
                        response.put("access_token", this.tokenUtils.construct(cc[0], this.lifeTimeInSeconds));
                        response.put("token_type", "Bearer");
                        response.put("expires_in", this.lifeTimeInSeconds);
                        logger.info("acquired token in [{}]ms", (Object)(System.currentTimeMillis() - start));
                        return new ResponseEntity(response, HttpStatus.OK);
                    }
                    logger.info("invalid client_id/client_secret");
                    return this.showError(HttpStatus.FORBIDDEN.value(), "invalid client_id/client_secret");
                }
                String message = "client_id/client_secret [" + credentials + "] not found or incorrect, make sure it is part of the payload or present in the Authorization header";
                logger.info(message);
                return this.showError(HttpStatus.FORBIDDEN.value(), message);
            }
            return this.showError(HttpStatus.FORBIDDEN.value(), "grant type is not of type client_credentials");
        }
        logger.info("grant_type NOT found in body, please add an entry with key 'grant_type' and value 'client_credentials'");
        return this.showError(HttpStatus.FORBIDDEN.value(), "grant_type is not found in body");
    }

    private String extractCredentials(MultiValueMap<String, Object> entity, String authorizationHeader) {
        String credential = null;
        if (entity.containsKey((Object)"client_id") && entity.containsKey((Object)"client_secret")) {
            credential = ((List)entity.get((Object)"client_id")).get(0).toString() + ":" + ((List)entity.get((Object)"client_secret")).get(0).toString();
        } else {
            String[] auth = authorizationHeader.split(" ");
            if (auth.length == 2 && auth[0].equalsIgnoreCase("Basic")) {
                credential = new String(Base64Utils.decode((byte[])auth[1].getBytes()));
            }
        }
        return credential;
    }
}

