/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.schema;

import be.personify.iam.scim.schema.Schema;
import be.personify.iam.scim.schema.SchemaAttribute;
import be.personify.iam.scim.schema.SchemaAttributeType;
import be.personify.iam.scim.schema.SchemaException;
import be.personify.iam.scim.util.Constants;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ResourceLoader;

public class SchemaReader {
    private static final Logger logger = LogManager.getLogger(SchemaReader.class);
    private Map<String, Schema> schemaMap = new HashMap();
    private Map<String, String> schemaMapper = new HashMap();
    @Value(value="${scim.schema.location}")
    private String schemaLocation;
    @Autowired
    private ResourceLoader resourceLoader;

    @PostConstruct
    public void read() throws Exception {
        logger.info("using schema location {} ", (Object)this.schemaLocation);
        logger.info("resourceloader {}", (Object)this.resourceLoader);
        if (!this.resourceLoader.getResource(this.schemaLocation).exists()) {
            throw new Exception("schema " + this.schemaLocation + " does not exist");
        }
        JsonNode root = Constants.objectMapper.readTree(this.resourceLoader.getResource(this.schemaLocation).getInputStream());
        if (root.isArray()) {
            Iterator iterator = root.elements();
            Schema schema = null;
            while (iterator.hasNext()) {
                schema = (Schema)Constants.objectMapper.treeToValue((TreeNode)iterator.next(), Schema.class);
                logger.info("loading schema with id [" + schema.getId() + "]");
                this.schemaMap.put(schema.getId(), schema);
                this.schemaMapper.put(schema.getName(), schema.getId());
            }
        } else {
            logger.info("it's no array");
            throw new Exception("no array found in the schema");
        }
    }

    public List getSchemas() throws Exception {
        return (List)Constants.objectMapper.readValue(this.resourceLoader.getResource(this.schemaLocation).getInputStream(), List.class);
    }

    public Schema getSchema(String id) {
        return (Schema)this.schemaMap.get(id);
    }

    public Schema getSchemaByResourceType(String resourceType) {
        return this.getSchema((String)this.schemaMapper.get(resourceType));
    }

    public Map<String, Object> validate(Schema schema, Map<String, Object> map, boolean checkRequired, String operation) throws SchemaException {
        for (SchemaAttribute attribute : schema.getAttributes()) {
            this.validateAttribute(map.get(attribute.getName()), attribute, checkRequired, operation);
        }
        return map;
    }

    private void validateAttribute(Object o, SchemaAttribute attribute, boolean checkRequired, String operation) throws SchemaException {
        try {
            if (o == null) {
                if (attribute.isRequired() && checkRequired) {
                    throw new SchemaException("attribute with name [" + attribute.getName() + "] is required");
                }
            } else {
                if ((operation.equals("PUT") || operation.equals("POST")) && attribute.getMutability().equalsIgnoreCase("readOnly")) {
                    throw new SchemaException("attribute is readonly");
                }
                SchemaAttributeType type = SchemaAttributeType.fromString((String)attribute.getType());
                if (type.equals((Object)SchemaAttributeType.STRING)) {
                    if (attribute.isMultiValued()) {
                        List list = (List)o;
                    } else {
                        String s = (String)o;
                        if (attribute.getCanonicalValues() != null && attribute.getCanonicalValues().length > 0) {
                            boolean found = false;
                            for (String value : attribute.getCanonicalValues()) {
                                if (!s.equals(value)) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                throw new SchemaException("only one of " + Arrays.toString(attribute.getCanonicalValues()) + " is allowed");
                            }
                        }
                    }
                } else if (type.equals((Object)SchemaAttributeType.COMPLEX)) {
                    if (attribute.isMultiValued()) {
                        for (Map mm : (List)o) {
                            this.validateMap(attribute, mm, checkRequired, operation);
                        }
                    } else {
                        this.validateMap(attribute, (Map)o, checkRequired, operation);
                    }
                } else if (type.equals((Object)SchemaAttributeType.BOOLEAN)) {
                    Boolean.valueOf(o.toString());
                }
            }
        }
        catch (Exception e) {
            throw new SchemaException("schema validation for attribute [" + attribute.getName() + "] with value [" + o + "] " + e.getMessage());
        }
    }

    private void validateMap(SchemaAttribute attribute, Map<String, Object> mm, boolean checkRequired, String operation) throws SchemaException {
        for (String k : mm.keySet()) {
            boolean keyFoundInSchema = false;
            for (SchemaAttribute subAttribute : attribute.getSubAttributes()) {
                if (!k.equals(subAttribute.getName())) continue;
                this.validateAttribute(mm.get(k), subAttribute, checkRequired, operation);
                keyFoundInSchema = true;
            }
            if (keyFoundInSchema) continue;
            throw new SchemaException("unsupported attribute name [" + k + "]");
        }
    }
}

