/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.storage;

import be.personify.iam.scim.schema.Schema;
import be.personify.iam.scim.storage.ConfigurationException;
import be.personify.iam.scim.storage.Storage;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class StorageImplementationFactory
implements ApplicationContextAware {
    private static final Logger logger = LogManager.getLogger(StorageImplementationFactory.class);
    @Value(value="${scim.storage.implementation}")
    private String storageImplementation;
    private Map<String, Storage> storageMap = new HashMap();
    private ApplicationContext applicationContext = null;

    public synchronized Storage getStorageImplementation(Schema schema) {
        String resourceType = schema.getName();
        Storage storage = (Storage)this.storageMap.get(resourceType);
        if (storage == null) {
            logger.info("using environment variable [scim.storage.implementation]");
            logger.info("initializing storage for type {} with implementation {}", (Object)resourceType, (Object)this.storageImplementation);
            try {
                Class<?> c = Class.forName(this.storageImplementation);
                storage = (Storage)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                AutowireCapableBeanFactory factory = this.applicationContext.getAutowireCapableBeanFactory();
                factory.autowireBean((Object)storage);
                factory.initializeBean((Object)storage, "storage" + resourceType);
                storage.initialize(resourceType);
                this.storageMap.put(resourceType, storage);
                logger.info("storage for type {} initialized", (Object)resourceType);
            }
            catch (ClassNotFoundException cnfe) {
                logger.error("error initializing storage implementation " + this.storageImplementation, (Throwable)cnfe);
                throw new ConfigurationException("the storage implementation class [" + this.storageImplementation + "] is not found");
            }
            catch (Exception e) {
                logger.error("error initializing storage for type " + resourceType, (Throwable)e);
                throw new ConfigurationException("error configuring [" + this.storageImplementation + "] " + e.getMessage());
            }
        }
        return storage;
    }

    @Scheduled(fixedRateString="${scim.storage.flushEvery}")
    public void flush() {
        for (Storage storage : this.storageMap.values()) {
            storage.flush();
        }
    }

    @PreDestroy
    public void destroy() {
        this.flush();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

