/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.storage.impl;

import be.personify.iam.provisioning.connectors.ConnectorConnection;
import be.personify.iam.provisioning.connectors.ConnectorPool;
import be.personify.iam.scim.schema.Schema;
import be.personify.iam.scim.schema.SchemaAttribute;
import be.personify.iam.scim.storage.ConfigurationException;
import be.personify.iam.scim.storage.Storage;
import be.personify.iam.scim.storage.impl.DatabaseConnectorStorage;
import be.personify.iam.scim.util.Constants;
import be.personify.iam.scim.util.PropertyFactory;
import be.personify.util.StringUtils;
import be.personify.util.io.IOUtils;
import be.personify.util.provisioning.TargetSystem;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ConnectorStorage
implements Storage {
    private static final Logger logger = LogManager.getLogger(ConnectorStorage.class);
    protected static final String ESCAPED_DOT = "\\.";
    @Autowired
    private PropertyFactory propertyFactory;

    protected void testConnection(TargetSystem targetSystem) {
        ConnectorConnection connection = null;
        try {
            connection = ConnectorPool.getInstance().getConnectorForTargetSystem(targetSystem);
            if (connection != null) {
                connection.getConnector().ping();
                connection.close();
                logger.info("successfully tested connection");
            }
        }
        catch (Exception e) {
            logger.error("can not test connection", (Throwable)e);
            throw new ConfigurationException("can not lease connection " + e.getMessage());
        }
        if (connection == null) {
            throw new ConfigurationException("can not lease connection");
        }
    }

    protected Map<String, String> createDepthMapping(Map<String, String> m) {
        HashMap<String, String> mm = new HashMap<String, String>();
        for (String key : m.keySet()) {
            String value = m.get(key);
            if (!value.contains(".")) continue;
            String[] parts = value.split(ESCAPED_DOT);
            if (parts.length == 2) {
                mm.put(key, value);
                continue;
            }
            throw new ConfigurationException("expression is limited to depth of 2 for mapping [" + key + "->" + value + "]");
        }
        return mm;
    }

    protected Map<String, Object> convertNativeMap(Map<String, Object> nativeMap, Map<String, String> mapping, Map<String, String> depthMapping, List<String> excludes, Schema schema) {
        HashMap<String, Object> scimMap = new HashMap<String, Object>();
        for (String key : mapping.keySet()) {
            if (!nativeMap.containsKey(key)) continue;
            scimMap.put(mapping.get(key), nativeMap.get(key));
        }
        for (String exclude : excludes) {
            scimMap.remove(exclude);
        }
        if (depthMapping.size() > 0) {
            for (String mappingValue : depthMapping.values()) {
                String[] parts = mappingValue.split(ESCAPED_DOT);
                if (scimMap.get(parts[0]) != null) {
                    ((Map)scimMap.get(parts[0])).put(parts[1], scimMap.get(mappingValue));
                } else {
                    Object value = scimMap.get(mappingValue);
                    if (value != null) {
                        logger.debug("mappingValue {} value {} parts [0] {}", (Object)mappingValue, value, (Object)parts[0]);
                        SchemaAttribute sa = schema.getAttribute(parts[0]);
                        if (sa != null && sa.isMultiValued()) {
                            logger.debug("its multivalued {} {} {}", (Object)mappingValue, value, value.getClass());
                            ArrayList newList = new ArrayList();
                            if (value instanceof List) {
                                logger.debug("its a list {} ", value);
                                for (Object o : (List)value) {
                                    logger.debug("object {} ", o);
                                    HashMap newMap = new HashMap();
                                    newMap.put(parts[1], o);
                                    newList.add(newMap);
                                }
                            } else if (value instanceof String) {
                                logger.debug("its a string {} ", value);
                                HashMap newMap = new HashMap();
                                newMap.put(parts[1], value);
                                newList.add(newMap);
                            }
                            scimMap.put(parts[0], newList);
                        } else {
                            HashMap mm = new HashMap();
                            mm.put(parts[1], value);
                            scimMap.put(parts[0], mm);
                        }
                    }
                }
                scimMap.remove(mappingValue);
            }
        }
        return scimMap;
    }

    protected Map<String, Object> processMapping(String id, Map<String, Object> scimObject, Map<String, Object> extraAttributes, Map<String, String> depthMapping, Schema schema) {
        scimObject.putAll(extraAttributes);
        if (depthMapping.size() > 0) {
            HashMap<String, Object> newMap = new HashMap<String, Object>(scimObject);
            SchemaAttribute sa = null;
            Object value = null;
            for (String key : scimObject.keySet()) {
                for (String mappingValue : depthMapping.values()) {
                    if (!mappingValue.startsWith(key + ".") || (sa = schema.getAttribute(key)) == null) continue;
                    String[] parts = mappingValue.split(ESCAPED_DOT);
                    if (sa.isMultiValued()) {
                        List list = (List)scimObject.get(key);
                        ArrayList valueList = new ArrayList();
                        for (Map m : list) {
                            valueList.add(m.get(parts[1]));
                        }
                        newMap.put(mappingValue, valueList);
                        continue;
                    }
                    value = ((Map)scimObject.get(key)).get(parts[1]);
                    newMap.put(mappingValue, value);
                }
            }
            return newMap;
        }
        return scimObject;
    }

    protected Map<String, Object> getConfigMap(String connectorType) throws JsonMappingException, JsonParseException, IOException {
        String configFile = this.propertyFactory.getProperty("scim.storage." + connectorType + ".configFile");
        String fileContent = null;
        fileContent = !StringUtils.isEmpty((String)configFile) ? new String(IOUtils.readFileAsBytes((InputStream)new FileInputStream(new File(configFile)))) : new String(IOUtils.readFileAsBytes((InputStream)DatabaseConnectorStorage.class.getResourceAsStream("/connector_" + connectorType + ".json")));
        fileContent = this.propertyFactory.resolvePlaceHolder(fileContent);
        logger.debug("{}", (Object)fileContent);
        return (Map)Constants.objectMapper.readValue(fileContent, Map.class);
    }

    protected Map<String, String> invertMap(Map<String, String> map) {
        HashMap<String, String> invertedMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            invertedMap.put(entry.getValue(), entry.getKey());
        }
        return invertedMap;
    }
}

