/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.storage.impl;

import be.personify.iam.scim.schema.Schema;
import be.personify.iam.scim.schema.SchemaAttribute;
import be.personify.iam.scim.schema.SchemaReader;
import be.personify.iam.scim.storage.ConfigurationException;
import be.personify.iam.scim.storage.ConstraintViolationException;
import be.personify.iam.scim.storage.DataException;
import be.personify.iam.scim.storage.Storage;
import be.personify.iam.scim.storage.util.CouchBaseUtil;
import be.personify.util.SearchCriteria;
import be.personify.util.SearchCriterium;
import be.personify.util.SearchOperation;
import be.personify.util.SortOrder;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.manager.bucket.BucketSettings;
import com.couchbase.client.java.manager.bucket.BucketType;
import com.couchbase.client.java.manager.query.CreatePrimaryQueryIndexOptions;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class CouchBaseStorage
implements Storage {
    private static final String OFFSET_WITH_SPACES = " offset ";
    private static final String LIMIT_WITH_SPACES = " limit ";
    private static final Logger logger = LogManager.getLogger(CouchBaseStorage.class);
    @Autowired
    private SchemaReader schemaReader;
    @Value(value="${scim.storage.couchbase.host}")
    private String host;
    @Value(value="${scim.storage.couchbase.user}")
    private String user;
    @Value(value="${scim.storage.couchbase.password}")
    private String password;
    @Value(value="${scim.storage.couchbase.indexes}")
    private String indexes;
    private String type;
    private Cluster cluster;
    private Bucket bucket;
    private String queryAll = null;
    private String querySelectCount = null;

    public void create(String id, Map<String, Object> object) throws ConstraintViolationException {
        try {
            this.bucket.defaultCollection().upsert(id, object);
        }
        catch (DocumentExistsException dup) {
            throw new ConstraintViolationException(dup.getMessage());
        }
    }

    public Map<String, Object> get(String id) {
        try {
            return (Map)this.bucket.defaultCollection().get(id).contentAs(Map.class);
        }
        catch (DocumentNotFoundException dnfe) {
            logger.debug("document with id " + id + "not found", (Throwable)dnfe);
            return null;
        }
    }

    public boolean delete(String id) {
        this.bucket.defaultCollection().remove(id);
        return true;
    }

    public void update(String id, Map<String, Object> object) {
        try {
            this.bucket.defaultCollection().upsert(id, object);
        }
        catch (Exception dup) {
            throw new DataException(dup.getMessage());
        }
    }

    public List<Map> search(SearchCriteria searchCriteria, int start, int count, String sortBy, String sortOrder) {
        return this.search(searchCriteria, start, count, sortBy, sortOrder, null);
    }

    public List<Map> search(SearchCriteria searchCriteria, int start, int count, String sortBy, String sortOrder, List<String> includeAttributes) {
        String query = this.queryAll;
        if (includeAttributes != null) {
            logger.info("includeAttributes present");
            StringBuffer b = new StringBuffer("select ");
            for (int i = 0; i < includeAttributes.size(); ++i) {
                b.append(includeAttributes.get(i));
                if (i == includeAttributes.size() - 1) continue;
                b.append(",");
            }
            b.append(" from `" + this.type + "` ");
            query = b.toString();
        }
        query = query + this.constructUnnestString(searchCriteria);
        if (searchCriteria != null && searchCriteria.size() > 0) {
            query = query + " where ";
        }
        StringBuilder builder = CouchBaseUtil.constructQuery((SearchCriteria)searchCriteria, (StringBuilder)new StringBuilder(query), (int)0);
        JsonObject namedParameters = this.composeNamedParameters(searchCriteria, 0, null);
        builder.append(CouchBaseUtil.getSort((String)sortBy, (String)sortOrder, (SortOrder)SortOrder.ascending));
        builder.append(LIMIT_WITH_SPACES + count + OFFSET_WITH_SPACES + (start - 1));
        logger.info("query {}", (Object)builder);
        try {
            QueryResult result = this.cluster.query(builder.toString(), QueryOptions.queryOptions().parameters(namedParameters));
            ArrayList<Map> list = new ArrayList<Map>();
            List maps = result.rowsAs(Map.class);
            for (Map m : maps) {
                if (m.containsKey(this.type)) {
                    list.add((Map)m.get(this.type));
                    continue;
                }
                list.add(m);
            }
            return list;
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    public long count(SearchCriteria searchCriteria) {
        StringBuilder builder = new StringBuilder(this.querySelectCount);
        if (searchCriteria != null && searchCriteria.size() > 0) {
            builder.append(" where ");
        }
        builder = CouchBaseUtil.constructQuery((SearchCriteria)searchCriteria, (StringBuilder)builder, (int)0);
        JsonObject namedParameters = this.composeNamedParameters(searchCriteria, 0, null);
        QueryResult result = this.cluster.query(builder.toString(), QueryOptions.queryOptions().parameters(namedParameters));
        return ((Integer)((Map)result.rowsAs(Map.class).get(0)).get("count")).intValue();
    }

    private JsonObject composeNamedParameters(SearchCriteria searchCriteria, int count, JsonObject namedParameters) {
        if (namedParameters == null) {
            namedParameters = JsonObject.create();
        }
        for (SearchCriterium c : searchCriteria.getCriteria()) {
            if (c.getSearchOperation().getParts() != 3) continue;
            String key = CouchBaseUtil.safeSubAttribute((String)(c.getKey() + "_" + count));
            if (c.getSearchOperation() == SearchOperation.CONTAINS) {
                namedParameters.put(key, "%" + c.getValue() + "%");
            } else if (c.getSearchOperation() == SearchOperation.ENDS_WITH) {
                namedParameters.put(key, "%" + c.getValue());
            } else if (c.getSearchOperation() == SearchOperation.STARTS_WITH) {
                namedParameters.put(key, c.getValue() + "%");
            } else {
                namedParameters.put(key, c.getValue());
            }
            ++count;
        }
        for (SearchCriteria sc : searchCriteria.getGroupedCriteria()) {
            namedParameters = this.composeNamedParameters(sc, count, namedParameters);
            count += 100;
        }
        return namedParameters;
    }

    public void flush() {
    }

    public void initialize(String type) {
        try {
            this.type = type;
            this.cluster = Cluster.connect((String)this.host, (String)this.user, (String)this.password);
            Map allBuckets = this.cluster.buckets().getAllBuckets();
            if (!allBuckets.containsKey(type)) {
                String[] splitted;
                this.cluster.buckets().createBucket(BucketSettings.create((String)type).bucketType(BucketType.COUCHBASE).ramQuotaMB(120L).numReplicas(1).replicaIndexes(true).flushEnabled(true));
                this.cluster.queryIndexes().createPrimaryIndex(type, CreatePrimaryQueryIndexOptions.createPrimaryQueryIndexOptions().indexName("ix_" + type));
                for (String s : splitted = this.indexes.split(",")) {
                    String[] pp = s.split(":");
                    if (!pp[0].toLowerCase().equals(type.toLowerCase())) continue;
                    this.cluster.queryIndexes().createIndex(type, "ix_" + pp[1], Arrays.asList(pp[1]));
                }
            }
            this.bucket = this.cluster.bucket(type);
            this.queryAll = "select t.* from `" + type + "` as t";
            this.querySelectCount = "select count(id) as count from `" + type + "` as t";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationException(e.getMessage());
        }
    }

    private String constructUnnestString(SearchCriteria criteria) {
        Schema schema = this.schemaReader.getSchemaByResourceType(this.type);
        StringBuffer u = new StringBuffer(" ");
        if (criteria != null) {
            for (SchemaAttribute a : schema.getAttributes()) {
                if (!a.getType().equals("complex") || !a.isMultiValued() || !criteria.containsKey(a.getName())) continue;
                logger.debug("criteria contains [{}], adding unnest", (Object)a.getName());
                u.append("unnest t.`").append(a.getName()).append("` as `").append(a.getName()).append("` ");
            }
        }
        return u.toString();
    }

    public Map<String, Object> get(String id, String version) {
        throw new DataException("versioning not implemented");
    }

    public List<String> getVersions(String id) {
        throw new DataException("versioning not implemented");
    }

    public boolean deleteAll() {
        throw new DataException("delete all not implemented");
    }
}

