/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.storage.impl;

import be.personify.iam.provisioning.ProvisionResult;
import be.personify.iam.provisioning.ProvisionStatus;
import be.personify.iam.provisioning.ProvisionTask;
import be.personify.iam.provisioning.connectors.ConnectorConnection;
import be.personify.iam.provisioning.connectors.ConnectorPool;
import be.personify.iam.scim.schema.Schema;
import be.personify.iam.scim.schema.SchemaReader;
import be.personify.iam.scim.storage.ConfigurationException;
import be.personify.iam.scim.storage.ConstraintViolationException;
import be.personify.iam.scim.storage.DataException;
import be.personify.iam.scim.storage.impl.ConnectorStorage;
import be.personify.iam.scim.util.Constants;
import be.personify.util.MapUtils;
import be.personify.util.SearchCriteria;
import be.personify.util.SearchCriterium;
import be.personify.util.SortCriteria;
import be.personify.util.SortCriterium;
import be.personify.util.SortOrder;
import be.personify.util.State;
import be.personify.util.StringUtils;
import be.personify.util.provisioning.TargetSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class DatabaseConnectorStorage
extends ConnectorStorage {
    private static final Logger logger = LogManager.getLogger(DatabaseConnectorStorage.class);
    private static TargetSystem targetSystem = null;
    private static Map<String, String> mapping;
    private static Map<String, String> depthMapping;
    private Schema schema = null;
    private List<String> schemaList = null;
    @Autowired
    private SchemaReader schemaReader;

    public void create(String id, Map<String, Object> scimObject) throws ConstraintViolationException, DataException {
        try {
            HashMap<String, String> extra = new HashMap<String, String>();
            extra.put("id", id);
            scimObject = this.processMapping(id, scimObject, extra, depthMapping, this.schema);
            logger.info("mapping {}", (Object)mapping);
            ProvisionResult result = new ProvisionTask().provision(State.PRESENT, scimObject, this.invertMap(mapping), targetSystem);
            if (!result.getStatus().equals((Object)ProvisionStatus.SUCCESS)) {
                throw new DataException(result.getErrorCode() + " " + result.getErrorDetail());
            }
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    public Map<String, Object> get(String id) {
        try (ConnectorConnection connection = null;){
            connection = ConnectorPool.getInstance().getConnectorForTargetSystem(targetSystem);
            Map nativeMap = connection.getConnector().find(id);
            if (nativeMap != null) {
                Map scimMap = this.convertNativeMap(nativeMap, mapping, depthMapping, Arrays.asList(new String[0]), this.schema);
                scimMap.put("schemas", this.schemaList);
                scimMap.put("id", id);
                Map map = scimMap;
                return map;
            }
            Map<String, Object> map = null;
            return map;
        }
    }

    public void update(String id, Map<String, Object> scimObject) throws ConstraintViolationException {
        try {
            HashMap<String, String> extra = new HashMap<String, String>();
            extra.put("id", id);
            scimObject = this.processMapping(id, scimObject, extra, depthMapping, this.schema);
            ProvisionResult result = new ProvisionTask().provision(State.PRESENT, scimObject, this.invertMap(mapping), targetSystem);
            if (!result.getStatus().equals((Object)ProvisionStatus.SUCCESS)) {
                throw new DataException(result.getErrorCode() + " " + result.getErrorDetail());
            }
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    public boolean delete(String id) {
        try (ConnectorConnection connection = null;){
            connection = ConnectorPool.getInstance().getConnectorForTargetSystem(targetSystem);
            boolean bl = connection.getConnector().delete(id);
            return bl;
        }
    }

    public List<Map> search(SearchCriteria searchCriteria, int start, int count, String sortBy, String sortOrderString) {
        return this.search(searchCriteria, start, count, sortBy, sortOrderString, null);
    }

    public List<Map> search(SearchCriteria searchCriteria, int start, int count, String sortBy, String sortOrderString, List<String> includeAttributes) {
        try (ConnectorConnection connection = null;){
            connection = ConnectorPool.getInstance().getConnectorForTargetSystem(targetSystem);
            logger.info("sortBy {} string {}", (Object)sortBy, (Object)sortOrderString);
            SortCriteria sortCriteria = null;
            if (!StringUtils.isEmpty((String)sortBy)) {
                if (StringUtils.isEmpty((String)sortOrderString)) {
                    sortOrderString = SortOrder.ascending.name();
                }
                sortCriteria = this.getNativeSortCriteria(new SortCriteria(new SortCriterium[]{new SortCriterium(sortBy, SortOrder.valueOf((String)sortOrderString))}));
            }
            logger.info("sortCriteria {}", sortCriteria);
            List nativeList = connection.getConnector().find(this.getNativeSearchCriteria(searchCriteria), start, count, sortCriteria);
            ArrayList<Map> scimList = new ArrayList<Map>();
            Map scimMap = null;
            List<String> excludes = Arrays.asList(new String[0]);
            for (Map nativeMap : nativeList) {
                scimMap = this.convertNativeMap(nativeMap, mapping, depthMapping, excludes, this.schema);
                scimMap.put("schemas", this.schemaList);
                scimMap.put("id", scimMap.get("id"));
                scimList.add(scimMap);
            }
            ArrayList<Map> arrayList = scimList;
            return arrayList;
        }
    }

    public long count(SearchCriteria searchCriteria) {
        try (ConnectorConnection connection = null;){
            connection = ConnectorPool.getInstance().getConnectorForTargetSystem(targetSystem);
            List nativeList = connection.getConnector().findIds(this.getNativeSearchCriteria(searchCriteria), 0, 0, null);
            long l = nativeList.size();
            return l;
        }
    }

    private SearchCriteria getNativeSearchCriteria(SearchCriteria searchCriteria) {
        SearchCriteria nativeSearchCriteria = new SearchCriteria(new SearchCriterium[0]);
        nativeSearchCriteria.setOperator(searchCriteria.getOperator());
        for (SearchCriterium criterium : searchCriteria.getCriteria()) {
            String nativeKey = (String)MapUtils.getKeyByValue((Map)mapping, (Object)criterium.getKey());
            nativeSearchCriteria.getCriteria().add(new SearchCriterium(nativeKey, criterium.getValue(), criterium.getSearchOperation()));
        }
        for (int i = 0; i < searchCriteria.getGroupedCriteria().size(); ++i) {
            nativeSearchCriteria.getGroupedCriteria().add(this.getNativeSearchCriteria((SearchCriteria)searchCriteria.getGroupedCriteria().get(i)));
        }
        return nativeSearchCriteria;
    }

    private SortCriteria getNativeSortCriteria(SortCriteria sortCriteria) {
        SortCriteria nativeSortCriteria = new SortCriteria(new SortCriterium[0]);
        for (SortCriterium criterium : sortCriteria.getCriteria()) {
            String nativeKey = (String)MapUtils.getKeyByValue((Map)mapping, (Object)criterium.getAttributeName());
            logger.info("native key {}", (Object)nativeKey);
            nativeSortCriteria.getCriteria().add(new SortCriterium(nativeKey, criterium.getSortOrder()));
        }
        return nativeSortCriteria;
    }

    public void initialize(String type) {
        try {
            Map config = this.getConfigMap("database");
            String targetSystemJson = Constants.objectMapper.writeValueAsString(config.get("targetSystem"));
            targetSystem = (TargetSystem)Constants.objectMapper.readValue(targetSystemJson, TargetSystem.class);
            mapping = (Map)config.get("mapping");
            if (mapping == null || targetSystem == null) {
                throw new ConfigurationException("can not find mapping or targetSystem in configuration");
            }
            this.schema = this.schemaReader.getSchemaByResourceType(type);
            this.schemaList = Arrays.asList(this.schema.getId());
            depthMapping = this.createDepthMapping(mapping);
            this.testConnection(targetSystem);
        }
        catch (Exception e) {
            logger.error("can not read/validate configuration for type {}", (Object)type, (Object)e);
            throw new ConfigurationException(e.getMessage());
        }
    }

    public synchronized void flush() {
    }

    public boolean deleteAll() {
        return false;
    }

    public Map<String, Object> get(String id, String version) {
        throw new RuntimeException("versioning not implemented");
    }

    public List<String> getVersions(String id) {
        throw new RuntimeException("versioning not implemented");
    }
}

