/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.storage.impl;

import be.personify.iam.provisioning.ProvisionResult;
import be.personify.iam.provisioning.ProvisionStatus;
import be.personify.iam.provisioning.ProvisionTask;
import be.personify.iam.provisioning.connectors.ConnectorConnection;
import be.personify.iam.provisioning.connectors.ConnectorPool;
import be.personify.iam.scim.schema.Schema;
import be.personify.iam.scim.schema.SchemaReader;
import be.personify.iam.scim.storage.ConfigurationException;
import be.personify.iam.scim.storage.ConstraintViolationException;
import be.personify.iam.scim.storage.DataException;
import be.personify.iam.scim.storage.impl.ConnectorStorage;
import be.personify.iam.scim.util.Constants;
import be.personify.util.MapUtils;
import be.personify.util.SearchCriteria;
import be.personify.util.SearchCriterium;
import be.personify.util.State;
import be.personify.util.provisioning.TargetSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class LDAPConnectorStorage
extends ConnectorStorage {
    private static final String OBJECT_CLASS = "objectClass";
    private static final String CN = "cn=";
    private static final Logger logger = LogManager.getLogger(LDAPConnectorStorage.class);
    private String basedn = null;
    private static TargetSystem targetSystem = null;
    private static Map<String, String> mapping;
    private static Map<String, String> depthMapping;
    private List<String> objectClasses = null;
    private Schema schema = null;
    private List<String> schemaList = null;
    @Autowired
    private SchemaReader schemaReader;

    public void create(String id, Map<String, Object> scimObject) throws ConstraintViolationException, DataException {
        try {
            HashMap<String, Object> extra = new HashMap<String, Object>();
            extra.put("id", this.composeDn(id));
            extra.put(OBJECT_CLASS, this.objectClasses);
            scimObject = this.processMapping(id, scimObject, extra, depthMapping, this.schema);
            ProvisionResult result = new ProvisionTask().provision(State.PRESENT, scimObject, mapping, targetSystem);
            if (!result.getStatus().equals((Object)ProvisionStatus.SUCCESS)) {
                throw new DataException(result.getErrorCode() + " " + result.getErrorDetail());
            }
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    public Map<String, Object> get(String id) {
        try (ConnectorConnection connection = null;){
            connection = ConnectorPool.getInstance().getConnectorForTargetSystem(targetSystem);
            Map nativeMap = connection.getConnector().find(this.composeDn(id));
            if (nativeMap != null) {
                Map scimMap = this.convertNativeMap(nativeMap, mapping, depthMapping, Arrays.asList(OBJECT_CLASS), this.schema);
                scimMap.put("schemas", this.schemaList);
                scimMap.put("id", id);
                Map map = scimMap;
                return map;
            }
            Map<String, Object> map = null;
            return map;
        }
    }

    public void update(String id, Map<String, Object> scimObject) throws ConstraintViolationException {
        try {
            HashMap<String, Object> extra = new HashMap<String, Object>();
            extra.put("id", this.composeDn(id));
            extra.put(OBJECT_CLASS, this.objectClasses);
            scimObject = this.processMapping(id, scimObject, extra, depthMapping, this.schema);
            ProvisionResult result = new ProvisionTask().provision(State.PRESENT, scimObject, mapping, targetSystem);
            if (!result.getStatus().equals((Object)ProvisionStatus.SUCCESS)) {
                throw new DataException(result.getErrorCode() + " " + result.getErrorDetail());
            }
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    public boolean delete(String id) {
        try (ConnectorConnection connection = null;){
            connection = ConnectorPool.getInstance().getConnectorForTargetSystem(targetSystem);
            boolean bl = connection.getConnector().delete(this.composeDn(id));
            return bl;
        }
    }

    public List<Map> search(SearchCriteria searchCriteria, int start, int count, String sortBy, String sortOrderString) {
        return this.search(searchCriteria, start, count, sortBy, sortOrderString, null);
    }

    public List<Map> search(SearchCriteria searchCriteria, int start, int count, String sortBy, String sortOrderString, List<String> includeAttributes) {
        try (ConnectorConnection connection = null;){
            SearchCriteria nativeSearchCriteria = this.getNativeSearchCriteria(searchCriteria);
            connection = ConnectorPool.getInstance().getConnectorForTargetSystem(targetSystem);
            List nativeList = connection.getConnector().find(nativeSearchCriteria, start, count, null);
            ArrayList<Map> scimList = new ArrayList<Map>();
            for (Map nativeMap : nativeList) {
                Map scimMap = this.convertNativeMap(nativeMap, mapping, depthMapping, Arrays.asList(OBJECT_CLASS), this.schema);
                scimMap.put("schemas", this.schemaList);
                scimMap.put("id", this.decomposeDn(scimMap.get("id")));
                scimList.add(scimMap);
            }
            ArrayList<Map> arrayList = scimList;
            return arrayList;
        }
    }

    public long count(SearchCriteria searchCriteria) {
        try (ConnectorConnection connection = null;){
            SearchCriteria nativeSearchCriteria = this.getNativeSearchCriteria(searchCriteria);
            connection = ConnectorPool.getInstance().getConnectorForTargetSystem(targetSystem);
            List nativeList = connection.getConnector().findIds(nativeSearchCriteria, 0, 0, null);
            long l = nativeList.size();
            return l;
        }
    }

    private SearchCriteria getNativeSearchCriteria(SearchCriteria searchCriteria) {
        SearchCriteria nativeSearchCriteria = new SearchCriteria(new SearchCriterium[0]);
        for (SearchCriterium criterium : searchCriteria.getCriteria()) {
            String nativeKey = (String)MapUtils.getKeyByValue((Map)mapping, (Object)criterium.getKey());
            nativeSearchCriteria.getCriteria().add(new SearchCriterium(nativeKey, criterium.getValue(), criterium.getSearchOperation()));
        }
        return nativeSearchCriteria;
    }

    private String composeDn(String id) {
        return CN + id + "," + this.basedn;
    }

    private String decomposeDn(Object id) {
        if (id instanceof List) {
            String firstId = (String)((List)id).get(0);
            return firstId.substring(CN.length(), firstId.indexOf(","));
        }
        return null;
    }

    public void initialize(String type) {
        try {
            Map config = this.getConfigMap("ldap");
            String targetSystemJson = Constants.objectMapper.writeValueAsString(config.get("targetSystem"));
            targetSystem = (TargetSystem)Constants.objectMapper.readValue(targetSystemJson, TargetSystem.class);
            this.basedn = (String)targetSystem.getConnectorConfiguration().getConfiguration().get("baseDn");
            this.basedn = "ou=" + type.toLowerCase() + "," + this.basedn;
            targetSystem.getConnectorConfiguration().getConfiguration().put("baseDn", this.basedn);
            mapping = (Map)config.get("mapping");
            if (mapping == null || targetSystem == null) {
                throw new ConfigurationException("can not find mapping or targetSystem in configuration");
            }
            this.objectClasses = Arrays.asList(((String)targetSystem.getConnectorConfiguration().getConfiguration().get(type.toLowerCase() + "ObjectClasses")).split(","));
            this.schema = this.schemaReader.getSchemaByResourceType(type);
            this.schemaList = Arrays.asList(this.schema.getId());
            depthMapping = this.createDepthMapping(mapping);
            this.testConnection(targetSystem);
        }
        catch (Exception e) {
            logger.error("can not read/validate configuration for type {}", (Object)type, (Object)e);
            throw new ConfigurationException(e.getMessage());
        }
    }

    public synchronized void flush() {
        throw new DataException("flush all not implemented");
    }

    public boolean deleteAll() {
        throw new DataException("delete all not implemented");
    }

    public Map<String, Object> get(String id, String version) {
        throw new DataException("versioning not implemented");
    }

    public List<String> getVersions(String id) {
        throw new DataException("versioning not implemented");
    }
}

