/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.storage.impl;

import be.personify.iam.scim.storage.ConstraintViolationException;
import be.personify.iam.scim.storage.Storage;
import be.personify.iam.scim.storage.util.MemoryStorageUtil;
import be.personify.iam.scim.util.Constants;
import be.personify.iam.scim.util.PropertyFactory;
import be.personify.util.SearchCriteria;
import be.personify.util.SearchCriterium;
import be.personify.util.SortOrder;
import be.personify.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class MemoryStorage
implements Storage {
    @Autowired
    private PropertyFactory propertyFactory;
    private static final Logger logger = LogManager.getLogger(MemoryStorage.class);
    private Map<String, Map<String, Object>> storage = null;
    private List<String> uniqueConstraintsList = new ArrayList();
    private Map<String, Map<Object, Object>> uniqueConstraints = null;
    private String type;

    public Map<String, Object> get(String id) {
        return (Map)this.storage.get(id);
    }

    public Map<String, Object> get(String id, String version) {
        throw new RuntimeException("versioning not implemented");
    }

    public List<String> getVersions(String id) {
        throw new RuntimeException("versioning not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(String id, Map<String, Object> object) throws ConstraintViolationException {
        this.checkConstraints(id, object);
        Map map = this.storage;
        synchronized (map) {
            this.storage.put(id, object);
        }
        this.updateConstraints(id, object);
    }

    public void update(String id, Map<String, Object> object) throws ConstraintViolationException {
        this.checkConstraints(id, object);
        this.storage.put(id, object);
        this.updateConstraints(id, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String id) {
        boolean removed = false;
        Map map = this.storage;
        synchronized (map) {
            removed = this.storage.remove(id) != null;
        }
        this.removeConstraints(id);
        return removed;
    }

    public List<Map> search(SearchCriteria searchCriteria, int start, int count, String sortBy, String sortOrderString) {
        return this.search(searchCriteria, start, count, sortBy, sortOrderString, null);
    }

    public List<Map> search(SearchCriteria searchCriteria, int start, int count, String sortBy, String sortOrderString, List<String> includeAttributes) {
        int newEnd;
        SortOrder sortOrder;
        List<Object> result = null;
        if (searchCriteria == null || searchCriteria.getCriteria() == null || searchCriteria.size() == 0) {
            result = new ArrayList(this.storage.values());
        } else {
            logger.debug("{}", (Object)searchCriteria);
            result = this.filterOnSearchCriteria(searchCriteria);
        }
        if (StringUtils.isEmpty((String)sortOrderString)) {
            sortOrderString = SortOrder.ascending.name();
            logger.debug("defaulting to sortorder {}", (Object)sortOrderString);
        }
        count = count > (result = this.sort(result, sortBy, sortOrder = SortOrder.valueOf((String)sortOrderString))).size() ? result.size() : count;
        logger.info("count {} start {}", (Object)count, (Object)start);
        int newStart = start - 1;
        if (newStart > result.size()) {
            newStart = result.size();
        }
        if ((newEnd = newStart + count) > result.size()) {
            newEnd = result.size();
        }
        List<Object> sublist = result.subList(newStart, newEnd);
        return sublist;
    }

    public long count(SearchCriteria searchCriteria) {
        long totalCount = 0L;
        if (searchCriteria == null || searchCriteria.getCriteria().size() == 0) {
            return this.storage.values().size();
        }
        int count = 0;
        ArrayList<String> criteriaFoundInConstraints = new ArrayList<String>();
        for (SearchCriterium criterium : searchCriteria.getCriteria()) {
            Map m = (Map)this.uniqueConstraints.get(criterium.getKey());
            if (m == null) continue;
            String id = (String)m.get(criterium.getValue());
            if (id != null && !criteriaFoundInConstraints.contains(id)) {
                criteriaFoundInConstraints.add(id);
            }
            ++count;
        }
        if (count < searchCriteria.size()) {
            logger.debug("not all criteria are found in constraints");
            for (Map object : this.storage.values()) {
                if (!MemoryStorageUtil.objectMatchesCriteria((SearchCriteria)searchCriteria, (Map)object)) continue;
                ++totalCount;
            }
        } else {
            totalCount = criteriaFoundInConstraints.size();
        }
        return totalCount;
    }

    private List<Map> filterOnSearchCriteria(SearchCriteria searchCriteria) {
        ArrayList<Map> result = new ArrayList<Map>();
        int count = 0;
        ArrayList<String> criteriaFoundInConstraints = new ArrayList<String>();
        for (SearchCriterium criterium : searchCriteria.getCriteria()) {
            Map m = (Map)this.uniqueConstraints.get(criterium.getKey());
            if (m == null) continue;
            String id = (String)m.get(criterium.getValue());
            if (id != null && !criteriaFoundInConstraints.contains(id)) {
                criteriaFoundInConstraints.add(id);
            }
            ++count;
        }
        if (count < searchCriteria.size()) {
            logger.debug("not all criteria are found in the constraints");
            for (Map object : this.storage.values()) {
                if (!MemoryStorageUtil.objectMatchesCriteria((SearchCriteria)searchCriteria, (Map)object)) continue;
                result.add(object);
            }
        } else {
            for (String s : criteriaFoundInConstraints) {
                Map mm = (Map)this.storage.get(s);
                result.add(mm);
            }
        }
        return result;
    }

    private List<Map> sort(List<Map> result, String sortBy, SortOrder sortOrder) {
        if (!StringUtils.isEmpty((String)sortBy)) {
            Collections.sort(result, new /* Unavailable Anonymous Inner Class!! */);
        }
        return result;
    }

    public void initialize(String type) {
        this.type = type;
        File f = this.getStorageFile();
        this.initializeUniqueConstraints(type);
        logger.info("checking for file {}", (Object)f.getAbsolutePath());
        if (f.exists()) {
            logger.info("{} exists, trying to read", (Object)f.getAbsolutePath());
            try {
                long start = System.currentTimeMillis();
                this.storage = (Map)Constants.objectMapper.readValue(f, Map.class);
                this.buildConstraints(this.storage);
                logger.info("{} read in {} ms", (Object)f.getAbsolutePath(), (Object)(System.currentTimeMillis() - start));
            }
            catch (IOException e) {
                logger.error("can not read file {}", (Object)f.getAbsolutePath(), (Object)e);
                this.storage = null;
            }
        } else {
            this.storage = new HashMap();
        }
    }

    private void initializeUniqueConstraints(String type) {
        String uniqueConstraintsString;
        this.uniqueConstraints = new HashMap();
        if (this.propertyFactory != null && !StringUtils.isEmpty((String)(uniqueConstraintsString = this.propertyFactory.getProperty("scim.storage.memory." + type.toLowerCase() + ".unique")))) {
            this.uniqueConstraintsList = Arrays.asList(uniqueConstraintsString.split(","));
            for (String u : this.uniqueConstraintsList) {
                this.uniqueConstraints.put(u, new HashMap());
            }
        }
    }

    private void buildConstraints(Map<String, Map<String, Object>> map) {
        for (String key : map.keySet()) {
            Map<String, Object> entity = map.get(key);
            Object id = entity.get("id");
            for (String constraint : this.uniqueConstraintsList) {
                Object o = entity.get(constraint);
                if (o == null) continue;
                ((Map)this.uniqueConstraints.get(constraint)).put(o, id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConstraints(String id, Map<String, Object> object) throws ConstraintViolationException {
        Map map = this.uniqueConstraints;
        synchronized (map) {
            for (String constraint : this.uniqueConstraintsList) {
                Object valueFromEntity = object.get(constraint);
                Object valueFromConstraintCache = ((Map)this.uniqueConstraints.get(constraint)).get(valueFromEntity);
                if (valueFromConstraintCache == null || valueFromConstraintCache.equals(id)) continue;
                throw new ConstraintViolationException("the value " + valueFromEntity + " already exists for the attribute " + constraint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConstraints(String id, Map<String, Object> object) {
        Map map = this.uniqueConstraints;
        synchronized (map) {
            for (String constraint : this.uniqueConstraintsList) {
                Object valueFromEntity = object.get(constraint);
                if (valueFromEntity == null) continue;
                ((Map)this.uniqueConstraints.get(constraint)).put(valueFromEntity, id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConstraints(String id) {
        for (String constraint : this.uniqueConstraintsList) {
            if (!((Map)this.uniqueConstraints.get(constraint)).containsValue(id)) continue;
            Map map = this.uniqueConstraints;
            synchronized (map) {
                ((Map)this.uniqueConstraints.get(constraint)).values().remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush() {
        Boolean flush = Boolean.valueOf(this.propertyFactory.getProperty("scim.storage.flush"));
        if (flush.booleanValue()) {
            logger.debug("flushing");
            File f = this.getStorageFile();
            logger.debug("saving to file {}", (Object)f.getAbsolutePath());
            try {
                long start = System.currentTimeMillis();
                Map map = this.storage;
                synchronized (map) {
                    Constants.objectMapper.writeValue(f, (Object)this.storage);
                }
                logger.debug("{} saved in {} ms", (Object)f.getAbsolutePath(), (Object)(System.currentTimeMillis() - start));
            }
            catch (IOException e) {
                logger.error("can not flush", (Throwable)e);
            }
        } else {
            logger.info("flush not configured");
        }
    }

    public boolean deleteAll() {
        this.storage.clear();
        for (String constraint : this.uniqueConstraintsList) {
            ((Map)this.uniqueConstraints.get(constraint)).clear();
        }
        this.flush();
        return true;
    }

    private File getStorageFile() {
        File directory;
        String dir;
        if (this.propertyFactory != null && (dir = this.propertyFactory.getProperty("scim.storage.memory.flushToFileDirectory")) != null && (directory = new File(dir)).exists() && directory.isDirectory()) {
            return new File(directory, "personify-scim-" + this.type.toLowerCase() + ".dump");
        }
        return new File(Constants.tempDir, "personify-scim-" + this.type.toLowerCase() + ".dump");
    }
}

