/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.storage.impl;

import be.personify.iam.scim.schema.Schema;
import be.personify.iam.scim.schema.SchemaAttribute;
import be.personify.iam.scim.schema.SchemaReader;
import be.personify.iam.scim.storage.ConstraintViolationException;
import be.personify.iam.scim.storage.DataException;
import be.personify.iam.scim.storage.Storage;
import be.personify.util.LogicalOperator;
import be.personify.util.SearchCriteria;
import be.personify.util.SearchCriterium;
import be.personify.util.SearchOperation;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoWriteException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class MongoStorage
implements Storage {
    private static final Logger logger = LogManager.getLogger(MongoStorage.class);
    @Value(value="${scim.storage.mongo.constr}")
    private String constr;
    @Value(value="${scim.storage.mongo.connectionTimeout:5000}")
    private int connectionTimeout;
    @Value(value="${scim.storage.mongo.readTimeout:5000}")
    private int readTimeout;
    @Value(value="${scim.storage.mongo.maxConnectionPoolSize:4}")
    private int maxConnectionPoolSize;
    @Value(value="${scim.storage.mongo.serverSelectionTimeout:5000}")
    private int serverSelectionTimeout;
    @Value(value="${scim.storage.mongo.sslEnabled:false}")
    private boolean sslEnabled;
    @Value(value="${scim.storage.mongo.database}")
    private String database = "scim-database";
    @Value(value="${scim.storage.mongo.collection.users}")
    private String userCollection = "users";
    @Value(value="${scim.storage.mongo.collection.groups}")
    private String groupCollection = "groups";
    private String type = null;
    @Autowired
    private SchemaReader schemaReader;
    private MongoClient client;
    private static final String oid = "_id";
    private static final String $set = "$set";
    private static final String $regex = "$regex";
    private static final String start = "^";
    private static final String end = "$";
    private static final String minus = "-1";
    private static final String descending = "descending";
    private MongoCollection<Document> col;

    public Map<String, Object> get(String id) {
        Document doc = (Document)this.col.find((Bson)new Document(oid, (Object)id)).first();
        logger.info("doc {}", (Object)doc);
        if (doc != null) {
            doc.remove((Object)oid);
            doc.put("id", (Object)id);
        }
        return this.unsafetyfyAttributes(doc);
    }

    public Map<String, Object> get(String id, String version) {
        Document query = new Document(oid, (Object)id).append("meta", (Object)new Document("version", (Object)version));
        Document doc = (Document)this.col.find((Bson)query).first();
        if (doc != null) {
            doc.remove((Object)oid);
            doc.put("id", (Object)id);
        }
        return this.unsafetyfyAttributes(doc);
    }

    public List<String> getVersions(String id) {
        ArrayList<String> vs = new ArrayList<String>();
        Document query = new Document(oid, (Object)id);
        Document doc = (Document)this.col.find((Bson)query).first();
        if (doc != null) {
            vs.add(this.unsafetyfyAttributes((Document)doc.get((Object)"meta")).getString((Object)"version"));
        }
        return vs;
    }

    public boolean delete(String id) {
        return this.col.findOneAndDelete((Bson)new Document(oid, (Object)id)) != null;
    }

    public boolean deleteAll() {
        this.col.drop();
        return true;
    }

    public void create(String id, Map<String, Object> object) throws ConstraintViolationException {
        object = this.safetyfyAttributes(object);
        Document doc = new Document(object);
        boolean found = this.entryExists(id);
        doc.remove((Object)"id");
        doc.put(oid, (Object)id);
        try {
            if (!found) {
                this.col.insertOne((Object)doc);
            } else {
                this.col.findOneAndUpdate((Bson)new Document(oid, (Object)id), (Bson)new Document($set, (Object)doc));
            }
        }
        catch (MongoWriteException mwe) {
            throw new DataException(mwe.getError().getMessage());
        }
    }

    private boolean entryExists(String id) {
        boolean found = false;
        ArrayList<Document> vlist = new ArrayList<Document>();
        vlist.add(new Document(oid, (Object)id));
        Document filter = new Document("$or", vlist);
        if (this.col.find((Bson)filter).first() != null) {
            found = true;
        }
        return found;
    }

    public void update(String id, Map<String, Object> object) {
        object = this.safetyfyAttributes(object);
        Document doc = new Document(object);
        Document query = new Document(oid, (Object)id);
        doc.remove((Object)"id");
        this.col.findOneAndUpdate((Bson)query, (Bson)new Document($set, (Object)doc));
    }

    public List<Map> search(SearchCriteria searchCriteria, int start, int count, String sortBy, String sortOrder) {
        return this.search(searchCriteria, start, count, sortBy, sortOrder, null);
    }

    public List<Map> search(SearchCriteria searchCriteria, int start, int count, String sortBy, String sortOrder, List<String> includeAttributes) {
        logger.info("searchcriteria {}", (Object)searchCriteria);
        FindIterable finds = this.find(start, count, includeAttributes, this.getCriteria(searchCriteria));
        logger.info("finds {}", (Object)finds);
        this.sort(sortBy, sortOrder, finds);
        ArrayList<Map> all = new ArrayList<Map>();
        String id = null;
        for (Document doc : finds) {
            id = ((String)doc.remove((Object)oid)).toString();
            doc.put("id", (Object)id);
            all.add((Map)this.unsafetyfyAttributes(doc));
        }
        return all;
    }

    private FindIterable<Document> find(int start, int count, List<String> includeAttributes, Bson query) {
        FindIterable finds;
        int skip = start - 1;
        if (includeAttributes != null) {
            Document projection = new Document();
            for (String includeAttribute : includeAttributes) {
                projection.append(includeAttribute, (Object)1);
            }
            finds = this.col.find(query).projection((Bson)projection).skip(skip).limit(count);
        } else {
            finds = this.col.find(query).skip(skip).limit(count);
        }
        return finds;
    }

    private void sort(String sortBy, String sortOrder, FindIterable<Document> finds) {
        if (sortBy != null) {
            int order = 1;
            if (sortOrder != null && (descending.equals(sortOrder) || minus.equals(sortOrder))) {
                order = -1;
            }
            finds.sort((Bson)new Document(sortBy, (Object)order));
        }
    }

    public long count(SearchCriteria searchCriteria) {
        return this.col.countDocuments(this.getCriteria(searchCriteria));
    }

    private Bson getCriteria(SearchCriteria searchCriteria) {
        if (searchCriteria != null) {
            ArrayList<Bson> crit = new ArrayList<Bson>();
            for (SearchCriterium sc : searchCriteria.getCriteria()) {
                crit.add(this.getCriterium(sc));
            }
            for (SearchCriterium sc : searchCriteria.getGroupedCriteria()) {
                crit.add(this.getCriteria((SearchCriteria)sc));
            }
            if (crit.size() > 0) {
                if (searchCriteria.getOperator().equals((Object)LogicalOperator.AND)) {
                    return Filters.and(crit);
                }
                if (searchCriteria.getOperator().equals((Object)LogicalOperator.OR)) {
                    return Filters.or(crit);
                }
            }
        }
        return new Document();
    }

    private Bson getCriterium(SearchCriterium sc) {
        SearchOperation op = sc.getSearchOperation();
        String key = this.safeName(sc.getKey());
        if (SearchOperation.EQUALS.equals((Object)op)) {
            return Filters.eq((String)key, (Object)sc.getValue());
        }
        if (SearchOperation.NOT_EQUALS.equals((Object)op)) {
            return Filters.ne((String)key, (Object)sc.getValue());
        }
        if (SearchOperation.CONTAINS.equals((Object)op)) {
            return Filters.eq((String)key, (Object)new Document($regex, sc.getValue()));
        }
        if (SearchOperation.STARTS_WITH.equals((Object)op)) {
            return Filters.eq((String)key, (Object)new Document($regex, (Object)this.startRgx((String)sc.getValue())));
        }
        if (SearchOperation.ENDS_WITH.equals((Object)op)) {
            return Filters.eq((String)key, (Object)new Document($regex, (Object)this.endRgx((String)sc.getValue())));
        }
        if (SearchOperation.PRESENT.equals((Object)op)) {
            return Filters.exists((String)key);
        }
        if (SearchOperation.GREATER_THEN.equals((Object)op)) {
            return Filters.gt((String)key, (Object)sc.getValue());
        }
        if (SearchOperation.GREATER_THEN_OR_EQUAL.equals((Object)op)) {
            return Filters.gte((String)key, (Object)sc.getValue());
        }
        if (SearchOperation.LESS_THEN.equals((Object)op)) {
            return Filters.lt((String)key, (Object)sc.getValue());
        }
        if (SearchOperation.LESS_THEN_EQUAL.equals((Object)op)) {
            return Filters.lte((String)key, (Object)sc.getValue());
        }
        throw new DataException("the operator " + op.name() + " is not implemented");
    }

    private String startRgx(String value) {
        return start + value;
    }

    private String endRgx(String value) {
        return value + end;
    }

    public void flush() {
    }

    public void initialize(String type) {
        this.type = type;
        logger.info("initializing store of type {}", (Object)type);
        this.client = MongoClients.create((MongoClientSettings)this.getMongoClientSettings());
        if (type.equals("User")) {
            this.col = this.client.getDatabase(this.database).getCollection(this.userCollection);
        } else if (type.equalsIgnoreCase("Group")) {
            this.col = this.client.getDatabase(this.database).getCollection(this.groupCollection);
        } else {
            throw new DataException("the type " + type + " is not a valid resource type");
        }
        this.createUniqueIndexes(type);
    }

    private MongoClientSettings getMongoClientSettings() {
        return MongoClientSettings.builder().applyToSocketSettings(builder -> {
            builder.connectTimeout(this.connectionTimeout, TimeUnit.MILLISECONDS);
            builder.readTimeout(this.readTimeout, TimeUnit.MILLISECONDS);
        }).applyToClusterSettings(builder -> builder.serverSelectionTimeout((long)this.serverSelectionTimeout, TimeUnit.MILLISECONDS)).applyToConnectionPoolSettings(builder -> builder.maxSize(this.maxConnectionPoolSize)).applyConnectionString(new ConnectionString(this.constr)).applyToSslSettings(builder -> builder.enabled(this.sslEnabled)).build();
    }

    private void createUniqueIndexes(String type) {
        try {
            Schema schema = this.schemaReader.getSchemaByResourceType(type);
            for (SchemaAttribute a : schema.getAttributes()) {
                if (a.getUniqueness() == null || !a.getUniqueness().equalsIgnoreCase("server") && !a.getUniqueness().equalsIgnoreCase("global")) continue;
                logger.info("creating index for type {} and attribute [{}]", (Object)type, (Object)a.getName());
                this.col.createIndex(Indexes.descending((String[])new String[]{a.getName()}), new IndexOptions().background(true).unique(true));
            }
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    public Map<String, Object> safetyfyAttributes(Map<String, Object> map) {
        if (this.type.equalsIgnoreCase("Group")) {
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            for (String key : map.keySet()) {
                ArrayList o = map.get(key);
                if (o instanceof Map) {
                    o = this.safetyfyAttributes((Map)((Object)o));
                } else if (o instanceof List) {
                    ArrayList newList = new ArrayList();
                    for (Object oo : (List)o) {
                        if (oo instanceof Map) {
                            oo = this.safetyfyAttributes((Map)oo);
                        }
                        newList.add(oo);
                    }
                    o = newList;
                }
                newMap.put(this.safeName(key), o);
            }
            return newMap;
        }
        return map;
    }

    private String safeName(String name) {
        if (name.startsWith(end)) {
            name = "_" + name;
        }
        return name;
    }

    public Document unsafetyfyAttributes(Document map) {
        if (this.type.equalsIgnoreCase("Group") && map != null) {
            Document newMap = new Document();
            for (String key : map.keySet()) {
                ArrayList o = map.get((Object)key);
                if (o instanceof Document) {
                    o = this.unsafetyfyAttributes((Document)o);
                } else if (o instanceof List) {
                    ArrayList newList = new ArrayList();
                    for (Object oo : (List)o) {
                        if (oo instanceof Document) {
                            oo = this.unsafetyfyAttributes((Document)oo);
                        }
                        newList.add(oo);
                    }
                    o = newList;
                }
                if (key.startsWith("_$")) {
                    key = key.substring(1, key.length());
                }
                newMap.put(key, (Object)o);
            }
            return newMap;
        }
        return map;
    }
}

