/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.storage.impl;

import be.personify.iam.scim.storage.ConfigurationException;
import be.personify.iam.scim.storage.ConstraintViolationException;
import be.personify.iam.scim.storage.DataException;
import be.personify.iam.scim.storage.Storage;
import be.personify.util.SearchCriteria;
import be.personify.util.SearchCriterium;
import be.personify.util.SearchOperation;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBConfigBuilder;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Value;

public class OrientDBStorage
implements Storage,
DisposableBean {
    private static final String ORIENT_OPERATOR_PRESENT = " is not null ";
    private static final String ORIENT_OPERATOR_NOT_EQUALS = " <> ";
    private static final String ORIENT_OPERATOR_EQUALS = " = ";
    private static final String ORIENT_OPERATOR_GT = " > ";
    private static final String ORIENT_OPERATOR_GTE = " >= ";
    private static final String ORIENT_OPERATOR_LT = " < ";
    private static final String ORIENT_OPERATOR_LTE = " <= ";
    private static final Logger logger = LogManager.getLogger(OrientDBStorage.class);
    private String type;
    @Value(value="${scim.storage.orientdb.url}")
    private String url;
    @Value(value="${scim.storage.orientdb.database}")
    private String database;
    @Value(value="${scim.storage.orientdb.user}")
    private String user;
    @Value(value="${scim.storage.orientdb.password}")
    private String password;
    @Value(value="${scim.storage.orientdb.poolMin}")
    private int poolMin;
    @Value(value="${scim.storage.orientdb.poolMin}")
    private int poolMax;
    @Value(value="${scim.storage.orientdb.uniqueIndexes}")
    private String uniqueIndexes;
    @Value(value="${scim.storage.orientdb.indexes}")
    private String indexes;
    private static OrientDB orientDB;
    private static ODatabasePool pool;
    private String queryAll = null;
    private String queryDelete = null;
    private String queryFindById = null;
    private String querySelectCount = null;

    public Map<String, Object> get(String id) {
        try (ODatabaseSession db = pool.acquire();){
            OResultSet result = db.query(this.queryFindById, new Object[]{id});
            if (result.hasNext()) {
                Map map = this.resultToMap(result.next());
                return map;
            }
        }
        return null;
    }

    public boolean delete(String id) {
        try (ODatabaseSession db = pool.acquire();){
            db.command(this.queryDelete, new Object[]{id});
            boolean bl = true;
            return bl;
        }
    }

    public boolean deleteAll() {
        try (ODatabaseSession db = pool.acquire();){
            db.command("delete from " + this.type, new Object[0]);
            boolean bl = true;
            return bl;
        }
    }

    public void create(String id, Map<String, Object> object) throws ConstraintViolationException {
        try (ODatabaseSession db = pool.acquire();){
            ODocument doc = new ODocument(this.type);
            for (String key : object.keySet()) {
                doc.field(key, object.get(key));
            }
            doc.save();
        }
        catch (ORecordDuplicatedException dup) {
            throw new ConstraintViolationException(dup.getMessage());
        }
    }

    public void update(String id, Map<String, Object> object) {
        try (ODatabaseSession db = pool.acquire();){
            OSQLSynchQuery query = new OSQLSynchQuery("select * from " + this.type + " where id = :id");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", id);
            List result = (List)db.command((OCommandRequest)query).execute(new Object[]{params});
            for (ODocument doc : result) {
                for (String key : object.keySet()) {
                    doc.field(key, object.get(key));
                }
                doc.save();
            }
        }
    }

    public List<Map> search(SearchCriteria searchCriteria, int start, int count, String sortBy, String sortOrder) {
        return this.search(searchCriteria, start, count, sortBy, sortOrder, null);
    }

    public List<Map> search(SearchCriteria searchCriteria, int start, int count, String sortBy, String sortOrder, List<String> includeAttributes) {
        try (ODatabaseSession db = pool.acquire();){
            String qquery = this.queryAll;
            if (includeAttributes != null) {
                logger.info("includeAttributes present");
                StringBuffer b = new StringBuffer("select ");
                for (int i = 0; i < includeAttributes.size(); ++i) {
                    b.append(includeAttributes.get(i));
                    if (i == includeAttributes.size() - 1) continue;
                    b.append(",");
                }
                b.append(" from " + this.type + " ");
                qquery = b.toString();
            }
            StringBuilder builder = new StringBuilder(qquery);
            String query = this.constructQuery(searchCriteria, builder);
            List objects = this.composeParameters(searchCriteria);
            logger.debug("query {}", (Object)query);
            OResultSet result = db.query(query, new Object[]{objects});
            ArrayList<Map> resultList = new ArrayList<Map>();
            while (result.hasNext()) {
                resultList.add(this.resultToMap(result.next()));
            }
            ArrayList<Map> arrayList = resultList;
            return arrayList;
        }
    }

    public long count(SearchCriteria searchCriteria) {
        try (ODatabaseSession db = pool.acquire();){
            StringBuilder builder = new StringBuilder(this.querySelectCount);
            String query = this.constructQuery(searchCriteria, builder);
            List objects = this.composeParameters(searchCriteria);
            OResultSet result = db.query(query, new Object[]{objects});
            if (result.hasNext()) {
                long l = (Long)result.next().getProperty("count");
                return l;
            }
        }
        return 0L;
    }

    private List<Object> composeParameters(SearchCriteria searchCriteria) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (SearchCriterium c : searchCriteria.getCriteria()) {
            if (c.getSearchOperation().getParts() != 3) continue;
            objects.add(c.getValue());
        }
        return objects;
    }

    private String constructQuery(SearchCriteria searchCriteria, StringBuilder sb) {
        if (searchCriteria != null && searchCriteria.size() > 0) {
            sb.append(" where ");
            SearchCriterium criterium = null;
            for (int i = 0; i < searchCriteria.size(); ++i) {
                criterium = (SearchCriterium)searchCriteria.getCriteria().get(i);
                sb.append(criterium.getKey());
                sb.append(this.searchOperationToString(criterium.getSearchOperation()));
                if (criterium.getSearchOperation().getParts() == 3) {
                    sb.append(" ? ");
                }
                if (i >= searchCriteria.size() - 1) continue;
                sb.append(" and ");
            }
        }
        return sb.toString();
    }

    private Object searchOperationToString(SearchOperation searchOperation) {
        if (searchOperation.equals((Object)SearchOperation.EQUALS)) {
            return ORIENT_OPERATOR_EQUALS;
        }
        if (searchOperation.equals((Object)SearchOperation.NOT_EQUALS)) {
            return ORIENT_OPERATOR_NOT_EQUALS;
        }
        if (searchOperation.equals((Object)SearchOperation.PRESENT)) {
            return ORIENT_OPERATOR_PRESENT;
        }
        if (searchOperation.equals((Object)SearchOperation.GREATER_THEN)) {
            return ORIENT_OPERATOR_GT;
        }
        if (searchOperation.equals((Object)SearchOperation.GREATER_THEN_OR_EQUAL)) {
            return ORIENT_OPERATOR_GTE;
        }
        if (searchOperation.equals((Object)SearchOperation.LESS_THEN)) {
            return ORIENT_OPERATOR_LT;
        }
        if (searchOperation.equals((Object)SearchOperation.LESS_THEN_EQUAL)) {
            return ORIENT_OPERATOR_LTE;
        }
        throw new DataException("operator " + searchOperation + " not yet implemented");
    }

    public void flush() {
    }

    public void initialize(String type) {
        this.type = type;
        try {
            if (orientDB == null) {
                orientDB = new OrientDB(this.url, this.user, this.password, OrientDBConfig.defaultConfig());
                orientDB.createIfNotExists(this.database, ODatabaseType.PLOCAL, OrientDBConfig.defaultConfig());
                OrientDBConfigBuilder poolCfg = OrientDBConfig.builder();
                poolCfg.addConfig(OGlobalConfiguration.DB_POOL_MIN, (Object)this.poolMin);
                poolCfg.addConfig(OGlobalConfiguration.DB_POOL_MAX, (Object)this.poolMax);
                pool = new ODatabasePool(orientDB, this.database, this.user, this.password, poolCfg.build());
                try (ODatabaseSession db = pool.acquire();){
                    OSchema schema = db.getMetadata().getSchema();
                    if (!schema.existsClass(type)) {
                        String[] indexesArray;
                        String[] uniqueIndexesArray;
                        logger.info("schema does not exist, trying to create schema [{}]", (Object)type);
                        OClass typeClass = schema.createClass(type);
                        for (String ui : uniqueIndexesArray = this.uniqueIndexes.split(",")) {
                            if (!ui.startsWith(type.toLowerCase() + ":")) continue;
                            String index = ui.substring(ui.indexOf(":") + 1, ui.length());
                            logger.info("creating unique index [{}]", (Object)index);
                            OProperty idProp = typeClass.createProperty(index, OType.STRING);
                            idProp.createIndex(OClass.INDEX_TYPE.UNIQUE);
                        }
                        for (String ui : indexesArray = this.indexes.split(",")) {
                            if (!ui.startsWith(type.toLowerCase() + ":")) continue;
                            String index = ui.substring(ui.indexOf(":") + 1, ui.length());
                            logger.info("creating index [{}]", (Object)index);
                            OProperty idProp = typeClass.createProperty(index, OType.STRING);
                            idProp.createIndex(OClass.INDEX_TYPE.NOTUNIQUE);
                        }
                    }
                }
            }
            this.queryAll = "select * from " + type;
            this.queryFindById = this.queryAll + " where id = ?";
            this.queryDelete = "delete from " + type + " where id = ?";
            this.querySelectCount = "select count(id) as count from " + type;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationException(e.getMessage());
        }
    }

    public void destroy() {
        logger.info("closing orientdb pool and db");
        pool.close();
        orientDB.close();
    }

    private Map<String, Object> resultToMap(OResult r) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String key : r.getPropertyNames()) {
            m.put(key, r.getProperty(key));
        }
        return m;
    }

    public Map<String, Object> get(String id, String version) {
        throw new DataException("versioning not implemented");
    }

    public List<String> getVersions(String id) {
        throw new DataException("versioning not implemented");
    }
}

