/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class LoadTest {
    private static final String EXCLUDED_ATTRIBUTES_GROUPS = "excludedAttributes=groups";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static int createFinished = 0;
    private static int createGroupsFinished = 0;
    private static int getFinished = 0;
    private static int searchFinished = 0;
    private static int findIdsFinished = 0;
    private static int deleteFinished = 0;
    private static int requests;
    private static final DecimalFormat format;
    private static final String OPERATION_CREATE = "CREATE";
    private static final String OPERATION_GET = "GET";
    private static final String OPERATION_SEARCH = "SEARCH";
    private static final String OPERATION_FIND_IDS = "FIND_IDS";
    private static final String OPERATION_DELETE = "DELETE";

    public static void main(String[] args) throws Exception {
        String endpoint = args[0];
        String user = args[1];
        String password = args[2];
        int threads = Integer.parseInt(args[3]);
        requests = Integer.parseInt(args[4]);
        List<Object> operations = new ArrayList<String>();
        if (args.length == 6) {
            operations = Arrays.asList(args[5].split("\\|"));
            System.out.println("operations :" + operations);
        } else {
            operations.add("CREATE");
            operations.add("GET");
            operations.add("SEARCH");
            operations.add("FIND_IDS");
            operations.add("DELETE");
            System.out.println("operations :" + operations);
        }
        LoadTest test = new LoadTest();
        System.out.println("starting load test to " + endpoint + " with " + threads + " threads and " + requests + " requests....");
        String body = new String(LoadTest.readFileAsBytes((InputStream)new FileInputStream(new File("src/test/resources/load_test_user_create.json"))));
        Map userObject = (Map)objectMapper.readValue(body, Map.class);
        body = new String(LoadTest.readFileAsBytes((InputStream)new FileInputStream(new File("src/test/resources/load_test_group_create.json"))));
        Map groupObject = (Map)objectMapper.readValue(body, Map.class);
        Map threadMap = LoadTest.getThreadMap((int)threads, (int)requests, (Map)userObject);
        if (operations.contains("CREATE")) {
            test.loadTestCreate(endpoint, user, password, threadMap, requests, threads);
            while (createFinished != threads) {
                System.out.println("create finished " + createFinished);
                Thread.sleep(1000L);
            }
            test.loadTestCreateGroups(endpoint, user, password, threadMap, requests, threads, groupObject);
            while (createGroupsFinished != threads) {
                System.out.println("create finished " + createGroupsFinished);
                Thread.sleep(1000L);
            }
        }
        if (operations.contains("GET")) {
            test.loadTestGet(endpoint, user, password, threadMap, true);
            while (getFinished != threads) {
                System.out.println("get finished " + getFinished);
                Thread.sleep(1000L);
            }
        }
        getFinished = 0;
        if (operations.contains("GET")) {
            test.loadTestGet(endpoint, user, password, threadMap, false);
            while (getFinished != threads) {
                System.out.println("get finished " + getFinished);
                Thread.sleep(1000L);
            }
        }
        if (operations.contains("SEARCH")) {
            test.loadTestSearch(endpoint, user, password, threadMap);
            while (searchFinished != threads) {
                System.out.println("search finished " + searchFinished);
                Thread.sleep(1000L);
            }
        }
        if (operations.contains("FIND_IDS")) {
            test.loadTestFindAllIds(endpoint, user, password, threadMap);
        }
        if (operations.contains("DELETE")) {
            test.loadTestDelete(endpoint, user, password, threadMap, "User");
            while (deleteFinished != threads) {
                System.out.println("deleteFinished finished for type User " + deleteFinished);
                Thread.sleep(1000L);
            }
            deleteFinished = 0;
            test.loadTestDelete(endpoint, user, password, threadMap, "Group");
            while (deleteFinished != threads) {
                System.out.println("deleteFinished finished for type Group" + deleteFinished);
                Thread.sleep(1000L);
            }
        }
    }

    private static Map<Integer, List<Map<String, Object>>> getThreadMap(int nrOfThreads, int nrOfRequests, Map<String, Object> userObject) {
        HashMap<Integer, List<Map<String, Object>>> threadMap = new HashMap<Integer, List<Map<String, Object>>>();
        for (int i = 0; i < nrOfThreads; ++i) {
            ArrayList<HashMap<String, Object>> users = new ArrayList<HashMap<String, Object>>();
            HashMap<String, Object> tt = null;
            for (int j = 0; j < nrOfRequests; ++j) {
                tt = new HashMap<String, Object>(userObject);
                tt.put("id", UUID.randomUUID().toString());
                String identifier = "joske" + i + j;
                tt.put("userName", identifier);
                tt.put("externalId", identifier);
                users.add(tt);
            }
            threadMap.put(i, users);
        }
        return threadMap;
    }

    private Map<Integer, List<Map<String, Object>>> loadTestCreate(String endpoint, String user, String password, Map<Integer, List<Map<String, Object>>> threadMap, int nrOfRequests, int nrOfThreads) throws Exception {
        long mainStart = System.currentTimeMillis();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBasicAuth(user, password);
        Object lock = new Object();
        for (int i = 0; i < threadMap.size(); ++i) {
            int zz = i;
            List<Map<String, Object>> userList = threadMap.get(i);
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
        while (createFinished != nrOfThreads) {
            Thread.sleep(100L);
        }
        long ms = System.currentTimeMillis() - mainStart;
        double dd = (double)ms / 1000.0;
        double dc = nrOfRequests * nrOfThreads;
        System.out.println("--------------- loadTestCreate() --- " + format.format(dc / dd) + " req/sec");
        return threadMap;
    }

    private Map<Integer, List<Map<String, Object>>> loadTestCreateGroups(String endpoint, String user, String password, Map<Integer, List<Map<String, Object>>> threadMap, int nrOfRequests, int nrOfThreads, Map<String, Object> groupObject) throws Exception {
        long mainStart = System.currentTimeMillis();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBasicAuth(user, password);
        Object lock = new Object();
        for (int i = 0; i < threadMap.size(); ++i) {
            int zz = i;
            List<Map<String, Object>> userList = threadMap.get(i);
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
        while (createGroupsFinished != nrOfThreads) {
            Thread.sleep(100L);
        }
        long ms = System.currentTimeMillis() - mainStart;
        double dd = (double)ms / 1000.0;
        double dc = nrOfRequests * nrOfThreads;
        System.out.println("--------------- loadTestCreateGroups() --- " + format.format(dc / dd) + " req/sec");
        return threadMap;
    }

    private void loadTestGet(String endpoint, String user, String password, Map<Integer, List<Map<String, Object>>> threadMap, boolean excludeGroups) throws Exception {
        long mainStart = System.currentTimeMillis();
        HttpHeaders headers = new HttpHeaders();
        headers.setBasicAuth(user, password);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        Object lock = new Object();
        for (int i = 0; i < threadMap.size(); ++i) {
            int zz = i;
            List<Map<String, Object>> userList = threadMap.get(i);
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
        while (getFinished != threadMap.size()) {
            Thread.sleep(100L);
        }
        long ms = System.currentTimeMillis() - mainStart;
        if (ms < 1000L) {
            System.out.println("loadTestGet() excludeGroups [" + excludeGroups + "] - " + requests * threadMap.size() + " per second");
        } else {
            double dd = (double)ms / 1000.0;
            double dc = requests * threadMap.size();
            System.out.println("--------------- loadTestGet()  excludeGroups [" + excludeGroups + "] --- " + format.format(dc / dd) + " req/sec");
        }
    }

    private void loadTestSearch(String endpoint, String user, String password, Map<Integer, List<Map<String, Object>>> threadMap) throws Exception {
        long mainStart = System.currentTimeMillis();
        HttpHeaders headers = new HttpHeaders();
        headers.setBasicAuth(user, password);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        Object lock = new Object();
        String sortBy = "&sortBy=externalId&sortOrder=ascending";
        for (int i = 0; i < threadMap.size(); ++i) {
            int zz = i;
            List<Map<String, Object>> userList = threadMap.get(i);
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
        while (searchFinished != threadMap.size()) {
            Thread.sleep(100L);
        }
        long ms = System.currentTimeMillis() - mainStart;
        if (ms < 1000L) {
            System.out.println("loadTestSearch() " + requests * threadMap.size() + " per second");
        } else {
            double dd = (double)ms / 1000.0;
            double dc = requests * threadMap.size();
            System.out.println("--------------- loadTestSearch()    --- " + format.format(dc / dd) + " req/sec");
        }
    }

    private void loadTestFindAllIds(String endpoint, String user, String password, Map<Integer, List<Map<String, Object>>> threadMap) throws Exception {
        long mainStart = System.currentTimeMillis();
        HttpHeaders headers = new HttpHeaders();
        headers.setBasicAuth(user, password);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        long start = System.currentTimeMillis();
        RestTemplate restTemplate = new RestTemplate();
        try {
            ResponseEntity response = restTemplate.exchange(endpoint + "/Users?attributes=id", HttpMethod.GET, entity, Map.class, new Object[0]);
            int findIdsFinished = (Integer)((Map)response.getBody()).get("totalResults");
            long count = 100L;
            long time = 0L;
            int i = 0;
            while ((long)i < count) {
                long cstart = System.currentTimeMillis();
                response = restTemplate.exchange(endpoint + "/Users?attributes=id&startIndex=1&count=" + findIdsFinished, HttpMethod.GET, entity, Map.class, new Object[0]);
                time += System.currentTimeMillis() - cstart;
                ++i;
            }
            System.out.println("--------------- loadTestAllIds() average   --- " + time / count + " ms");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadTestDelete(String endpoint, String user, String password, Map<Integer, List<Map<String, Object>>> threadMap, String type) throws Exception {
        long mainStart = System.currentTimeMillis();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBasicAuth(user, password);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        RestTemplate restTemplateOne = new RestTemplate();
        ResponseEntity response = restTemplateOne.exchange(endpoint + "/" + type + "s?attributes=id", HttpMethod.GET, entity, Map.class, new Object[0]);
        int findIdsFinished = (Integer)((Map)response.getBody()).get("totalResults");
        response = restTemplateOne.exchange(endpoint + "/" + type + "s?attributes=id&startIndex=1&count=" + findIdsFinished, HttpMethod.GET, entity, Map.class, new Object[0]);
        List resources = (List)((Map)response.getBody()).get("Resources");
        Object lock = new Object();
        for (int i = 0; i < threadMap.size(); ++i) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
        while (deleteFinished != threadMap.size()) {
            Thread.sleep(100L);
        }
        long ms = System.currentTimeMillis() - mainStart;
        if (ms < 1000L) {
            System.out.println("loadTestDelete() " + requests * threadMap.size() + " per second");
        } else {
            double dd = (double)ms / 1000.0;
            double dc = requests * threadMap.size();
            System.out.println("--------------- loadTestDelete() --- type [" + type + "] " + format.format(dc / dd) + " req/sec");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileAsBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int nbytes = 0;
        byte[] buffer = new byte[4096];
        try {
            while ((nbytes = inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, nbytes);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    static /* synthetic */ int access$008() {
        return createFinished++;
    }

    static /* synthetic */ int access$108() {
        return createGroupsFinished++;
    }

    static /* synthetic */ int access$208() {
        return getFinished++;
    }

    static /* synthetic */ int access$308() {
        return searchFinished++;
    }

    static /* synthetic */ int access$408() {
        return deleteFinished++;
    }

    static {
        format = new DecimalFormat("#.##");
    }
}

