/*
 * Decompiled with CFR 0.152.
 */
package be.personify.iam.scim.util;

import be.personify.iam.scim.util.CryptUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.codec.Hex;

public class TokenUtils {
    private static final Logger logger = LogManager.getLogger(TokenUtils.class);
    public static final String SALT = new String(Hex.encode((byte[])"ScimServer".getBytes()));
    @Autowired
    private CryptUtils cryptUtils;

    public boolean isValid(String encryptedToken) {
        String token = this.cryptUtils.decrypt(encryptedToken, SALT);
        String[] parts = token.split(":");
        logger.debug("checking is valid for user [{}]", (Object)parts[0]);
        long now = System.currentTimeMillis();
        long timeIssued = Long.parseLong(parts[1]);
        long expiryTimeInSeconds = Long.parseLong(parts[2]);
        if (timeIssued + expiryTimeInSeconds * 1000L < now) {
            logger.debug("token is not valid for user [{}]", (Object)parts[0]);
            return false;
        }
        logger.debug("token is valid for user [{}]", (Object)parts[0]);
        return true;
    }

    public String construct(String client_id, long expiryTime) {
        StringBuffer b = new StringBuffer(client_id);
        b.append(":").append(System.currentTimeMillis()).append(":").append(expiryTime);
        return this.cryptUtils.encrypt(b.toString(), SALT);
    }
}

