/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie;

import be.woutschoovaerts.mollie.ClientProxy;
import be.woutschoovaerts.mollie.OAuthAwareObjectMapper;
import be.woutschoovaerts.mollie.handler.CaptureHandler;
import be.woutschoovaerts.mollie.handler.ChargebackHandler;
import be.woutschoovaerts.mollie.handler.ConnectHandler;
import be.woutschoovaerts.mollie.handler.CustomerHandler;
import be.woutschoovaerts.mollie.handler.InvoiceHandler;
import be.woutschoovaerts.mollie.handler.MandateHandler;
import be.woutschoovaerts.mollie.handler.MethodHandler;
import be.woutschoovaerts.mollie.handler.MiscellaneousHandler;
import be.woutschoovaerts.mollie.handler.OnboardingHandler;
import be.woutschoovaerts.mollie.handler.OrderHandler;
import be.woutschoovaerts.mollie.handler.OrganizationHandler;
import be.woutschoovaerts.mollie.handler.PaymentHandler;
import be.woutschoovaerts.mollie.handler.PermissionHandler;
import be.woutschoovaerts.mollie.handler.ProfileHandler;
import be.woutschoovaerts.mollie.handler.RefundHandler;
import be.woutschoovaerts.mollie.handler.SettlementHandler;
import be.woutschoovaerts.mollie.handler.ShipmentHandler;
import be.woutschoovaerts.mollie.handler.SubscriptionHandler;
import be.woutschoovaerts.mollie.util.Config;
import kong.unirest.ObjectMapper;
import kong.unirest.Unirest;

public class Client {
    private final String endpoint;
    private final Config config = new Config();

    public Client(String apiKey) {
        this(apiKey, null);
    }

    public Client(String apiKey, ClientProxy proxy) {
        this.endpoint = "https://api.mollie.com/v2";
        this.config.setApiKey(apiKey);
        this.config.setAccessToken(null);
        this.config.setTestMode(false);
        this.initUniRest(proxy);
    }

    public void setAccessToken(String accessToken) {
        this.config.setAccessToken(accessToken);
    }

    public void revokeAccessToken() {
        this.config.setAccessToken(null);
    }

    public void enableTestMode() {
        this.config.setTestMode(true);
    }

    public void disableTestMode() {
        this.config.setTestMode(false);
    }

    public void setUserAgentString(String userAgentString) {
        this.config.setUserAgentString(userAgentString);
    }

    public ConnectHandler connect() {
        return new ConnectHandler(this.config);
    }

    public PaymentHandler payments() {
        return new PaymentHandler(this.endpoint, this.config);
    }

    public MethodHandler methods() {
        return new MethodHandler(this.endpoint, this.config);
    }

    public RefundHandler refunds() {
        return new RefundHandler(this.endpoint, this.config);
    }

    public ChargebackHandler chargebacks() {
        return new ChargebackHandler(this.endpoint, this.config);
    }

    public CaptureHandler captures() {
        return new CaptureHandler(this.endpoint, this.config);
    }

    public OrderHandler orders() {
        return new OrderHandler(this.endpoint, this.config);
    }

    public ShipmentHandler shipments() {
        return new ShipmentHandler(this.endpoint, this.config);
    }

    public CustomerHandler customers() {
        return new CustomerHandler(this.endpoint, this.config);
    }

    public MandateHandler mandates() {
        return new MandateHandler(this.endpoint, this.config);
    }

    public SubscriptionHandler subscriptions() {
        return new SubscriptionHandler(this.endpoint, this.config);
    }

    public PermissionHandler permissions() {
        return new PermissionHandler(this.endpoint, this.config);
    }

    public OrganizationHandler organizations() {
        return new OrganizationHandler(this.endpoint, this.config);
    }

    public ProfileHandler profiles() {
        return new ProfileHandler(this.endpoint, this.config);
    }

    public OnboardingHandler onboarding() {
        return new OnboardingHandler(this.endpoint, this.config);
    }

    public SettlementHandler settlements() {
        return new SettlementHandler(this.endpoint, this.config);
    }

    public InvoiceHandler invoices() {
        return new InvoiceHandler(this.endpoint, this.config);
    }

    public MiscellaneousHandler miscellaneous() {
        return new MiscellaneousHandler(this.endpoint, this.config);
    }

    private void initUniRest(ClientProxy proxy) {
        Unirest.config().setObjectMapper((ObjectMapper)new OAuthAwareObjectMapper(this.config));
        if (proxy != null) {
            Unirest.config().proxy(proxy.getHost(), proxy.getPort(), proxy.getUsername(), proxy.getPassword());
        }
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Config getConfig() {
        return this.config;
    }
}

