/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.data.connect;

import be.woutschoovaerts.mollie.data.common.Locale;
import be.woutschoovaerts.mollie.data.connect.ApprovalPrompt;
import be.woutschoovaerts.mollie.data.connect.LandingPageType;
import be.woutschoovaerts.mollie.data.connect.ResponseType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Optional;

public class AuthorizeRequest {
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonProperty(value="redirect_uri")
    private Optional<String> redirectUri;
    private String state;
    private String[] scope;
    @JsonProperty(value="response_type")
    private ResponseType responseType;
    @JsonProperty(value="approval_prompt")
    private ApprovalPrompt approvalPrompt;
    private Locale locale;
    @JsonProperty(value="landing_page")
    private LandingPageType landingPage = LandingPageType.LOGIN;

    private static Optional<String> $default$redirectUri() {
        return Optional.empty();
    }

    public static AuthorizeRequestBuilder builder() {
        return new AuthorizeRequestBuilder();
    }

    public String getClientId() {
        return this.clientId;
    }

    public Optional<String> getRedirectUri() {
        return this.redirectUri;
    }

    public String getState() {
        return this.state;
    }

    public String[] getScope() {
        return this.scope;
    }

    public ResponseType getResponseType() {
        return this.responseType;
    }

    public ApprovalPrompt getApprovalPrompt() {
        return this.approvalPrompt;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public LandingPageType getLandingPage() {
        return this.landingPage;
    }

    @JsonProperty(value="client_id")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @JsonProperty(value="redirect_uri")
    public void setRedirectUri(Optional<String> redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setScope(String[] scope) {
        this.scope = scope;
    }

    @JsonProperty(value="response_type")
    public void setResponseType(ResponseType responseType) {
        this.responseType = responseType;
    }

    @JsonProperty(value="approval_prompt")
    public void setApprovalPrompt(ApprovalPrompt approvalPrompt) {
        this.approvalPrompt = approvalPrompt;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @JsonProperty(value="landing_page")
    public void setLandingPage(LandingPageType landingPage) {
        this.landingPage = landingPage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthorizeRequest)) {
            return false;
        }
        AuthorizeRequest other = (AuthorizeRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        Optional<String> this$redirectUri = this.getRedirectUri();
        Optional<String> other$redirectUri = other.getRedirectUri();
        if (this$redirectUri == null ? other$redirectUri != null : !((Object)this$redirectUri).equals(other$redirectUri)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getScope(), other.getScope())) {
            return false;
        }
        ResponseType this$responseType = this.getResponseType();
        ResponseType other$responseType = other.getResponseType();
        if (this$responseType == null ? other$responseType != null : !((Object)((Object)this$responseType)).equals((Object)other$responseType)) {
            return false;
        }
        ApprovalPrompt this$approvalPrompt = this.getApprovalPrompt();
        ApprovalPrompt other$approvalPrompt = other.getApprovalPrompt();
        if (this$approvalPrompt == null ? other$approvalPrompt != null : !((Object)((Object)this$approvalPrompt)).equals((Object)other$approvalPrompt)) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)((Object)this$locale)).equals((Object)other$locale)) {
            return false;
        }
        LandingPageType this$landingPage = this.getLandingPage();
        LandingPageType other$landingPage = other.getLandingPage();
        return !(this$landingPage == null ? other$landingPage != null : !((Object)((Object)this$landingPage)).equals((Object)other$landingPage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthorizeRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        Optional<String> $redirectUri = this.getRedirectUri();
        result = result * 59 + ($redirectUri == null ? 43 : ((Object)$redirectUri).hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getScope());
        ResponseType $responseType = this.getResponseType();
        result = result * 59 + ($responseType == null ? 43 : ((Object)((Object)$responseType)).hashCode());
        ApprovalPrompt $approvalPrompt = this.getApprovalPrompt();
        result = result * 59 + ($approvalPrompt == null ? 43 : ((Object)((Object)$approvalPrompt)).hashCode());
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)((Object)$locale)).hashCode());
        LandingPageType $landingPage = this.getLandingPage();
        result = result * 59 + ($landingPage == null ? 43 : ((Object)((Object)$landingPage)).hashCode());
        return result;
    }

    public String toString() {
        return "AuthorizeRequest(clientId=" + this.getClientId() + ", redirectUri=" + this.getRedirectUri() + ", state=" + this.getState() + ", scope=" + Arrays.deepToString(this.getScope()) + ", responseType=" + (Object)((Object)this.getResponseType()) + ", approvalPrompt=" + (Object)((Object)this.getApprovalPrompt()) + ", locale=" + (Object)((Object)this.getLocale()) + ", landingPage=" + (Object)((Object)this.getLandingPage()) + ")";
    }

    public AuthorizeRequest(String clientId, Optional<String> redirectUri, String state, String[] scope, ResponseType responseType, ApprovalPrompt approvalPrompt, Locale locale, LandingPageType landingPage) {
        this.clientId = clientId;
        this.redirectUri = redirectUri;
        this.state = state;
        this.scope = scope;
        this.responseType = responseType;
        this.approvalPrompt = approvalPrompt;
        this.locale = locale;
        this.landingPage = landingPage;
    }

    public AuthorizeRequest() {
        this.redirectUri = AuthorizeRequest.$default$redirectUri();
    }

    public static class AuthorizeRequestBuilder {
        private String clientId;
        private boolean redirectUri$set;
        private Optional<String> redirectUri$value;
        private String state;
        private String[] scope;
        private ResponseType responseType;
        private ApprovalPrompt approvalPrompt;
        private Locale locale;
        private LandingPageType landingPage;

        AuthorizeRequestBuilder() {
        }

        @JsonProperty(value="client_id")
        public AuthorizeRequestBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @JsonProperty(value="redirect_uri")
        public AuthorizeRequestBuilder redirectUri(Optional<String> redirectUri) {
            this.redirectUri$value = redirectUri;
            this.redirectUri$set = true;
            return this;
        }

        public AuthorizeRequestBuilder state(String state) {
            this.state = state;
            return this;
        }

        public AuthorizeRequestBuilder scope(String[] scope) {
            this.scope = scope;
            return this;
        }

        @JsonProperty(value="response_type")
        public AuthorizeRequestBuilder responseType(ResponseType responseType) {
            this.responseType = responseType;
            return this;
        }

        @JsonProperty(value="approval_prompt")
        public AuthorizeRequestBuilder approvalPrompt(ApprovalPrompt approvalPrompt) {
            this.approvalPrompt = approvalPrompt;
            return this;
        }

        public AuthorizeRequestBuilder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="landing_page")
        public AuthorizeRequestBuilder landingPage(LandingPageType landingPage) {
            this.landingPage = landingPage;
            return this;
        }

        public AuthorizeRequest build() {
            Optional redirectUri$value = this.redirectUri$value;
            if (!this.redirectUri$set) {
                redirectUri$value = AuthorizeRequest.$default$redirectUri();
            }
            return new AuthorizeRequest(this.clientId, redirectUri$value, this.state, this.scope, this.responseType, this.approvalPrompt, this.locale, this.landingPage);
        }

        public String toString() {
            return "AuthorizeRequest.AuthorizeRequestBuilder(clientId=" + this.clientId + ", redirectUri$value=" + this.redirectUri$value + ", state=" + this.state + ", scope=" + Arrays.deepToString(this.scope) + ", responseType=" + (Object)((Object)this.responseType) + ", approvalPrompt=" + (Object)((Object)this.approvalPrompt) + ", locale=" + (Object)((Object)this.locale) + ", landingPage=" + (Object)((Object)this.landingPage) + ")";
        }
    }
}

