/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.data.connect;

import be.woutschoovaerts.mollie.data.connect.TokenType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;

public class TokenResponse {
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="refresh_token")
    private String refreshToken;
    @JsonProperty(value="expires_in")
    private int expiresIn;
    @JsonProperty(value="token_type")
    private TokenType tokenType;
    @JsonIgnore
    private String[] scope;

    @JsonProperty(value="scope")
    private void setScope(String scopeString) {
        this.scope = scopeString.split(" ");
    }

    public static TokenResponseBuilder builder() {
        return new TokenResponseBuilder();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public String[] getScope() {
        return this.scope;
    }

    @JsonProperty(value="access_token")
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @JsonProperty(value="refresh_token")
    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    @JsonProperty(value="expires_in")
    public void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }

    @JsonProperty(value="token_type")
    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenResponse)) {
            return false;
        }
        TokenResponse other = (TokenResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExpiresIn() != other.getExpiresIn()) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        TokenType this$tokenType = this.getTokenType();
        TokenType other$tokenType = other.getTokenType();
        if (this$tokenType == null ? other$tokenType != null : !((Object)((Object)this$tokenType)).equals((Object)other$tokenType)) {
            return false;
        }
        return Arrays.deepEquals(this.getScope(), other.getScope());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TokenResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getExpiresIn();
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        TokenType $tokenType = this.getTokenType();
        result = result * 59 + ($tokenType == null ? 43 : ((Object)((Object)$tokenType)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getScope());
        return result;
    }

    public String toString() {
        return "TokenResponse(accessToken=" + this.getAccessToken() + ", refreshToken=" + this.getRefreshToken() + ", expiresIn=" + this.getExpiresIn() + ", tokenType=" + (Object)((Object)this.getTokenType()) + ", scope=" + Arrays.deepToString(this.getScope()) + ")";
    }

    public TokenResponse(String accessToken, String refreshToken, int expiresIn, TokenType tokenType, String[] scope) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expiresIn = expiresIn;
        this.tokenType = tokenType;
        this.scope = scope;
    }

    public TokenResponse() {
    }

    public static class TokenResponseBuilder {
        private String accessToken;
        private String refreshToken;
        private int expiresIn;
        private TokenType tokenType;
        private String[] scope;

        TokenResponseBuilder() {
        }

        @JsonProperty(value="access_token")
        public TokenResponseBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @JsonProperty(value="refresh_token")
        public TokenResponseBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        @JsonProperty(value="expires_in")
        public TokenResponseBuilder expiresIn(int expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        @JsonProperty(value="token_type")
        public TokenResponseBuilder tokenType(TokenType tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        @JsonIgnore
        public TokenResponseBuilder scope(String[] scope) {
            this.scope = scope;
            return this;
        }

        public TokenResponse build() {
            return new TokenResponse(this.accessToken, this.refreshToken, this.expiresIn, this.tokenType, this.scope);
        }

        public String toString() {
            return "TokenResponse.TokenResponseBuilder(accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", expiresIn=" + this.expiresIn + ", tokenType=" + (Object)((Object)this.tokenType) + ", scope=" + Arrays.deepToString(this.scope) + ")";
        }
    }
}

