/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.data.invoice;

import be.woutschoovaerts.mollie.data.common.Amount;

public class InvoiceLine {
    private String period;
    private String description;
    private int count;
    private double vatPercentage;
    private Amount amount;

    public static InvoiceLineBuilder builder() {
        return new InvoiceLineBuilder();
    }

    public String getPeriod() {
        return this.period;
    }

    public String getDescription() {
        return this.description;
    }

    public int getCount() {
        return this.count;
    }

    public double getVatPercentage() {
        return this.vatPercentage;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setVatPercentage(double vatPercentage) {
        this.vatPercentage = vatPercentage;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvoiceLine)) {
            return false;
        }
        InvoiceLine other = (InvoiceLine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (Double.compare(this.getVatPercentage(), other.getVatPercentage()) != 0) {
            return false;
        }
        String this$period = this.getPeriod();
        String other$period = other.getPeriod();
        if (this$period == null ? other$period != null : !this$period.equals(other$period)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Amount this$amount = this.getAmount();
        Amount other$amount = other.getAmount();
        return !(this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InvoiceLine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCount();
        long $vatPercentage = Double.doubleToLongBits(this.getVatPercentage());
        result = result * 59 + (int)($vatPercentage >>> 32 ^ $vatPercentage);
        String $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : $period.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Amount $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        return result;
    }

    public String toString() {
        return "InvoiceLine(period=" + this.getPeriod() + ", description=" + this.getDescription() + ", count=" + this.getCount() + ", vatPercentage=" + this.getVatPercentage() + ", amount=" + this.getAmount() + ")";
    }

    public InvoiceLine(String period, String description, int count, double vatPercentage, Amount amount) {
        this.period = period;
        this.description = description;
        this.count = count;
        this.vatPercentage = vatPercentage;
        this.amount = amount;
    }

    public InvoiceLine() {
    }

    public static class InvoiceLineBuilder {
        private String period;
        private String description;
        private int count;
        private double vatPercentage;
        private Amount amount;

        InvoiceLineBuilder() {
        }

        public InvoiceLineBuilder period(String period) {
            this.period = period;
            return this;
        }

        public InvoiceLineBuilder description(String description) {
            this.description = description;
            return this;
        }

        public InvoiceLineBuilder count(int count) {
            this.count = count;
            return this;
        }

        public InvoiceLineBuilder vatPercentage(double vatPercentage) {
            this.vatPercentage = vatPercentage;
            return this;
        }

        public InvoiceLineBuilder amount(Amount amount) {
            this.amount = amount;
            return this;
        }

        public InvoiceLine build() {
            return new InvoiceLine(this.period, this.description, this.count, this.vatPercentage, this.amount);
        }

        public String toString() {
            return "InvoiceLine.InvoiceLineBuilder(period=" + this.period + ", description=" + this.description + ", count=" + this.count + ", vatPercentage=" + this.vatPercentage + ", amount=" + this.amount + ")";
        }
    }
}

