/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.data.mandate;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.LocalDate;
import java.util.Optional;

public class MandateRequest {
    private String method;
    private String consumerName;
    private String consumerAccount;
    private Optional<String> consumerBic = Optional.empty();
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private Optional<LocalDate> signatureDate = Optional.empty();
    private Optional<String> mandateReference = Optional.empty();

    public static MandateRequestBuilder builder() {
        return new MandateRequestBuilder();
    }

    public String getMethod() {
        return this.method;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public String getConsumerAccount() {
        return this.consumerAccount;
    }

    public Optional<String> getConsumerBic() {
        return this.consumerBic;
    }

    public Optional<LocalDate> getSignatureDate() {
        return this.signatureDate;
    }

    public Optional<String> getMandateReference() {
        return this.mandateReference;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public void setConsumerAccount(String consumerAccount) {
        this.consumerAccount = consumerAccount;
    }

    public void setConsumerBic(Optional<String> consumerBic) {
        this.consumerBic = consumerBic;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    public void setSignatureDate(Optional<LocalDate> signatureDate) {
        this.signatureDate = signatureDate;
    }

    public void setMandateReference(Optional<String> mandateReference) {
        this.mandateReference = mandateReference;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MandateRequest)) {
            return false;
        }
        MandateRequest other = (MandateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$consumerName = this.getConsumerName();
        String other$consumerName = other.getConsumerName();
        if (this$consumerName == null ? other$consumerName != null : !this$consumerName.equals(other$consumerName)) {
            return false;
        }
        String this$consumerAccount = this.getConsumerAccount();
        String other$consumerAccount = other.getConsumerAccount();
        if (this$consumerAccount == null ? other$consumerAccount != null : !this$consumerAccount.equals(other$consumerAccount)) {
            return false;
        }
        Optional<String> this$consumerBic = this.getConsumerBic();
        Optional<String> other$consumerBic = other.getConsumerBic();
        if (this$consumerBic == null ? other$consumerBic != null : !((Object)this$consumerBic).equals(other$consumerBic)) {
            return false;
        }
        Optional<LocalDate> this$signatureDate = this.getSignatureDate();
        Optional<LocalDate> other$signatureDate = other.getSignatureDate();
        if (this$signatureDate == null ? other$signatureDate != null : !((Object)this$signatureDate).equals(other$signatureDate)) {
            return false;
        }
        Optional<String> this$mandateReference = this.getMandateReference();
        Optional<String> other$mandateReference = other.getMandateReference();
        return !(this$mandateReference == null ? other$mandateReference != null : !((Object)this$mandateReference).equals(other$mandateReference));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MandateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $consumerName = this.getConsumerName();
        result = result * 59 + ($consumerName == null ? 43 : $consumerName.hashCode());
        String $consumerAccount = this.getConsumerAccount();
        result = result * 59 + ($consumerAccount == null ? 43 : $consumerAccount.hashCode());
        Optional<String> $consumerBic = this.getConsumerBic();
        result = result * 59 + ($consumerBic == null ? 43 : ((Object)$consumerBic).hashCode());
        Optional<LocalDate> $signatureDate = this.getSignatureDate();
        result = result * 59 + ($signatureDate == null ? 43 : ((Object)$signatureDate).hashCode());
        Optional<String> $mandateReference = this.getMandateReference();
        result = result * 59 + ($mandateReference == null ? 43 : ((Object)$mandateReference).hashCode());
        return result;
    }

    public String toString() {
        return "MandateRequest(method=" + this.getMethod() + ", consumerName=" + this.getConsumerName() + ", consumerAccount=" + this.getConsumerAccount() + ", consumerBic=" + this.getConsumerBic() + ", signatureDate=" + this.getSignatureDate() + ", mandateReference=" + this.getMandateReference() + ")";
    }

    public MandateRequest(String method, String consumerName, String consumerAccount, Optional<String> consumerBic, Optional<LocalDate> signatureDate, Optional<String> mandateReference) {
        this.method = method;
        this.consumerName = consumerName;
        this.consumerAccount = consumerAccount;
        this.consumerBic = consumerBic;
        this.signatureDate = signatureDate;
        this.mandateReference = mandateReference;
    }

    public MandateRequest() {
    }

    public static class MandateRequestBuilder {
        private String method;
        private String consumerName;
        private String consumerAccount;
        private Optional<String> consumerBic;
        private Optional<LocalDate> signatureDate;
        private Optional<String> mandateReference;

        MandateRequestBuilder() {
        }

        public MandateRequestBuilder method(String method) {
            this.method = method;
            return this;
        }

        public MandateRequestBuilder consumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public MandateRequestBuilder consumerAccount(String consumerAccount) {
            this.consumerAccount = consumerAccount;
            return this;
        }

        public MandateRequestBuilder consumerBic(Optional<String> consumerBic) {
            this.consumerBic = consumerBic;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
        public MandateRequestBuilder signatureDate(Optional<LocalDate> signatureDate) {
            this.signatureDate = signatureDate;
            return this;
        }

        public MandateRequestBuilder mandateReference(Optional<String> mandateReference) {
            this.mandateReference = mandateReference;
            return this;
        }

        public MandateRequest build() {
            return new MandateRequest(this.method, this.consumerName, this.consumerAccount, this.consumerBic, this.signatureDate, this.mandateReference);
        }

        public String toString() {
            return "MandateRequest.MandateRequestBuilder(method=" + this.method + ", consumerName=" + this.consumerName + ", consumerAccount=" + this.consumerAccount + ", consumerBic=" + this.consumerBic + ", signatureDate=" + this.signatureDate + ", mandateReference=" + this.mandateReference + ")";
        }
    }
}

