/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.data.subscription;

import be.woutschoovaerts.mollie.data.common.Amount;
import be.woutschoovaerts.mollie.data.common.ApplicationFee;
import be.woutschoovaerts.mollie.data.mandate.MandatePaymentMethod;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;

public class SubscriptionRequest {
    private Amount amount;
    private Optional<Integer> times = Optional.empty();
    private String interval;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private Optional<LocalDate> startDate = Optional.empty();
    private String description;
    private MandatePaymentMethod method;
    private Optional<String> mandateId = Optional.empty();
    private Optional<String> webhookUrl = Optional.empty();
    private Map<String, Object> metadata;
    private Optional<String> profileId = Optional.empty();
    private Optional<ApplicationFee> applicationFee = Optional.empty();

    public static SubscriptionRequestBuilder builder() {
        return new SubscriptionRequestBuilder();
    }

    public Amount getAmount() {
        return this.amount;
    }

    public Optional<Integer> getTimes() {
        return this.times;
    }

    public String getInterval() {
        return this.interval;
    }

    public Optional<LocalDate> getStartDate() {
        return this.startDate;
    }

    public String getDescription() {
        return this.description;
    }

    public MandatePaymentMethod getMethod() {
        return this.method;
    }

    public Optional<String> getMandateId() {
        return this.mandateId;
    }

    public Optional<String> getWebhookUrl() {
        return this.webhookUrl;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Optional<String> getProfileId() {
        return this.profileId;
    }

    public Optional<ApplicationFee> getApplicationFee() {
        return this.applicationFee;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public void setTimes(Optional<Integer> times) {
        this.times = times;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    public void setStartDate(Optional<LocalDate> startDate) {
        this.startDate = startDate;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMethod(MandatePaymentMethod method) {
        this.method = method;
    }

    public void setMandateId(Optional<String> mandateId) {
        this.mandateId = mandateId;
    }

    public void setWebhookUrl(Optional<String> webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public void setProfileId(Optional<String> profileId) {
        this.profileId = profileId;
    }

    public void setApplicationFee(Optional<ApplicationFee> applicationFee) {
        this.applicationFee = applicationFee;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionRequest)) {
            return false;
        }
        SubscriptionRequest other = (SubscriptionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Amount this$amount = this.getAmount();
        Amount other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Optional<Integer> this$times = this.getTimes();
        Optional<Integer> other$times = other.getTimes();
        if (this$times == null ? other$times != null : !((Object)this$times).equals(other$times)) {
            return false;
        }
        String this$interval = this.getInterval();
        String other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
            return false;
        }
        Optional<LocalDate> this$startDate = this.getStartDate();
        Optional<LocalDate> other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        MandatePaymentMethod this$method = this.getMethod();
        MandatePaymentMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        Optional<String> this$mandateId = this.getMandateId();
        Optional<String> other$mandateId = other.getMandateId();
        if (this$mandateId == null ? other$mandateId != null : !((Object)this$mandateId).equals(other$mandateId)) {
            return false;
        }
        Optional<String> this$webhookUrl = this.getWebhookUrl();
        Optional<String> other$webhookUrl = other.getWebhookUrl();
        if (this$webhookUrl == null ? other$webhookUrl != null : !((Object)this$webhookUrl).equals(other$webhookUrl)) {
            return false;
        }
        Map<String, Object> this$metadata = this.getMetadata();
        Map<String, Object> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Optional<String> this$profileId = this.getProfileId();
        Optional<String> other$profileId = other.getProfileId();
        if (this$profileId == null ? other$profileId != null : !((Object)this$profileId).equals(other$profileId)) {
            return false;
        }
        Optional<ApplicationFee> this$applicationFee = this.getApplicationFee();
        Optional<ApplicationFee> other$applicationFee = other.getApplicationFee();
        return !(this$applicationFee == null ? other$applicationFee != null : !((Object)this$applicationFee).equals(other$applicationFee));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Amount $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Optional<Integer> $times = this.getTimes();
        result = result * 59 + ($times == null ? 43 : ((Object)$times).hashCode());
        String $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
        Optional<LocalDate> $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        MandatePaymentMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        Optional<String> $mandateId = this.getMandateId();
        result = result * 59 + ($mandateId == null ? 43 : ((Object)$mandateId).hashCode());
        Optional<String> $webhookUrl = this.getWebhookUrl();
        result = result * 59 + ($webhookUrl == null ? 43 : ((Object)$webhookUrl).hashCode());
        Map<String, Object> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Optional<String> $profileId = this.getProfileId();
        result = result * 59 + ($profileId == null ? 43 : ((Object)$profileId).hashCode());
        Optional<ApplicationFee> $applicationFee = this.getApplicationFee();
        result = result * 59 + ($applicationFee == null ? 43 : ((Object)$applicationFee).hashCode());
        return result;
    }

    public String toString() {
        return "SubscriptionRequest(amount=" + this.getAmount() + ", times=" + this.getTimes() + ", interval=" + this.getInterval() + ", startDate=" + this.getStartDate() + ", description=" + this.getDescription() + ", method=" + (Object)((Object)this.getMethod()) + ", mandateId=" + this.getMandateId() + ", webhookUrl=" + this.getWebhookUrl() + ", metadata=" + this.getMetadata() + ", profileId=" + this.getProfileId() + ", applicationFee=" + this.getApplicationFee() + ")";
    }

    public SubscriptionRequest(Amount amount, Optional<Integer> times, String interval, Optional<LocalDate> startDate, String description, MandatePaymentMethod method, Optional<String> mandateId, Optional<String> webhookUrl, Map<String, Object> metadata, Optional<String> profileId, Optional<ApplicationFee> applicationFee) {
        this.amount = amount;
        this.times = times;
        this.interval = interval;
        this.startDate = startDate;
        this.description = description;
        this.method = method;
        this.mandateId = mandateId;
        this.webhookUrl = webhookUrl;
        this.metadata = metadata;
        this.profileId = profileId;
        this.applicationFee = applicationFee;
    }

    public SubscriptionRequest() {
    }

    public static class SubscriptionRequestBuilder {
        private Amount amount;
        private Optional<Integer> times;
        private String interval;
        private Optional<LocalDate> startDate;
        private String description;
        private MandatePaymentMethod method;
        private Optional<String> mandateId;
        private Optional<String> webhookUrl;
        private Map<String, Object> metadata;
        private Optional<String> profileId;
        private Optional<ApplicationFee> applicationFee;

        SubscriptionRequestBuilder() {
        }

        public SubscriptionRequestBuilder amount(Amount amount) {
            this.amount = amount;
            return this;
        }

        public SubscriptionRequestBuilder times(Optional<Integer> times) {
            this.times = times;
            return this;
        }

        public SubscriptionRequestBuilder interval(String interval) {
            this.interval = interval;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
        public SubscriptionRequestBuilder startDate(Optional<LocalDate> startDate) {
            this.startDate = startDate;
            return this;
        }

        public SubscriptionRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        public SubscriptionRequestBuilder method(MandatePaymentMethod method) {
            this.method = method;
            return this;
        }

        public SubscriptionRequestBuilder mandateId(Optional<String> mandateId) {
            this.mandateId = mandateId;
            return this;
        }

        public SubscriptionRequestBuilder webhookUrl(Optional<String> webhookUrl) {
            this.webhookUrl = webhookUrl;
            return this;
        }

        public SubscriptionRequestBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public SubscriptionRequestBuilder profileId(Optional<String> profileId) {
            this.profileId = profileId;
            return this;
        }

        public SubscriptionRequestBuilder applicationFee(Optional<ApplicationFee> applicationFee) {
            this.applicationFee = applicationFee;
            return this;
        }

        public SubscriptionRequest build() {
            return new SubscriptionRequest(this.amount, this.times, this.interval, this.startDate, this.description, this.method, this.mandateId, this.webhookUrl, this.metadata, this.profileId, this.applicationFee);
        }

        public String toString() {
            return "SubscriptionRequest.SubscriptionRequestBuilder(amount=" + this.amount + ", times=" + this.times + ", interval=" + this.interval + ", startDate=" + this.startDate + ", description=" + this.description + ", method=" + (Object)((Object)this.method) + ", mandateId=" + this.mandateId + ", webhookUrl=" + this.webhookUrl + ", metadata=" + this.metadata + ", profileId=" + this.profileId + ", applicationFee=" + this.applicationFee + ")";
        }
    }
}

