/*
 * Decompiled with CFR 0.152.
 */
package be.woutschoovaerts.mollie.handler;

import be.woutschoovaerts.mollie.data.organization.OrganizationResponse;
import be.woutschoovaerts.mollie.exception.MollieException;
import be.woutschoovaerts.mollie.handler.AbstractHandler;
import be.woutschoovaerts.mollie.util.Config;
import be.woutschoovaerts.mollie.util.ObjectMapperService;
import be.woutschoovaerts.mollie.util.QueryParams;
import java.io.IOException;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(OrganizationHandler.class);

    public OrganizationHandler(String baseUrl, Config config) {
        super(baseUrl, log, config);
    }

    public OrganizationResponse getMyOrganization() throws MollieException {
        return this.getMyOrganization(QueryParams.EMPTY);
    }

    public OrganizationResponse getMyOrganization(QueryParams params) throws MollieException {
        try {
            String uri = "/organizations/me";
            HttpResponse<String> response = this.get(uri, params);
            return (OrganizationResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), OrganizationResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public OrganizationResponse getOrganization(String organizationId) throws MollieException {
        return this.getOrganization(organizationId, QueryParams.EMPTY);
    }

    public OrganizationResponse getOrganization(String organizationId, QueryParams params) throws MollieException {
        try {
            String uri = "/organizations/" + organizationId;
            HttpResponse<String> response = this.get(uri, params);
            return (OrganizationResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), OrganizationResponse.class);
        }
        catch (IOException | UnirestException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

