/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.vfs.physfs;

import be.yildizgames.common.exception.implementation.ImplementationException;
import be.yildizgames.common.jni.Native;
import be.yildizgames.common.jni.NativePointer;
import be.yildizgames.common.libloader.GlobalNativeResourceLoader;
import be.yildizgames.common.libloader.NativeResourceLoader;
import be.yildizgames.module.vfs.Vfs;
import be.yildizgames.module.vfs.VfsArchiveInfo;
import be.yildizgames.module.vfs.VfsContainer;
import be.yildizgames.module.vfs.physfs.PhysFsArchiveInfo;
import be.yildizgames.module.vfs.physfs.PhysFsContainer;
import be.yildizgames.module.vfs.physfs.exception.VfsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jni.PhysFsWrapperNative;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysFsWrapper
implements Vfs,
Native {
    private final NativePointer pointer;

    private PhysFsWrapper(NativeResourceLoader loader) {
        ImplementationException.throwForNull((Object)loader);
        Logger logger = LoggerFactory.getLogger(PhysFsWrapper.class);
        logger.info("Initializing PhysFs virtual file system component...");
        loader.loadBaseLibrary(new String[0]);
        loader.loadLibrary(new String[]{"libyildizphysfs"});
        this.pointer = NativePointer.create((long)PhysFsWrapperNative.initialize());
        logger.info("PhysFs virtual file system component initialized.");
    }

    static PhysFsWrapper create() {
        return PhysFsWrapper.create(GlobalNativeResourceLoader.getInstance().getLoader());
    }

    static PhysFsWrapper create(NativeResourceLoader loader) {
        return new PhysFsWrapper(loader);
    }

    public final VfsContainer registerContainer(Path path) {
        ImplementationException.throwForNull((Object)path);
        if (Files.notExists(path, new LinkOption[0])) {
            throw VfsException.containerNotExists(path);
        }
        return new PhysFsContainer(path, NativePointer.create((long)PhysFsWrapperNative.registerContainer(this.pointer.getPointerAddress(), path.toString())));
    }

    public final List<VfsArchiveInfo> getSupportedArchiveInfo() {
        return Arrays.stream(PhysFsWrapperNative.getSupportedArchiveType(this.pointer.getPointerAddress())).mapToObj(NativePointer::create).map(PhysFsArchiveInfo::new).collect(Collectors.toList());
    }

    public final List<String> enumerateFiles(String dir) {
        return Arrays.asList(PhysFsWrapperNative.enumerateFiles(this.pointer.getPointerAddress(), dir));
    }

    public final NativePointer getPointer() {
        return this.pointer;
    }

    public void delete() {
    }
}

