/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.wsm.axis;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Use;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.enum.Enum;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.beehive.wsm.axis.AxisHook;
import org.apache.beehive.wsm.axis.ControlProvider;
import org.apache.beehive.wsm.axis.HandlerHandler;
import org.apache.beehive.wsm.jsr181.model.WebServiceTYPEMetadata;
import org.apache.beehive.wsm.jsr181.processor.reflection.WsmReflectionAnnotationProcessor;
import org.apache.commons.logging.Log;

public class AnnotatedWebServiceDeploymentHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog((String)AnnotatedWebServiceDeploymentHandler.class.getName());
    protected Map<String, SOAPService> soapServices = new HashMap<String, SOAPService>();

    public void invoke(MessageContext mc) throws AxisFault {
        try {
            SOAPService ss = this.createSOAPServiceFromAnnotatedClass(this.findWebServiceClass(mc));
            if (null != ss) {
                ss.setEngine(mc.getAxisEngine());
                mc.setService(ss);
                mc.setProperty("sendXsiTypes", (Object)new Boolean(Use.ENCODED.equals((Enum)ss.getUse())));
                mc.removeProperty("realpath");
            }
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
    }

    public void generateWSDL(MessageContext mc) throws AxisFault {
        this.invoke(mc);
    }

    protected SOAPService createSOAPServiceFromAnnotatedClass(Class clazz) throws Exception {
        SOAPService rpc = null;
        if (null != clazz && null == (rpc = this.soapServices.get(clazz.getName()))) {
            WebServiceTYPEMetadata wsm = (WebServiceTYPEMetadata)WsmReflectionAnnotationProcessor.getInstance().getObjectModel(clazz);
            rpc = this.createSOAPServiceUsingAnnotations(wsm, clazz);
        }
        return rpc;
    }

    protected SOAPService createSOAPServiceUsingAnnotations(WebServiceTYPEMetadata wsm, Class cls) throws Exception {
        SOAPService rpc = null;
        if (null != wsm) {
            HandlerHandler hh = new HandlerHandler(wsm);
            hh.init();
            rpc = new SOAPService((Handler)hh, (Handler)new ControlProvider(), (Handler)hh);
            rpc.setName(wsm.getWsName());
            rpc.setOption("className", (Object)cls.getName());
            String scope = (String)this.getOption("scope");
            if (null == scope) {
                scope = "Request";
            }
            rpc.setOption("scope", (Object)scope);
            ServiceDesc sd = AxisHook.createServiceDesc(wsm, cls.getClassLoader());
            rpc.setServiceDescription(sd);
            List allowedMethodNames = sd.getAllowedMethods();
            Iterator allowIt = allowedMethodNames.iterator();
            StringBuffer sb = new StringBuffer();
            boolean firstPass = true;
            while (allowIt.hasNext()) {
                if (firstPass) {
                    sb.append(' ');
                    firstPass = false;
                }
                sb.append((String)allowIt.next());
            }
            rpc.setOption("allowedMethods", (Object)sb.toString());
            rpc.setOption("wsdlPortType", (Object)wsm.getWsName());
            rpc.setOption("wsdlServicePort", (Object)wsm.getWsName());
            rpc.setOption("wsdlServiceElement", (Object)wsm.getWsServiceName());
            rpc.setOption("wsdlTargetNamespace", (Object)wsm.getWsTargetNamespace());
            rpc.setStyle(sd.getStyle());
            rpc.setUse(sd.getUse());
            this.soapServices.put(cls.getName(), rpc);
        }
        return rpc;
    }

    protected Class findWebServiceClass(MessageContext mc) throws Exception {
        String relPath;
        if (null != mc && null != (relPath = mc.getStrProp("path"))) {
            int indexOfDot;
            if ('/' == relPath.charAt(0)) {
                relPath = relPath.substring(1);
            }
            if (-1 != (indexOfDot = relPath.indexOf("."))) {
                relPath = relPath.substring(0, indexOfDot);
            }
            String clsName = relPath.replaceAll("/", ".");
            log.info((Object)("looking for webserivce in class: " + clsName));
            try {
                Class<?> result = ((Object)((Object)this)).getClass().getClassLoader().loadClass(clsName);
                return result;
            }
            catch (ClassNotFoundException e) {
                log.info((Object)("class: " + clsName + " was not found by the AnnotatedWebServiceDeploymentHandler continue to the next handler. "));
                return null;
            }
        }
        return null;
    }
}

