/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.wsm.axis;

import java.awt.Image;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jws.WebParam;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.OperationType;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.ElementDesc;
import org.apache.axis.description.FaultDesc;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.JavaServiceDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.ser.ArrayDeserializerFactory;
import org.apache.axis.encoding.ser.ArraySerializerFactory;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.encoding.ser.VectorDeserializerFactory;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.beehive.wsm.axis.InvalidTypeMappingException;
import org.apache.beehive.wsm.axis.util.encoding.CollectionSerializerFactory;
import org.apache.beehive.wsm.axis.util.encoding.XmlBeanDeserializerFactory;
import org.apache.beehive.wsm.axis.util.encoding.XmlBeanSerializerFactory;
import org.apache.beehive.wsm.jsr181.model.SOAPBindingInfo;
import org.apache.beehive.wsm.jsr181.model.WebServiceMETHODMetadata;
import org.apache.beehive.wsm.jsr181.model.WebServicePARAMETERMetadata;
import org.apache.beehive.wsm.jsr181.model.WebServiceTYPEMetadata;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;

public class AxisHook {
    public static ServiceDesc createServiceDesc(WebServiceTYPEMetadata wsm, ClassLoader cl) throws ClassNotFoundException, NoSuchMethodException, InvalidTypeMappingException {
        JavaServiceDesc sd = new JavaServiceDesc();
        if (cl == null) {
            cl = AxisHook.class.getClassLoader();
        }
        Class<?> serviceClass = cl.loadClass(wsm.getServiceImplementationBean());
        String portType = wsm.getWsName();
        sd.setName(portType);
        sd.setImplClass(serviceClass);
        String targetNamespace = wsm.getWsTargetNamespace();
        sd.setDefaultNamespace(targetNamespace);
        SOAPBindingInfo sbi = wsm.getSoapBinding();
        AxisHook.configureSoapBinding((ServiceDesc)sd, sbi);
        Collection methods = wsm.getMethods();
        ArrayList<String> allowedMethods = new ArrayList<String>();
        for (WebServiceMETHODMetadata meth : methods) {
            String operationName = meth.getWmOperationName();
            if (operationName == null || operationName.length() <= 0) continue;
            OperationDesc od = new OperationDesc();
            String javaMethodName = meth.getJavaMethodName();
            od.setElementQName(new QName(operationName));
            od.setName(operationName);
            allowedMethods.add(operationName);
            od.setSoapAction(meth.getWmAction());
            if (meth.isOneWay()) {
                od.setMep(OperationType.ONE_WAY);
            } else {
                od.setReturnQName(new QName(meth.getWrTargetNamespace(), meth.getWrName()));
                Class returnType = meth.getJavaReturnType();
                QName type = AxisHook.configureTypeMapping((ServiceDesc)sd, returnType);
                od.setReturnType(type);
                od.setReturnClass(returnType);
            }
            List parameters = meth.getParams();
            ArrayList<Class> paramClasses = new ArrayList<Class>();
            for (WebServicePARAMETERMetadata param : parameters) {
                ParameterDesc pd = new ParameterDesc();
                pd.setQName(new QName(param.getWpTargetNamespace(), param.getWpName()));
                Class paramType = param.getJavaType();
                AxisHook.configureTypeMapping((ServiceDesc)sd, paramType);
                pd.setJavaType(paramType);
                paramClasses.add(paramType);
                WebParam.Mode mo = param.getWpMode();
                switch (mo) {
                    case OUT: {
                        pd.setMode((byte)2);
                        pd.setInHeader(false);
                        pd.setOutHeader(param.isWpHeader());
                        break;
                    }
                    case INOUT: {
                        pd.setMode((byte)3);
                        boolean header = param.isWpHeader();
                        pd.setInHeader(header);
                        pd.setOutHeader(header);
                        break;
                    }
                    default: {
                        pd.setMode((byte)1);
                        pd.setInHeader(param.isWpHeader());
                        pd.setOutHeader(false);
                    }
                }
                od.addParameter(pd);
            }
            Method javaMethod = serviceClass.getMethod(meth.getJavaMethodName(), paramClasses.toArray(new Class[paramClasses.size()]));
            for (Class<?> thrown : javaMethod.getExceptionTypes()) {
                FaultDesc fd = new FaultDesc();
                fd.setClassName(thrown.getName());
                od.addFault(fd);
            }
            od.setMethod(javaMethod);
            sd.addOperationDesc(od);
        }
        sd.setAllowedMethods(allowedMethods);
        return sd;
    }

    private static boolean isActivationEnabled() {
        return null != AxisHook.getDataHandlerClass() && null != AxisHook.getMultipartClass();
    }

    private static Class getDataHandlerClass() {
        try {
            return AxisHook.class.getClassLoader().loadClass("javax.activation.DataHandler");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Class getMultipartClass() {
        try {
            return AxisHook.class.getClassLoader().loadClass("javax.mail.internet.MimeMultipart");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static QName configureTypeMapping(ServiceDesc desc, Class type) throws InvalidTypeMappingException {
        if (Void.TYPE.equals(type)) {
            return null;
        }
        TypeMapping tm = desc.getTypeMapping();
        QName q = tm.getTypeQName(type);
        if (Collection.class.isAssignableFrom(type)) {
            q = AxisHook.generateQName(type, desc);
            tm.register(type, q, (javax.xml.rpc.encoding.SerializerFactory)new CollectionSerializerFactory(type, q), (javax.xml.rpc.encoding.DeserializerFactory)new VectorDeserializerFactory(type, q));
        } else {
            if (q == null) {
                q = AxisHook.generateQName(type, desc);
            }
            if (type.isArray()) {
                if (!tm.isRegistered(type, q)) {
                    tm.register(type, q, (javax.xml.rpc.encoding.SerializerFactory)new ArraySerializerFactory(type, q), (javax.xml.rpc.encoding.DeserializerFactory)new ArrayDeserializerFactory());
                }
                q = AxisHook.configureTypeMapping(desc, type.getComponentType());
            } else if (!tm.isRegistered(type, q)) {
                if (XmlObject.class.isAssignableFrom(type)) {
                    q = XmlBeans.typeForClass((Class)type).getName();
                    tm.register(type, q, (javax.xml.rpc.encoding.SerializerFactory)new XmlBeanSerializerFactory(type, q), (javax.xml.rpc.encoding.DeserializerFactory)new XmlBeanDeserializerFactory(type, q));
                } else if (AxisHook.isActivationEnabled() && (Image.class.isAssignableFrom(type) || AxisHook.getMultipartClass().isAssignableFrom(type) || AxisHook.getDataHandlerClass().isAssignableFrom(type))) {
                    try {
                        ClassLoader cl = AxisHook.class.getClassLoader();
                        Class<?> sfClass = cl.loadClass("org.apache.axis.encoding.ser.JAFDataHandlerSerializerFactory");
                        Class<?> dsfClass = cl.loadClass("org.apache.axis.encoding.ser.JAFDataHandlerDeserializerFactory");
                        Constructor<?> sfCon = sfClass.getConstructor(Class.class, QName.class);
                        Constructor<?> dsfCon = dsfClass.getConstructor(Class.class, QName.class);
                        SerializerFactory sf = (SerializerFactory)sfCon.newInstance(type, q);
                        DeserializerFactory dsf = (DeserializerFactory)dsfCon.newInstance(type, q);
                        tm.register(type, q, (javax.xml.rpc.encoding.SerializerFactory)sf, (javax.xml.rpc.encoding.DeserializerFactory)dsf);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (Serializable.class.isAssignableFrom(type) && !Remote.class.isAssignableFrom(type) && !File.class.isAssignableFrom(type)) {
                    TypeDesc td = TypeDesc.getTypeDescForClass((Class)type);
                    TypeDesc superTd = null;
                    BeanPropertyDescriptor[] superPd = null;
                    if (null == td) {
                        td = new TypeDesc(type);
                        Class supa = type.getSuperclass();
                        if (supa != null && supa != Object.class && supa != Exception.class && supa != Throwable.class && supa != RemoteException.class && supa != AxisFault.class) {
                            AxisHook.configureTypeMapping(desc, supa);
                        }
                        if ((superTd = TypeDesc.getTypeDescForClass(supa)) != null) {
                            superPd = superTd.getPropertyDescriptors();
                        }
                        td.setXmlType(q);
                        TypeDesc.registerTypeDescForClass((Class)type, (TypeDesc)td);
                    } else {
                        td = null;
                    }
                    tm.register(type, q, (javax.xml.rpc.encoding.SerializerFactory)new BeanSerializerFactory(type, q), (javax.xml.rpc.encoding.DeserializerFactory)new BeanDeserializerFactory(type, q));
                    Map serProps = BeanDeserializerFactory.getProperties((Class)type, null);
                    for (BeanPropertyDescriptor beanProps : serProps.values()) {
                        Class subType = beanProps.getType();
                        if (!(subType.isPrimitive() || subType.getName().startsWith("java.") || subType.getName().startsWith("javax."))) {
                            AxisHook.configureTypeMapping(desc, subType);
                        }
                        if (td == null) continue;
                        String ns = q.getNamespaceURI();
                        if (superTd != null && superPd != null) {
                            for (int j = 0; j < superPd.length; ++j) {
                                if (!beanProps.getName().equals(superPd[j].getName())) continue;
                                ns = superTd.getXmlType().getNamespaceURI();
                                break;
                            }
                        }
                        ElementDesc fd = new ElementDesc();
                        fd.setJavaType(subType);
                        fd.setFieldName(beanProps.getName());
                        fd.setXmlName(new QName(ns, beanProps.getName()));
                        fd.setXmlType(tm.getTypeQName(subType));
                        td.addFieldDesc((FieldDesc)fd);
                    }
                } else {
                    throw new InvalidTypeMappingException("failed to register " + type.getName() + " as a valid web service datatype," + " consider using a custom type mapping");
                }
            }
        }
        return q;
    }

    private static QName generateQName(Class type, ServiceDesc desc) {
        String namespace = Namespaces.makeNamespace((String)type.getName());
        if (namespace == null || namespace.endsWith("DefaultNamespace")) {
            namespace = desc.getDefaultNamespace();
        }
        return new QName(namespace, Types.getLocalNameFromFullName((String)type.getName()));
    }

    protected static void configureSoapBinding(ServiceDesc sd, SOAPBindingInfo sbi) {
        SOAPBinding.Style style = SOAPBinding.Style.DOCUMENT;
        SOAPBinding.Use use = SOAPBinding.Use.LITERAL;
        SOAPBinding.ParameterStyle paramStyle = SOAPBinding.ParameterStyle.WRAPPED;
        if (sbi != null) {
            style = sbi.getStyle();
            use = sbi.getUse();
            paramStyle = sbi.getParameterStyle();
        }
        if (style == SOAPBinding.Style.RPC) {
            sd.setStyle(Style.RPC);
            if (use == SOAPBinding.Use.ENCODED) {
                sd.setUse(Use.ENCODED);
            } else {
                sd.setUse(Use.LITERAL);
            }
        } else {
            sd.setUse(Use.LITERAL);
            if (paramStyle == SOAPBinding.ParameterStyle.WRAPPED) {
                sd.setStyle(Style.WRAPPED);
            } else {
                sd.setStyle(Style.DOCUMENT);
            }
        }
    }
}

