/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.wsm.axis;

import com.sun.tools.apt.main.Main;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.axis.AxisEngine;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDOperation;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.description.JavaServiceDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.server.AxisServer;
import org.apache.beehive.wsm.axis.AxisHook;
import org.apache.beehive.wsm.jsr181.model.WebServiceTYPEMetadata;
import org.apache.beehive.wsm.jsr181.processor.apt.WsmAnnotationProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentDumper {
    public static void main(String[] args) throws Exception {
        if (args.length > 2) {
            String wsddOut = args[0];
            String wsddIn = args[1];
            int len = args.length - 2;
            String[] aptArgs = new String[len];
            System.arraycopy(args, 2, aptArgs, 0, len);
            for (String arg : aptArgs) {
                System.out.println(arg);
            }
            Main apt = new Main("AxisApt");
            if (0 == apt.compile(aptArgs)) {
                DeploymentDumper dd = new DeploymentDumper();
                dd.createAxisDeployment(dd.retrieveWebServiceMetadata(), wsddOut, wsddIn);
            }
        }
    }

    public void createAxisDeployment(Collection<WebServiceTYPEMetadata> wsms, String newConfigFilename, String existingConfigFilename) throws Exception {
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(newConfigFilename), "UTF-8");
        SerializationContext serial = new SerializationContext((Writer)fw);
        serial.setPretty(true);
        serial.writeString("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        if (existingConfigFilename != null) {
            FileProvider fp = new FileProvider(existingConfigFilename);
            fp.configureEngine((AxisEngine)new AxisServer());
            WSDDDeployment dep = fp.getDeployment();
            if (dep != null) {
                for (WebServiceTYPEMetadata wsm : wsms) {
                    WSDDService wsds = new WSDDService();
                    JavaServiceDesc sd = (JavaServiceDesc)AxisHook.createServiceDesc(wsm, this.getClass().getClassLoader());
                    wsds.setName(sd.getName());
                    wsds.setProviderQName(WSDDConstants.QNAME_JAVARPC_PROVIDER);
                    wsds.setUse(sd.getUse());
                    wsds.setStyle(sd.getStyle());
                    ArrayList ops = sd.getOperations();
                    for (OperationDesc op : ops) {
                        wsds.addOperation(new WSDDOperation(op));
                    }
                    List allowedMethods = sd.getAllowedMethods();
                    StringBuffer allowedNames = new StringBuffer(allowedMethods.size());
                    boolean firstRun = true;
                    for (Object methName : allowedMethods) {
                        if (firstRun) {
                            firstRun = false;
                        } else {
                            allowedNames.append(' ');
                        }
                        allowedNames.append((String)methName);
                    }
                    wsds.setParameter("allowedMethods", allowedNames.toString());
                    wsds.setParameter("className", sd.getImplClass().getName());
                    dep.deployService(wsds);
                }
                dep.writeToContext(serial);
            }
        }
        ((Writer)fw).close();
    }

    protected Collection<WebServiceTYPEMetadata> retrieveWebServiceMetadata() {
        ArrayList<WebServiceTYPEMetadata> meta = new ArrayList<WebServiceTYPEMetadata>();
        Set keys = WsmAnnotationProcessor.getObjectModelNames();
        for (String key : keys) {
            meta.add((WebServiceTYPEMetadata)WsmAnnotationProcessor.getObjectModel((String)key));
        }
        return meta;
    }
}

