/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.wsm.axis;

import com.sun.tools.apt.Main;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Use;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.enum.Enum;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.ClasspathUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.beehive.wsm.axis.AxisHook;
import org.apache.beehive.wsm.axis.ControlProvider;
import org.apache.beehive.wsm.axis.HandlerHandler;
import org.apache.beehive.wsm.jsr181.model.WebServiceTYPEMetadata;
import org.apache.beehive.wsm.jsr181.processor.reflection.WsmReflectionAnnotationProcessor;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DropInDeploymentHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog((String)DropInDeploymentHandler.class.getName());
    protected Map<String, SOAPService> soapServices = new HashMap<String, SOAPService>();

    public void invoke(MessageContext mc) throws AxisFault {
        try {
            if (null != mc.getService()) {
                return;
            }
            SOAPService ss = this.createSOAPServiceFromAnnotatedClass(this.compileDroppedInSource(mc));
            if (null != ss) {
                ss.setEngine(mc.getAxisEngine());
                mc.setService(ss);
                mc.setProperty("sendXsiTypes", (Object)new Boolean(Use.ENCODED.equals((Enum)ss.getUse())));
                mc.removeProperty("realpath");
            }
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
    }

    public void generateWSDL(MessageContext mc) throws AxisFault {
        this.invoke(mc);
    }

    protected SOAPService createSOAPServiceFromAnnotatedClass(Class clazz) throws Exception {
        SOAPService rpc = null;
        if (null != clazz && null == (rpc = this.soapServices.get(clazz.getName()))) {
            WebServiceTYPEMetadata wsm = (WebServiceTYPEMetadata)WsmReflectionAnnotationProcessor.getInstance().getObjectModel(clazz);
            rpc = this.createSOAPServiceUsingAnnotations(wsm, clazz);
        }
        return rpc;
    }

    protected SOAPService createSOAPServiceUsingAnnotations(WebServiceTYPEMetadata wsm, Class cls) throws Exception {
        SOAPService rpc = null;
        if (null != wsm) {
            HandlerHandler hh = new HandlerHandler(wsm);
            hh.init();
            rpc = new SOAPService((Handler)hh, (Handler)new ControlProvider(), (Handler)hh);
            rpc.setName(wsm.getWsName());
            rpc.setOption("className", (Object)cls.getName());
            String scope = (String)this.getOption("scope");
            if (null == scope) {
                scope = "Request";
            }
            rpc.setOption("scope", (Object)scope);
            ServiceDesc sd = AxisHook.createServiceDesc(wsm, cls.getClassLoader());
            rpc.setServiceDescription(sd);
            List allowedMethodNames = sd.getAllowedMethods();
            Iterator allowIt = allowedMethodNames.iterator();
            StringBuffer sb = new StringBuffer();
            boolean firstPass = true;
            while (allowIt.hasNext()) {
                if (firstPass) {
                    sb.append(' ');
                    firstPass = false;
                }
                sb.append((String)allowIt.next());
            }
            rpc.setOption("allowedMethods", (Object)sb.toString());
            rpc.setOption("wsdlPortType", (Object)wsm.getWsName());
            rpc.setOption("wsdlServicePort", (Object)wsm.getWsName());
            rpc.setOption("wsdlServiceElement", (Object)wsm.getWsServiceName());
            rpc.setOption("wsdlTargetNamespace", (Object)wsm.getWsTargetNamespace());
            rpc.setStyle(sd.getStyle());
            rpc.setUse(sd.getUse());
            this.soapServices.put(cls.getName(), rpc);
        }
        return rpc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class compileDroppedInSource(MessageContext mc) throws Exception {
        String EXTENSION_JWS = ".jws";
        String EXTENSION_JAVA = ".java";
        String EXTENSION_CLASS = ".class";
        if (null != mc) {
            String realpath;
            String extension = (String)this.getOption("extension");
            if (null == extension) {
                extension = ".jws";
            }
            if (null != (realpath = mc.getStrProp("realpath")) && realpath.endsWith(extension)) {
                ClassLoader cl;
                File outDirectory;
                String srcPath = realpath;
                String relPath = mc.getStrProp("path");
                File srcFile = new File(srcPath);
                if (!srcFile.exists()) {
                    throw new FileNotFoundException(relPath);
                }
                if ('/' == relPath.charAt(0)) {
                    relPath = relPath.substring(1);
                }
                String relativeOutputPath = relPath;
                String outDirPath = mc.getStrProp("jws.classDir");
                if (null == outDirPath) {
                    outDirPath = ".";
                }
                if (!(outDirectory = new File(outDirPath)).exists()) {
                    outDirectory.mkdirs();
                }
                String jFile = outDirPath + File.separator + relativeOutputPath.substring(0, relativeOutputPath.length() - extension.length()) + ".java";
                String cFile = outDirPath + File.separator + relativeOutputPath.substring(0, relativeOutputPath.length() - extension.length()) + ".class";
                File clsFile = new File(cFile);
                String clsName = relativeOutputPath;
                if (null != clsName && '/' == clsName.charAt(0)) {
                    clsName = clsName.substring(1);
                }
                clsName = clsName.substring(0, clsName.length() - 4);
                clsName = clsName.replace('/', '.');
                if (!clsFile.exists() || srcFile.lastModified() > clsFile.lastModified()) {
                    File javaFile = new File(jFile);
                    try {
                        this.copyFile(srcFile, javaFile);
                        if (0 != this.compile(ClasspathUtils.getDefaultClasspath((MessageContext)mc), outDirPath, jFile)) {
                            clsFile.delete();
                        }
                        ClassUtils.removeClassLoader((String)clsName);
                        this.soapServices.remove(clsName);
                    }
                    finally {
                        javaFile.delete();
                    }
                }
                if (null == (cl = ClassUtils.getClassLoader((String)clsName))) {
                    cl = new URLClassLoader(new URL[]{outDirectory.toURL()}, mc.getClassLoader());
                    ClassUtils.setClassLoader((String)clsName, (ClassLoader)cl);
                }
                mc.setClassLoader(cl);
                return cl.loadClass(clsName);
            }
        }
        return null;
    }

    private void copyFile(File src, File dest) throws IOException {
        byte[] buf = new byte[4096];
        FileInputStream fis = new FileInputStream(src);
        FileOutputStream fos = new FileOutputStream(dest);
        int count = 0;
        while ((count = fis.read(buf)) > 0) {
            fos.write(buf, 0, count);
        }
        fis.close();
        fos.close();
    }

    protected int compile(String classpath, String outDirPath, String jFile) throws Exception {
        String[] args = new String[]{"-verbose", "-classpath", classpath, "-d", outDirPath, jFile};
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        int result = Main.compile((String[])args, (PrintWriter)pw);
        if (0 != result) {
            Document doc = XMLUtils.newDocument();
            Element root = doc.createElementNS("", "Errors");
            StringBuffer message = new StringBuffer("Error compiling ");
            message.append(jFile);
            message.append(":\n");
            message.append(sw.toString());
            message.append("\n");
            root.appendChild(doc.createTextNode(message.toString()));
            AxisFault af = new AxisFault("Server.compileError", Messages.getMessage((String)"badCompile00", (String)jFile), null, new Element[]{root});
            log.warn((Object)"Error compiling JWS", (Throwable)af);
            throw af;
        }
        return result;
    }
}

