/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.wsm.axis.util.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3.x2001.xmlSchema.SchemaDocument;
import org.w3.x2001.xmlSchema.TopLevelComplexType;
import org.w3.x2001.xmlSchema.TopLevelElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xmlsoap.schemas.wsdl.DefinitionsDocument;
import org.xmlsoap.schemas.wsdl.TDefinitions;

public class XmlBeanSerializer
implements Serializer {
    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        if (!(value instanceof XmlObject)) {
            throw new IOException((value != null ? value.getClass().getName() : "null") + " is not an " + XmlObject.class.getName());
        }
        context.setWriteXMLType(null);
        context.startElement(name, attributes);
        Node n = ((XmlObject)value).newDomNode();
        NodeList kids = n.getChildNodes();
        for (int j = 0; j < kids.getLength(); ++j) {
            Node kid = kids.item(j);
            if (kid.getNodeType() != 1) continue;
            context.writeDOMElement((Element)kid);
        }
        context.endElement();
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        if (XmlObject.class.isAssignableFrom(javaType)) {
            SchemaType docType = XmlBeans.typeForClass((Class)javaType);
            Document doc = types.createElement("deleteme").getOwnerDocument();
            XmlOptions opts = new XmlOptions().setLoadReplaceDocumentElement(null);
            Element root = doc.getDocumentElement();
            InputStream stream = docType.getTypeSystem().getSourceAsStream(docType.getSourceName());
            SchemaDocument schemaDoc = SchemaDocument.Factory.parse((InputStream)stream);
            DefinitionsDocument defDoc = DefinitionsDocument.Factory.newInstance();
            TDefinitions definitions = defDoc.addNewDefinitions();
            definitions.addNewService();
            Node defEl = definitions.newDomNode(new XmlOptions().setSaveOuter());
            Document dDoc = defEl.getOwnerDocument();
            if (null == dDoc.getDocumentElement()) {
                dDoc.appendChild(defEl);
            }
            HashSet<String> existingNameSpaces = new HashSet<String>();
            if (dDoc != null) {
                types.insertTypesFragment(dDoc);
                Element e = (Element)dDoc.getFirstChild().getFirstChild().getFirstChild();
                if (e != null) {
                    String tn = e.getAttribute("targetNamespace");
                    existingNameSpaces.add(tn);
                    while (null != (e = (Element)e.getNextSibling())) {
                        tn = e.getAttribute("targetNamespace");
                        existingNameSpaces.add(tn);
                    }
                }
            } else {
                throw new Exception("null document");
            }
            SchemaDocument.Schema schema = schemaDoc.getSchema();
            String targetNamespace = schema.getTargetNamespace();
            if (targetNamespace != null) {
                System.out.println(existingNameSpaces);
                if (!existingNameSpaces.contains(targetNamespace)) {
                    TopLevelElement[] elements;
                    TopLevelComplexType[] schemaTypes;
                    for (TopLevelComplexType top : schemaTypes = schema.getComplexTypeArray()) {
                        types.writeSchemaElement(targetNamespace, (Element)doc.importNode(top.newDomNode().getFirstChild(), true));
                    }
                    for (TopLevelElement element : elements = schemaDoc.getSchema().getElementArray()) {
                        types.writeSchemaElement(targetNamespace, (Element)doc.importNode(element.newDomNode().getFirstChild(), true));
                    }
                }
                return null;
            }
            throw new Exception(javaType.getName() + "did not specify a target namspace");
        }
        throw new Exception(javaType.getName() + " must be a subclass of XmlObject");
    }
}

