/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.user.hibernate;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.incongru.berkano.user.GroupImpl;
import net.incongru.berkano.user.User;
import net.incongru.berkano.user.UserImpl;
import net.incongru.berkano.user.extensions.UserPropertyAccessor;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;

public class HibernatedUserPropertyAccessor
implements UserPropertyAccessor {
    private Session session;

    public HibernatedUserPropertyAccessor(Session session) {
        this.session = session;
    }

    public Object getUserOnlyValue(User u, String key) {
        try {
            this.session.lock((Object)u, LockMode.NONE);
            return ((UserImpl)u).getProperty(key);
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getFirstValue(User u, String key) {
        try {
            this.session.lock((Object)u, LockMode.NONE);
            Object value = ((UserImpl)u).getProperty(key);
            if (value != null) {
                return value;
            }
            for (GroupImpl g : u.getGroups()) {
                value = g.getProperty(key);
                if (value == null) continue;
                return value;
            }
            return null;
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getSingleValue(User u, String key) {
        try {
            this.session.lock((Object)u, LockMode.NONE);
            Object value = ((UserImpl)u).getProperty(key);
            if (value != null) {
                return value;
            }
            return this.getGroupSingleValue(u, key);
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getGroupSingleValue(User u, String key) {
        try {
            this.session.lock((Object)u, LockMode.NONE);
            Object value = null;
            int definedInGroupsCount = 0;
            for (GroupImpl g : ((UserImpl)u).getGroups()) {
                Object groupValue = g.getProperty(key);
                if (groupValue == null) continue;
                value = groupValue;
                ++definedInGroupsCount;
            }
            if (definedInGroupsCount > 1) {
                throw new IllegalStateException("Property " + key + " is defined in several groups of the user");
            }
            return value;
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection getValues(User u, String key) {
        try {
            this.session.lock((Object)u, LockMode.NONE);
            Collection values = this.getGroupValues(u, key);
            Object v = ((UserImpl)u).getProperty(key);
            if (v != null) {
                values.add(v);
            }
            return values;
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection getGroupValues(User u, String key) {
        try {
            this.session.lock((Object)u, LockMode.NONE);
            LinkedList<Object> values = new LinkedList<Object>();
            for (GroupImpl g : ((UserImpl)u).getGroups()) {
                Object v = g.getProperty(key);
                if (v == null) continue;
                values.add(v);
            }
            return values;
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public Object aggregate(User u, String key) {
        try {
            this.session.lock((Object)u, LockMode.NONE);
            Cloneable result = null;
            Collection values = this.getValues(u, key);
            for (Object o : values) {
                if (result == null) {
                    if (o instanceof Collection) {
                        result = new LinkedList((Collection)o);
                        continue;
                    }
                    if (o instanceof Map) {
                        result = new HashMap((Map)o);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported property type : " + o.getClass().getName());
                }
                if (o instanceof Collection) {
                    ((Collection)((Object)result)).addAll((Collection)o);
                    continue;
                }
                if (o instanceof Map) {
                    ((Map)((Object)result)).putAll((Map)o);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported property type : " + o.getClass());
            }
            return result;
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }
}

