/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LoggableObject;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public class LatchedLogManager
extends LogManager {
    public LatchedLogManager(EnvironmentImpl envImpl, boolean readOnly) throws DatabaseException {
        super(envImpl, readOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogManager.LogResult logItem(LoggableObject item, boolean isProvisional, boolean flushRequired, boolean forceNewLogFile, long oldNodeLsn, boolean marshallOutsideLatch, ByteBuffer marshalledBuffer, UtilizationTracker tracker) throws IOException, DatabaseException {
        this.logWriteLatch.acquire();
        try {
            LogManager.LogResult logResult = this.logInternal(item, isProvisional, flushRequired, forceNewLogFile, oldNodeLsn, marshallOutsideLatch, marshalledBuffer, tracker);
            return logResult;
        }
        finally {
            this.logWriteLatch.release();
        }
    }

    protected void flushInternal() throws LogException, DatabaseException {
        this.logWriteLatch.acquire();
        try {
            this.logBufferPool.writeBufferToFile(0);
        }
        catch (IOException e) {
            throw new LogException(e.getMessage());
        }
        finally {
            this.logWriteLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrackedFileSummary getUnflushableTrackedSummary(long file) throws DatabaseException {
        this.logWriteLatch.acquire();
        try {
            TrackedFileSummary trackedFileSummary = this.getUnflushableTrackedSummaryInternal(file);
            return trackedFileSummary;
        }
        finally {
            this.logWriteLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countObsoleteNode(long lsn, LogEntryType type) throws DatabaseException {
        UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
        this.logWriteLatch.acquire();
        try {
            this.countObsoleteNodeInternal(tracker, lsn, type);
        }
        finally {
            this.logWriteLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countObsoleteNodes(TrackedFileSummary[] summaries) throws DatabaseException {
        UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
        this.logWriteLatch.acquire();
        try {
            this.countObsoleteNodesInternal(tracker, summaries);
        }
        finally {
            this.logWriteLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countObsoleteINs(List lsnList) throws DatabaseException {
        this.logWriteLatch.acquire();
        try {
            this.countObsoleteINsInternal(lsnList);
        }
        finally {
            this.logWriteLatch.release();
        }
    }
}

