/*
 * Decompiled with CFR 0.152.
 */
package bi.deep;

import bi.deep.EncryptionUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.inject.Named;
import org.apache.druid.metadata.PasswordProvider;

@Named(value="encrypting")
public class EncryptingPasswordProvider
implements PasswordProvider {
    public static final String TYPE_KEY = "encrypting";
    private final String encrypted;

    @JsonCreator
    public EncryptingPasswordProvider(@JsonProperty(value="encrypted") String encrypted) {
        this.encrypted = encrypted;
    }

    @JsonIgnore
    public String getPassword() {
        try {
            return EncryptionUtils.decryptBase64(this.encrypted, EncryptionUtils.getSecretKey());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @JsonProperty(value="encrypted")
    public String getEncrypted() {
        return this.encrypted;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EncryptingPasswordProvider)) {
            return false;
        }
        EncryptingPasswordProvider other = (EncryptingPasswordProvider)obj;
        return this.encrypted.equals(other.encrypted);
    }

    public int hashCode() {
        return this.encrypted.hashCode();
    }
}

