/*
 * Decompiled with CFR 0.152.
 */
package bi.deep;

import bi.deep.EncryptionUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class Encryptor {
    private static Properties loadProperties(String filename) {
        Properties properties = new Properties();
        try {
            properties.load(Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]));
        }
        catch (IOException e) {
            System.out.println("Error loading properties file: " + filename);
            System.exit(1);
        }
        return properties;
    }

    private static void printProperties(Properties properties) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> System.out.println(k + "=" + v)));
    }

    private static String encryptProperty(String property) throws Exception {
        return "{\"type\": \"encrypting\", \"encrypted\": \"" + EncryptionUtils.encryptBase64(property, EncryptionUtils.getSecretKey()) + "\"}";
    }

    private static void encryptProperties(String filename, List<String> properties) {
        List extensions;
        Properties props = Encryptor.loadProperties(filename);
        properties.forEach(prop -> {
            try {
                props.setProperty((String)prop, Encryptor.encryptProperty(props.getProperty((String)prop)));
            }
            catch (Exception e) {
                System.out.println("Error encrypting property: " + prop);
                System.exit(1);
            }
        });
        String loadList = props.getProperty("druid.extensions.loadList");
        if (loadList != null && !(extensions = Arrays.stream(loadList.split(",")).map(ext -> ext.replace('[', ' ').replace(']', ' ').trim()).collect(Collectors.toList())).contains("\"druid-encrypting-password-provider\"")) {
            extensions.add(0, "\"druid-encrypting-password-provider\"");
            props.setProperty("druid.extensions.loadList", "[" + String.join((CharSequence)",", extensions) + "]");
        }
        Encryptor.printProperties(props);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: java -jar Encryptor.jar <file.conf> <property1> [<propert2> ...]");
            System.exit(1);
        }
        Encryptor.encryptProperties(args[0], Arrays.asList(args).subList(1, args.length));
    }
}

