/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classpath;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.classpath.BndContainerInitializer;
import aQute.bnd.plugin.Central;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BndContainer
implements IClasspathContainer {
    static final IClasspathEntry[] ICLASSPATHENTRY_EMPTY = new IClasspathEntry[0];
    final Project project;
    volatile int count;
    volatile IClasspathEntry[] cachedEntries;

    BndContainer(Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClasspathEntry[] getClasspathEntries() {
        boolean cached;
        boolean bl = cached = this.cachedEntries != null && this.count == this.project.getChanged();
        if (!cached) {
            Project project = this.project;
            synchronized (project) {
                this.count = this.project.getChanged();
                try {
                    ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
                    ArrayList<Container> entries = new ArrayList<Container>();
                    entries.addAll(this.project.getBuildpath());
                    if (entries.size() > 0) {
                        entries.remove(0);
                    } else {
                        System.err.println("Huh? Should have the bin dir! " + entries);
                    }
                    entries.addAll(this.project.getBootclasspath());
                    for (Container c : entries) {
                        File sourceDir;
                        IPath sourceAttachment = null;
                        if (c.getError() != null) continue;
                        File file = c.getFile();
                        assert (file.isAbsolute());
                        IPath p = Central.toPath(this.project, file);
                        try {
                            Central.refresh(p);
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        if (c.getType() == Container.TYPE.PROJECT && (sourceDir = c.getProject().getSrc()).isDirectory()) {
                            sourceAttachment = Central.toPath(c.getProject(), sourceDir);
                        }
                        IClasspathEntry cpe = JavaCore.newLibraryEntry((IPath)p, sourceAttachment, null);
                        result.add(cpe);
                    }
                    this.cachedEntries = result.toArray(ICLASSPATHENTRY_EMPTY);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.cachedEntries;
    }

    private Collection<File> toFiles(Collection<Container> path) {
        ArrayList<File> result = new ArrayList<File>(path.size());
        for (Container c : path) {
            if (c.getError() != null) continue;
            result.add(c.getFile());
        }
        return result;
    }

    public String getDescription() {
        return "bnd";
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return BndContainerInitializer.ID;
    }

    public Project getModel() {
        return this.project;
    }
}

