/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.make;

import aQute.bnd.annotation.Activate;
import aQute.bnd.annotation.Component;
import aQute.bnd.annotation.Deactivate;
import aQute.bnd.annotation.Modified;
import aQute.bnd.annotation.Reference;
import aQute.bnd.annotation.Unreference;
import aQute.bnd.make.ComponentDef;
import aQute.lib.osgi.Annotation;
import aQute.lib.osgi.ClassDataCollector;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.FileResource;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AnnotationReader
extends ClassDataCollector {
    StringBuilder sb = new StringBuilder();
    String method;
    String methodDescriptor;
    String className;
    Clazz clazz;
    String[] interfaces;
    ComponentDef def = new ComponentDef();
    static final String COMPONENT_ANNOTATION = "L" + Component.class.getName().replace('.', '/') + ";";
    static final String REFERENCE_ANNOTATION = "L" + Reference.class.getName().replace('.', '/') + ";";
    static final String UNREFERENCE_ANNOTATION = "L" + Unreference.class.getName().replace('.', '/') + ";";
    static final String ACTIVATE_ANNOTATION = "L" + Activate.class.getName().replace('.', '/') + ";";
    static final String DEACTIVATE_ANNOTATION = "L" + Deactivate.class.getName().replace('.', '/') + ";";
    static final String MODIFIED_ANNOTATION = "L" + Modified.class.getName().replace('.', '/') + ";";
    static Pattern BINDDESCRIPTOR = Pattern.compile("\\(L(.*);\\)V");
    static Pattern BINDMETHOD = Pattern.compile("(unset|set|bind|unbind)?(.)(.*)");

    public ComponentDef getComponent() throws Exception {
        this.clazz.parseClassFileWithCollector(this);
        if (this.def.name != null) {
            return this.def;
        }
        return null;
    }

    public static ComponentDef getComponentDef(Clazz clazz) throws Exception {
        AnnotationReader car = new AnnotationReader(clazz);
        return car.getComponent();
    }

    public static ComponentDef getComponentDef(File f) throws Exception {
        FileResource r = new FileResource(f);
        Clazz c = new Clazz("", r);
        AnnotationReader car = new AnnotationReader(c);
        return car.getComponent();
    }

    AnnotationReader(Clazz clazz) {
        this.clazz = clazz;
    }

    public void annotation(Annotation annotation) {
        if (annotation.getName().equals(COMPONENT_ANNOTATION)) {
            this.def.name = (String)annotation.get("name");
            this.def.factory = (String)annotation.get("factory");
            this.def.enabled = (Boolean)annotation.get("enabled");
            this.def.immediate = (Boolean)annotation.get("immediate");
            String cp = (String)annotation.get("configurationPolicy");
            if (cp != null) {
                this.def.configurationPolicy = cp.toLowerCase();
            }
            if (this.def.name == null) {
                this.def.name = this.className;
            }
            this.def.implementation = this.className.replace('/', '.');
            Object[] provides = (Object[])annotation.get("provides");
            if (provides == null) {
                this.def.provides = this.interfaces;
            } else {
                this.def.provides = new String[provides.length];
                for (int i = 0; provides != null && i < provides.length; ++i) {
                    this.def.provides[i] = this.descriptorToFQN(provides[i].toString());
                }
            }
        } else if (annotation.getName().equals(ACTIVATE_ANNOTATION)) {
            this.def.activate = this.method;
        } else if (annotation.getName().equals(DEACTIVATE_ANNOTATION)) {
            this.def.deactivate = this.method;
        } else if (annotation.getName().equals(MODIFIED_ANNOTATION)) {
            this.def.modified = this.method;
        } else if (annotation.getName().equals(REFERENCE_ANNOTATION)) {
            ComponentDef.Reference ref = this.getReference(annotation, this.method);
            ref.multiple = (Boolean)annotation.get("multiple");
            ref.optional = (Boolean)annotation.get("optional");
            ref.dynamic = (Boolean)annotation.get("dynamic");
            Integer c = (Integer)annotation.get("type");
            if (c != null) {
                switch (c) {
                    case 0: {
                        break;
                    }
                    case 63: {
                        ref.multiple = false;
                        ref.optional = true;
                        ref.dynamic = true;
                        break;
                    }
                    case 42: {
                        ref.multiple = true;
                        ref.optional = true;
                        ref.dynamic = true;
                        break;
                    }
                    case 43: {
                        ref.multiple = true;
                        ref.optional = false;
                        ref.dynamic = true;
                        break;
                    }
                    case 49: {
                        ref.multiple = false;
                        ref.optional = false;
                        ref.dynamic = false;
                        break;
                    }
                    case 126: {
                        ref.multiple = false;
                        ref.optional = true;
                        ref.dynamic = false;
                    }
                }
            }
            ref.target = (String)annotation.get("target");
            ref.bind = this.method;
            this.setService(ref, this.methodDescriptor);
        } else if (annotation.getName().equals(UNREFERENCE_ANNOTATION)) {
            ComponentDef.Reference ref = this.getReference(annotation, this.method);
            ref.unbind = this.method;
            this.setService(ref, this.methodDescriptor);
        }
    }

    private String descriptorToFQN(String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < string.length() - 1; ++i) {
            char c = string.charAt(i);
            if (c == '/') {
                c = '.';
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private ComponentDef.Reference getReference(Annotation annotation, String method) {
        String name = (String)annotation.get("name");
        if (name == null) {
            Matcher m = BINDMETHOD.matcher(method);
            name = m.matches() ? m.group(2).toLowerCase() + m.group(3) : method;
        }
        return this.def.newReference(name);
    }

    void setService(ComponentDef.Reference ref, String descriptor) {
        Matcher m = BINDDESCRIPTOR.matcher(descriptor);
        if (m.matches()) {
            String s = m.group(1).replace('/', '.');
            if (ref.service == null) {
                ref.service = s;
            } else if (!ref.service.equals(s)) {
                throw new IllegalArgumentException("the bind and unbind method use different types for " + ref.name);
            }
        }
    }

    public void classBegin(int access, String name) {
        this.className = name;
    }

    public void implementsInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    public void method(int access, String name, String descriptor) {
        this.method = name;
        this.methodDescriptor = descriptor;
    }
}

