/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.base64;

import java.io.ByteArrayOutputStream;

public class Base64 {
    byte[] data;
    static final String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    static byte[] values;

    public Base64(byte[] data) {
        this.data = data;
    }

    public static final byte[] decodeBase64(String string) {
        string = string.trim();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int register = 0;
        int i = 0;
        int pads = 0;
        byte[] test = new byte[3];
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c > '\u007f') {
                throw new IllegalArgumentException("Invalid base64 character in " + string + ", character value > 128 ");
            }
            byte v = 0;
            if (c == '=') {
                ++pads;
            } else {
                v = values[c];
                if (v < 0) {
                    throw new IllegalArgumentException("Invalid base64 character in " + string + ", " + c);
                }
            }
            register <<= 6;
            test[2] = (byte)((register |= v) & 0xFF);
            test[1] = (byte)(register >> 8 & 0xFF);
            test[0] = (byte)(register >> 16 & 0xFF);
            if (++i % 4 != 0) continue;
            Base64.flush(out, register, pads);
            register = 0;
            pads = 0;
        }
        return out.toByteArray();
    }

    private static void flush(ByteArrayOutputStream out, int register, int pads) {
        switch (pads) {
            case 0: {
                out.write(0xFF & register >> 16);
                out.write(0xFF & register >> 8);
                out.write(0xFF & register >> 0);
                break;
            }
            case 1: {
                out.write(0xFF & register >> 16);
                out.write(0xFF & register >> 8);
                break;
            }
            case 2: {
                out.write(0xFF & register >> 16);
            }
        }
    }

    public Base64(String s) {
        this.data = Base64.decodeBase64(s);
    }

    public String toString() {
        return Base64.encodeBase64(this.data);
    }

    public static String encodeBase64(byte[] data) {
        int mod;
        StringBuffer sb = new StringBuffer();
        int buf = 0;
        int bits = 0;
        int n = 0;
        while (true) {
            if (bits >= 6) {
                int v = 0x3F & buf >> (bits -= 6);
                sb.append(alphabet.charAt(v));
                continue;
            }
            if (n >= data.length) break;
            buf <<= 8;
            buf |= 0xFF & data[n++];
            bits += 8;
        }
        if (bits != 0) {
            sb.append(alphabet.charAt(0x3F & buf << 6 - bits));
        }
        if ((mod = 4 - sb.length() % 4) != 4) {
            for (int i = 0; i < mod; ++i) {
                sb.append('=');
            }
        }
        return sb.toString();
    }

    public Object toData() {
        return this.data;
    }

    static {
        int i;
        values = new byte[128];
        for (i = 0; i < values.length; ++i) {
            Base64.values[i] = -1;
        }
        for (i = 0; i < alphabet.length(); ++i) {
            char c = alphabet.charAt(i);
            Base64.values[c] = (byte)i;
        }
    }
}

