package aQute.bnd.make;

import java.io.*;
import java.util.*;

import aQute.lib.filter.*;
import aQute.lib.osgi.*;
import aQute.libg.version.*;

public class ComponentDef extends Processor {
    class Reference {
        Boolean multiple;
        Boolean optional;
        Boolean dynamic;
        String  target;
        String  name;
        String  bind;
        String  unbind;
        String  service;
    }

    String              name;
    String              implementation;
    String[]            provides;
    String              activate;
    String              deactivate;
    String              modified;
    String              factory;
    Boolean             enabled;
    Boolean             immediate;
    String              configurationPolicy;
    List<Reference>     references = new ArrayList<Reference>();
    Version             version;
    Boolean             serviceFactory;
    Map<String, Object> properties;

    public Reference newReference(String name) {
        for (ComponentDef.Reference ref : references) {
            if (ref.name.equals(name))
                return ref;
        }
        Reference ref = new Reference();
        ref.name = name;
        references.add(ref);
        return ref;
    }

    public void append(Appendable a) throws IOException {
        String namespace = getNamespace();
        a.append("<?xml version='1.0' encoding='utf-8'?>\n");
        a.append("<component name='" + name + "'");
        doAttribute(a, "\n   xmlns", namespace);

        doAttribute(a, "factory", factory);
        doAttribute(a, "immediate", immediate, "false", "true");
        doAttribute(a, "enabled", enabled, "true", "false");
        if (configurationPolicy != null
                && !"optional".equals(configurationPolicy))
            doAttribute(a, "configuration-policy", configurationPolicy,
                    "optional", "require", "ignore");
        doAttribute(a, "activate", activate, ServiceComponent.JIDENTIFIER);
        doAttribute(a, "deactivate", deactivate, ServiceComponent.JIDENTIFIER);
        doAttribute(a, "modified", modified, ServiceComponent.JIDENTIFIER);

        a.append(">\n");

        // Allow override of the implementation when people
        // want to choose their own name
        if (implementation == null)
            error("No Implementation specified in component " + name);
        else {
            a.append("  <implementation");
            doAttribute(a, "class", implementation);
            a.append("/>\n");
        }

        if (provides != null) {
            a.append("  <service");
            doAttribute(a, "servicefactory", serviceFactory, "true", "false");
            a.append(">\n");
            for (String provide : provides) {
                a.append("    <provide");
                doAttribute(a, "interface", provide);
                a.append(">\n");
            }
            a.append("  </service>\n");
        }

        if (properties != null) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                property(a, entry.getKey(), entry.getValue());
            }
        }

        for (Reference ref : references) {
            a.append("  <reference");
            doAttribute(a, "name", ref.name);

            doAttribute(a, "interface", ref.service);

            if (ref.optional == null)
                ref.optional = false;
            if (ref.multiple == null)
                ref.multiple = false;

            String cardinality = ref.optional ? "0" : "1";
            cardinality += "..";
            cardinality += ref.multiple ? "n" : "1";

            if (!cardinality.equals("1..1"))
                doAttribute(a, "cardinality", cardinality);

            doAttribute(a, "bind", ref.bind, ServiceComponent.JIDENTIFIER);
            doAttribute(a, "unbind", ref.unbind, ServiceComponent.JIDENTIFIER);

            if (ref.dynamic != null && ref.dynamic) {
                doAttribute(a, "policy", "dynamic");
            }

            if (ref.target != null) {
                // Filter filter = new Filter(ref.target);
                // if (filter.verify() == null)
                // doAttribute(a, "target", filter.toString());
                // else
                // error("Target for " + ref.name
                // + " is not a correct filter: " + ref.target + " "
                // + filter.verify());
                doAttribute(a, "target", ref.target.trim());
            }
            a.append("/>\n");
        }
        a.append("</component>\n");
    }

    private void property(Appendable a, String key, Object value)
            throws IOException {
        a.append("<property");
        doAttribute(a, "name", key);

        boolean array = false;
        Class<?> type = value.getClass();
        if (type.isArray()) {
            type = type.getComponentType();
            array = true;
        }

        if (type != String.class)
            doAttribute(a, "type", type.getName());

        if (array) {
            a.append(">\n");
            Object parts[] = (Object[]) value;
            for (Object part : parts) {
                a.append(part.toString());
                a.append("\n");
            }
            a.append("</property>");
        } else {
            doAttribute(a, "value", value);
            a.append("/>\n");
        }
    }

    private void doAttribute(Appendable pw, String name, Object value,
            String... matches) throws IOException {
        if (value != null) {
            String v = value.toString();
            if (matches.length != 0) {
                if (matches.length == 1
                        && matches[0].equals(ServiceComponent.JIDENTIFIER)) {
                    if (!Verifier.isIdentifier(v))
                        error(
                                "Component attribute %s has value %s but is not a Java identifier",
                                name, v);
                } else {

                    if (!Verifier.isMember(v, matches))
                        error(
                                "Component attribute %s has value %s but is not a member of %s",
                                name, value, Arrays.toString(matches));
                }
            }
            pw.append(" ");
            pw.append(name);
            pw.append("='");
            pw.append(v);
            pw.append("'");
        }
    }

    private String getNamespace() {
        if (version != null) {
            try {
                return ServiceComponent.NAMESPACE_STEM + "/v" + version;
            } catch (Exception e) {
                error("version: specified on component header but not a valid version: "
                        + version);
                return null;
            }
        }
        if (modified != null || configurationPolicy != null) {
            version = new Version("1.1.0");
            return ServiceComponent.NAMESPACE_STEM + "/v1.1.0";
        }
        return null;
    }
}
