/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.gradle;

import aQute.bnd.gradle.BndUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.provider.Provider;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanProperties
extends Properties {
    private static final Logger logger = LoggerFactory.getLogger(BeanProperties.class);
    private static final Pattern KEY_P = Pattern.compile("(?<name>[^\\.\\[]+)(?:\\[(?<index>\\d+)\\])?\\.?");
    private static final long serialVersionUID = 1L;
    protected Properties defaults;

    public BeanProperties() {
        this((Properties)null);
    }

    public BeanProperties(Properties defaults) {
        this.defaults = defaults;
    }

    @Override
    public String getProperty(String key) {
        Object value = this.get(key);
        if (value == null) {
            Matcher m = KEY_P.matcher(key);
            if (!m.find()) {
                return this.defaultValue(key);
            }
            String name = m.group("name");
            value = BeanProperties.value(name, this.get(name), m.group("index"));
            while (value != null && m.find()) {
                name = m.group("name");
                value = BeanProperties.value(name, BeanProperties.getField(value, name), m.group("index"));
            }
        }
        return (value = BeanProperties.unwrap(value)) != null ? value.toString() : this.defaultValue(key);
    }

    private String defaultValue(String key) {
        return this.defaults != null ? this.defaults.getProperty(key) : null;
    }

    private static Object unwrap(Object value) {
        if (value instanceof Provider) {
            value = BndUtils.unwrapOptional((Provider)value).orElse(null);
        }
        if (value instanceof FileSystemLocation) {
            value = BndUtils.unwrapFile((FileSystemLocation)value);
        }
        return value;
    }

    private static Object getField(Object target, String fieldName) {
        try {
            MethodHandle mh;
            if (target instanceof DynamicObjectAware) {
                DynamicObject dynamicObject = ((DynamicObjectAware)target).getAsDynamicObject();
                DynamicInvokeResult result = dynamicObject.tryGetProperty(fieldName);
                return result.isFound() ? result.getValue() : null;
            }
            String getterSuffix = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            Class<?> targetClass = target.getClass();
            while (!Modifier.isPublic(targetClass.getModifiers())) {
                targetClass = targetClass.getSuperclass();
            }
            try {
                mh = MethodHandles.publicLookup().unreflect(targetClass.getMethod("get" + getterSuffix, new Class[0]));
            }
            catch (NoSuchMethodException nsme) {
                mh = MethodHandles.publicLookup().unreflect(targetClass.getMethod("is" + getterSuffix, new Class[0]));
            }
            return mh.invoke(target);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            logger.debug("Could not find getter method for field {}", (Object)fieldName, (Object)e);
            return null;
        }
    }

    private static Object value(String name, Object value, String index) {
        if (value == null || index == null) {
            return value;
        }
        try {
            int i;
            if (value instanceof List) {
                return ((List)value).get(i);
            }
            if (value instanceof Iterable) {
                if (i < 0) {
                    throw new IndexOutOfBoundsException("index < 0");
                }
                Iterator iter = ((Iterable)value).iterator();
                for (i = Integer.parseInt(index); i > 0; --i) {
                    iter.next();
                }
                return iter.next();
            }
            if (value.getClass().isArray()) {
                return Array.get(value, i);
            }
        }
        catch (Exception e) {
            logger.debug("Could not find field {}[{}]", new Object[]{name, index, e});
        }
        return value;
    }
}

