/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.gradle;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.gradle.BndPlugin;
import aQute.bnd.gradle.BndUtils;
import aQute.bnd.unmodifiable.Sets;
import aQute.lib.strings.Strings;
import groovy.lang.Closure;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.Delete;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;

public class BndWorkspacePlugin
implements Plugin<Object> {
    public static final String PLUGINID = "biz.aQute.bnd.workspace";
    private static final Pattern OPTION_P = Pattern.compile("--(?<option>\\w+)(?:=(?<value>\\S+)?)?");
    private static final Pattern TASKNAME_SPLITTER = Pattern.compile(":");
    private static final Set<String> SPECIAL_FOLDERS = Sets.of((Object)"buildSrc", (Object)"gradle");

    public void apply(Object target) {
        block4: {
            try {
                if (target instanceof Settings) {
                    this.configureSettings((Settings)target);
                    break block4;
                }
                if (target instanceof org.gradle.api.Project) {
                    this.configureWorkspaceProject((org.gradle.api.Project)target);
                    break block4;
                }
                throw new GradleException(String.format("The target %s is not a Settings or a Project", target));
            }
            catch (Exception e) {
                throw Exceptions.duck((Throwable)e);
            }
        }
    }

    private void configureSettings(Settings settings) throws Exception {
        Project p;
        String projectName2;
        String bnd_build;
        DynamicObject dynamicObject = new DslObject((Object)settings).getAsDynamicObject();
        DynamicInvokeResult result = dynamicObject.tryGetProperty("bnd_build");
        String defaultProjectName = bnd_build = result.isFound() ? (String)result.getValue() : "";
        StartParameter startParameter = settings.getStartParameter();
        File rootDir = settings.getRootDir();
        File currentDir = startParameter.getCurrentDir();
        while (!Objects.equals(currentDir, rootDir)) {
            defaultProjectName = currentDir.getName();
            currentDir = currentDir.getParentFile();
        }
        LinkedHashSet<String> projectNames = new LinkedHashSet<String>();
        File[] iter = startParameter.getTaskNames().iterator();
        block5: while (iter.hasNext()) {
            String taskName = (String)iter.next();
            Matcher m = OPTION_P.matcher(taskName);
            if (m.matches()) {
                taskName = m.group("value");
                if (Objects.equals("tests", m.group("option"))) {
                    if (!Objects.isNull(taskName) || !iter.hasNext()) continue;
                    iter.next();
                    continue;
                }
                if (Objects.isNull(taskName)) continue;
            }
            String[] elements = TASKNAME_SPLITTER.split(taskName);
            switch (elements.length) {
                case 1: {
                    projectNames.add(defaultProjectName);
                    continue block5;
                }
                case 2: {
                    projectNames.add(elements[0].isEmpty() ? bnd_build : elements[0]);
                    continue block5;
                }
            }
            projectNames.add(elements[0].isEmpty() ? elements[1] : elements[0]);
        }
        if (!Objects.equals(startParameter.getCurrentDir(), rootDir) || projectNames.isEmpty()) {
            projectNames.add(defaultProjectName);
        }
        if (projectNames.remove("")) {
            for (File dir : rootDir.listFiles(File::isDirectory)) {
                projectName2 = dir.getName();
                if (projectName2.startsWith(".") || SPECIAL_FOLDERS.contains(projectName2)) continue;
                projectNames.add(projectName2);
            }
        }
        String cnf = (result = dynamicObject.tryGetProperty("bnd_cnf")).isFound() ? (String)result.getValue() : "cnf";
        projectNames.add(cnf);
        result = dynamicObject.tryGetProperty("bnd_include");
        if (result.isFound()) {
            Strings.splitAsStream((String)((String)result.getValue())).forEach(projectNames::add);
        }
        if ((result = dynamicObject.tryGetProperty("bnd_exclude")).isFound()) {
            Strings.splitAsStream((String)((String)result.getValue())).forEach(projectNames::remove);
        }
        projectNames.removeIf(projectName -> {
            File projectDir = new File(rootDir, (String)projectName);
            return new File(projectDir, "settings.gradle").isFile() || new File(projectDir, "settings.gradle.kts").isFile();
        });
        Workspace.setDriver((String)"gradle");
        Workspace.addGestalt((String)"batch", null);
        Workspace workspace = new Workspace(rootDir, cnf);
        workspace.setOffline(startParameter.isOffline());
        Gradle gradle = settings.getGradle();
        BndWorkspacePlugin.bndWorkspaceConfigure(workspace, gradle);
        for (Project p2 : workspace.getAllProjects()) {
            p2.prepare();
        }
        LinkedHashSet<String> projectGraph = new LinkedHashSet<String>();
        while (!projectNames.isEmpty()) {
            projectName2 = (String)projectNames.iterator().next();
            projectGraph.add(projectName2);
            p = workspace.getProject(projectName2);
            if (Objects.nonNull(p)) {
                p.getDependents().stream().map(Project::getName).forEach(projectNames::add);
            }
            projectNames.removeAll(projectGraph);
        }
        projectNames = projectGraph;
        projectGraph = new LinkedHashSet();
        while (!projectNames.isEmpty()) {
            projectName2 = (String)projectNames.iterator().next();
            projectGraph.add(projectName2);
            p = workspace.getProject(projectName2);
            if (Objects.nonNull(p)) {
                p.getTestDependencies().stream().map(Project::getName).forEach(projectNames::add);
            }
            projectNames.removeAll(projectGraph);
        }
        settings.include(projectGraph.toArray(new String[0]));
        gradle.rootProject(project -> {
            ExtraPropertiesExtension ext = project.getExtensions().getExtraProperties();
            ext.set("bnd_cnf", (Object)cnf);
            ext.set("bndWorkspace", (Object)workspace);
            project.getPluginManager().apply(BndWorkspacePlugin.class);
        });
    }

    private void configureWorkspaceProject(org.gradle.api.Project workspace) throws Exception {
        Workspace bndWorkspace = BndWorkspacePlugin.getBndWorkspace(workspace);
        for (org.gradle.api.Project project : workspace.getSubprojects()) {
            if (!Objects.nonNull(bndWorkspace.getProject(project.getName()))) continue;
            project.getPluginManager().apply(BndPlugin.class);
        }
    }

    public static Workspace getBndWorkspace(org.gradle.api.Project workspace) throws Exception {
        org.gradle.api.Project cnfProject;
        Workspace bndWorkspace;
        ExtraPropertiesExtension ext = workspace.getExtensions().getExtraProperties();
        String bnd_cnf = (String)workspace.findProperty("bnd_cnf");
        if (Objects.isNull(bnd_cnf)) {
            bnd_cnf = "cnf";
            ext.set("bnd_cnf", (Object)bnd_cnf);
        }
        if (Objects.isNull(bndWorkspace = (Workspace)workspace.findProperty("bndWorkspace"))) {
            Workspace.setDriver((String)"gradle");
            Workspace.addGestalt((String)"batch", null);
            Gradle gradle = workspace.getGradle();
            File rootDir = BndUtils.unwrapFile((FileSystemLocation)workspace.getLayout().getProjectDirectory());
            bndWorkspace = new Workspace(rootDir, bnd_cnf);
            bndWorkspace.setOffline(gradle.getStartParameter().isOffline());
            ext.set("bndWorkspace", (Object)bndWorkspace);
            BndWorkspacePlugin.bndWorkspaceConfigure(bndWorkspace, gradle);
        }
        if (Objects.isNull(cnfProject = (org.gradle.api.Project)workspace.findProperty("cnf")) && Objects.nonNull(cnfProject = workspace.findProject(bnd_cnf))) {
            ext.set("cnf", (Object)cnfProject);
            Directory cacheDir = cnfProject.getLayout().getProjectDirectory().dir("cache");
            cnfProject.getTasks().register("cleanCache", Delete.class, t -> {
                t.setDescription("Clean the cnf cache folder.");
                t.setGroup("build");
                t.delete(new Object[]{cacheDir});
            });
        }
        return bndWorkspace;
    }

    private static void bndWorkspaceConfigure(Workspace workspace, Gradle gradle) {
        ExtraPropertiesExtension ext = new DslObject((Object)gradle).getExtensions().getExtraProperties();
        if (ext.has("bndWorkspaceConfigure")) {
            Object bndWorkspaceConfigure = ext.get("bndWorkspaceConfigure");
            if (bndWorkspaceConfigure instanceof Closure) {
                Closure closure = (Closure)bndWorkspaceConfigure;
                closure.call((Object)workspace);
            } else if (bndWorkspaceConfigure instanceof Action) {
                Action action = (Action)bndWorkspaceConfigure;
                action.execute((Object)workspace);
            } else {
                throw new GradleException(String.format("The bndWorkspaceConfigure %s is not a Closure or an Action", bndWorkspaceConfigure));
            }
        }
    }
}

