/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.gradle;

import aQute.bnd.gradle.BndUtils;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.repository.SimpleIndexer;
import aQute.lib.io.IO;
import aQute.service.reporter.Report;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class Index
extends DefaultTask {
    private final Property<URI> base;
    private final ConfigurableFileCollection bundles;
    private final DirectoryProperty destinationDirectory;
    private boolean gzip = false;
    private final Property<String> indexName;
    private final Property<String> repositoryName;
    private final RegularFileProperty indexUncompressed;
    private final RegularFileProperty indexCompressed;

    @Input
    public Property<URI> getBase() {
        return this.base;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public ConfigurableFileCollection getBundles() {
        return this.bundles;
    }

    @Internal(value="Represented by indexUncompressed and indexCompressed")
    public DirectoryProperty getDestinationDirectory() {
        return this.destinationDirectory;
    }

    @Input
    public boolean isGzip() {
        return this.gzip;
    }

    @Internal
    public boolean getGzip() {
        return this.isGzip();
    }

    public void setGzip(boolean gzip) {
        this.gzip = gzip;
    }

    @Internal(value="Represented by indexUncompressed and indexCompressed")
    public Property<String> getIndexName() {
        return this.indexName;
    }

    @Input
    public Property<String> getRepositoryName() {
        return this.repositoryName;
    }

    @OutputFile
    public RegularFileProperty getIndexUncompressed() {
        return this.indexUncompressed;
    }

    @OutputFile
    public RegularFileProperty getIndexCompressed() {
        return this.indexCompressed;
    }

    public Index() {
        this.setGroup("publishing");
        Project project = this.getProject();
        ObjectFactory objects = project.getObjects();
        this.indexName = objects.property(String.class).convention((Object)"index.xml");
        this.repositoryName = objects.property(String.class).convention((Object)this.getName());
        this.bundles = objects.fileCollection();
        this.destinationDirectory = objects.directoryProperty().convention((Provider)project.getLayout().getBuildDirectory());
        this.base = objects.property(URI.class).convention(this.getDestinationDirectory().map(d -> BndUtils.unwrapFile((FileSystemLocation)d).toURI()));
        this.indexUncompressed = objects.fileProperty().convention(this.getDestinationDirectory().file(this.getIndexName()));
        this.indexCompressed = objects.fileProperty().convention(this.getDestinationDirectory().file(this.getIndexName().map(n -> n.concat(".gz"))));
    }

    public ConfigurableFileCollection bundles(Object ... paths) {
        return BndUtils.builtBy(this.getBundles().from(paths), paths);
    }

    public void setBundles(Object path) {
        this.getBundles().setFrom(Collections.emptyList());
        this.getBundles().setBuiltBy(Collections.emptyList());
        this.bundles(path);
    }

    @TaskAction
    public void indexerAction() throws Exception {
        block11: {
            File indexUncompressedFile = BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)this.getIndexUncompressed());
            try (Processor processor = new Processor();){
                List sortedBundles = this.getBundles().getFiles().stream().sorted().collect(Collectors.toList());
                this.getLogger().info("Generating index for {}.", sortedBundles);
                new SimpleIndexer().reporter((Reporter)processor).files(sortedBundles).base(BndUtils.unwrap(this.getBase())).name(BndUtils.unwrap(this.getRepositoryName())).index(indexUncompressedFile);
                BndUtils.logReport((Report)processor, this.getLogger());
                if (!processor.isOk()) {
                    this.failTask(String.format("Index %s has errors", indexUncompressedFile), indexUncompressedFile);
                }
                this.getLogger().info("Generated index {}.", (Object)indexUncompressedFile);
                if (!this.isGzip()) break block11;
                File indexCompressedFile = BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)this.getIndexCompressed());
                try (GZIPOutputStream out = new GZIPOutputStream(IO.outputStream((File)indexCompressedFile));){
                    IO.copy((File)indexUncompressedFile, (OutputStream)out);
                }
                this.getLogger().info("Generated index {}.", (Object)indexCompressedFile);
            }
        }
    }

    private void failTask(String msg, File outputFile) {
        IO.delete((File)outputFile);
        throw new GradleException(msg);
    }
}

