/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.baseline.plugin;

import aQute.bnd.differ.Baseline;
import aQute.bnd.differ.DiffPluginImpl;
import aQute.bnd.header.Parameters;
import aQute.bnd.maven.baseline.plugin.Base;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.diff.Diff;
import aQute.bnd.service.diff.Differ;
import aQute.bnd.version.MavenVersion;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Objects;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="baseline", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class BaselineMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(BaselineMojo.class);
    private static final String PACKAGING_POM = "pom";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession session;
    @Parameter(property="bnd.baseline.fail.on.missing", defaultValue="true")
    private boolean failOnMissing;
    @Parameter(property="bnd.baseline.include.distribution.management", defaultValue="true")
    private boolean includeDistributionManagement;
    @Parameter(property="bnd.baseline.full.report", defaultValue="false")
    private boolean fullReport;
    @Parameter(property="bnd.baseline.continue.on.error", defaultValue="false")
    private boolean continueOnError;
    @Parameter(property="bnd.baseline.base.coordinates")
    private String baseCoordinates;
    @Parameter(required=false)
    private Base base;
    @Parameter(required=false, property="bnd.baseline.diffignores")
    private List<String> diffignores;
    @Parameter(required=false, defaultValue="*", property="bnd.baseline.diffpackages")
    private List<String> diffpackages;
    @Parameter(property="bnd.baseline.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="bnd.baseline.releaseversions", defaultValue="false")
    private boolean releaseversions;
    @Component
    private RepositorySystem system;
    @Parameter(property="bnd.baseline.report.file", defaultValue="${project.build.directory}/baseline/${project.build.finalName}.txt")
    private File reportFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            logger.debug("skip project as configured");
            return;
        }
        if (PACKAGING_POM.equals(this.project.getPackaging())) {
            logger.info("skip project with packaging=pom");
            return;
        }
        org.eclipse.aether.artifact.Artifact artifact = RepositoryUtils.toArtifact((Artifact)this.project.getArtifact());
        List<RemoteRepository> aetherRepos = this.getRepositories(artifact);
        this.setupBase(artifact);
        try {
            ArtifactResult artifactResult;
            this.searchForBaseVersion(aetherRepos);
            if (this.base.getVersion() != null && !this.base.getVersion().isEmpty() && !(artifactResult = this.locateBaseJar(aetherRepos)).isMissing()) {
                this.baselineAction(artifact.getFile(), artifactResult.getArtifact().getFile());
                return;
            }
        }
        catch (RepositoryException artifactResult) {
        }
        catch (Exception e) {
            throw new MojoExecutionException("An error occurred while calculating the baseline", e);
        }
        if (this.failOnMissing) {
            throw new MojoFailureException("Unable to locate a previous version of the artifact");
        }
        logger.warn("No previous version of {} could be found to baseline against", (Object)artifact);
    }

    private List<RemoteRepository> getRepositories(org.eclipse.aether.artifact.Artifact artifact) {
        List aetherRepos = RepositoryUtils.toRepos((List)this.project.getRemoteArtifactRepositories());
        if (this.includeDistributionManagement) {
            RemoteRepository releaseDistroRepo;
            if (artifact.isSnapshot()) {
                MavenProject tmpClone = this.project.clone();
                tmpClone.getArtifact().setVersion("1.0.0");
                releaseDistroRepo = RepositoryUtils.toRepo((ArtifactRepository)tmpClone.getDistributionManagementArtifactRepository());
            } else {
                releaseDistroRepo = RepositoryUtils.toRepo((ArtifactRepository)this.project.getDistributionManagementArtifactRepository());
            }
            if (releaseDistroRepo != null) {
                aetherRepos.add(0, releaseDistroRepo);
            }
        }
        return aetherRepos;
    }

    private void setupBase(org.eclipse.aether.artifact.Artifact artifact) {
        if (this.base == null) {
            this.base = new Base();
        }
        if (this.baseCoordinates != null && !this.baseCoordinates.isBlank()) {
            this.base.setFromCoordinates(this.baseCoordinates);
        }
        if (this.base.getGroupId() == null || this.base.getGroupId().isEmpty()) {
            this.base.setGroupId(this.project.getGroupId());
        }
        if (this.base.getArtifactId() == null || this.base.getArtifactId().isEmpty()) {
            this.base.setArtifactId(this.project.getArtifactId());
        }
        if (this.base.getClassifier() == null || this.base.getClassifier().isEmpty()) {
            this.base.setClassifier(artifact.getClassifier());
        }
        if (this.base.getExtension() == null || this.base.getExtension().isEmpty()) {
            this.base.setExtension(artifact.getExtension());
        }
        if (this.base.getVersion() == null || this.base.getVersion().isEmpty()) {
            this.base.setVersion("(," + artifact.getVersion() + ")");
        }
        logger.debug("Baselining against {}, fail on missing: {}", (Object)this.base, (Object)this.failOnMissing);
    }

    private void searchForBaseVersion(List<RemoteRepository> aetherRepos) throws VersionRangeResolutionException {
        logger.info("Determining the baseline version for {} using repositories {}", (Object)this.base, aetherRepos);
        DefaultArtifact toFind = new DefaultArtifact(this.base.getGroupId(), this.base.getArtifactId(), this.base.getClassifier(), this.base.getExtension(), this.base.getVersion());
        VersionRangeRequest request = new VersionRangeRequest((org.eclipse.aether.artifact.Artifact)toFind, aetherRepos, "baseline");
        VersionRangeResult versions = this.system.resolveVersionRange(this.session, request);
        List found = versions.getVersions();
        logger.debug("Found versions {}", (Object)found);
        boolean onlyreleaseversions = this.releaseversions && (this.base.getVersion().startsWith("[") || this.base.getVersion().startsWith("("));
        this.base.setVersion(null);
        ListIterator li = found.listIterator(found.size());
        while (li.hasPrevious()) {
            MavenVersion mavenVersion;
            String highest = ((Version)li.previous()).toString();
            if (toFind.setVersion(highest).isSnapshot()) continue;
            if (onlyreleaseversions && (mavenVersion = MavenVersion.parseMavenString((String)highest)).compareTo(mavenVersion.toReleaseVersion()) < 0) {
                logger.debug("Version {} not considered since it is not a release version", (Object)highest);
                continue;
            }
            this.base.setVersion(highest);
            break;
        }
        logger.info("The baseline version was found to be {}", (Object)this.base.getVersion());
    }

    private ArtifactResult locateBaseJar(List<RemoteRepository> aetherRepos) throws ArtifactResolutionException {
        DefaultArtifact toFind = new DefaultArtifact(this.base.getGroupId(), this.base.getArtifactId(), this.base.getClassifier(), this.base.getExtension(), this.base.getVersion());
        return this.system.resolveArtifact(this.session, new ArtifactRequest((org.eclipse.aether.artifact.Artifact)toFind, aetherRepos, "baseline"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void baselineAction(File bundle, File baseline) throws Exception {
        IO.mkdirs((File)this.reportFile.getParentFile());
        boolean failure = false;
        try (Processor processor = new Processor();
             Jar newer = new Jar(bundle);
             Jar older = new Jar(baseline);){
            logger.info("Baseline bundle {} against baseline {}", (Object)bundle, (Object)baseline);
            DiffPluginImpl differ = new DiffPluginImpl();
            differ.setIgnore(new Parameters(Strings.join(this.diffignores), (Reporter)processor));
            Baseline baseliner = new Baseline((Reporter)processor, (Differ)differ);
            List<Baseline.Info> infos = baseliner.baseline(newer, older, new Instructions(new Parameters(Strings.join(this.diffpackages), (Reporter)processor))).stream().sorted(Comparator.comparing(info -> info.packageName)).toList();
            Baseline.BundleInfo bundleInfo = baseliner.getBundleInfo();
            try (Formatter f = new Formatter(this.reportFile, "UTF-8", Locale.US);){
                String format = "%s %-50s %-10s %-10s %-10s %-10s %-10s %s\n";
                f.format("===============================================================\n", new Object[0]);
                f.format(format, " ", "Name", "Type", "Delta", "New", "Old", "Suggest", "");
                Diff diff = baseliner.getDiff();
                f.format(format, bundleInfo.mismatch ? "*" : " ", bundleInfo.bsn, diff.getType(), diff.getDelta(), newer.getVersion(), older.getVersion(), bundleInfo.mismatch && Objects.nonNull(bundleInfo.suggestedVersion) ? bundleInfo.suggestedVersion : "-", "");
                if (this.fullReport || bundleInfo.mismatch) {
                    f.format("%#2S\n", diff);
                }
                if (bundleInfo.mismatch) {
                    failure = true;
                }
                if (!infos.isEmpty()) {
                    f.format("===============================================================\n", new Object[0]);
                    f.format(format, " ", "Name", "Type", "Delta", "New", "Old", "Suggest", "If Prov.");
                    for (Baseline.Info info2 : infos) {
                        diff = info2.packageDiff;
                        f.format(format, info2.mismatch ? "*" : " ", diff.getName(), diff.getType(), diff.getDelta(), info2.newerVersion, Objects.nonNull(info2.olderVersion) && info2.olderVersion.equals((Object)aQute.bnd.version.Version.LOWEST) ? "-" : info2.olderVersion, Objects.nonNull(info2.suggestedVersion) && info2.suggestedVersion.compareTo(info2.newerVersion) <= 0 ? "ok" : info2.suggestedVersion, Objects.nonNull(info2.suggestedIfProviders) ? info2.suggestedIfProviders : "-");
                        if (this.fullReport || info2.mismatch) {
                            f.format("%#2S\n", diff);
                        }
                        if (!info2.mismatch) continue;
                        failure = true;
                    }
                }
            }
        }
        if (failure) {
            String msg = String.format("Baseline problems detected. See the report in %s.\n%s", this.reportFile, IO.collect((File)this.reportFile));
            if (!this.continueOnError) throw new MojoFailureException(msg);
            logger.warn(msg);
            return;
        } else {
            logger.info("Baseline check succeeded. See the report in {}.", (Object)this.reportFile);
        }
    }
}

