/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.plugin;

import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.version.MavenVersion;
import aQute.bnd.version.Version;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.service.reporter.Report;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="bnd-process", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BndMavenPlugin
extends AbstractMojo {
    private static final String PACKAGING_POM = "pom";
    private static final String TSTAMP = "${tstamp}";
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDir;
    @Parameter(defaultValue="${project.build.sourceDirectory}", readonly=true)
    private File sourceDir;
    @Parameter(defaultValue="${project.build.resources}", readonly=true)
    private List<Resource> resources;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File classesDir;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF", readonly=true)
    private File manifestPath;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Component
    private BuildContext buildContext;
    private Log log;

    public void execute() throws MojoExecutionException {
        this.log = this.getLog();
        if (PACKAGING_POM.equals(this.project.getPackaging())) {
            this.log.info((CharSequence)"skip project with packaging=pom");
            return;
        }
        BeanProperties beanProperties = new BeanProperties();
        beanProperties.put("project", this.project);
        beanProperties.put("settings", this.settings);
        Properties mavenProperties = new Properties(beanProperties);
        mavenProperties.putAll((Map<?, ?>)this.project.getProperties());
        try (Builder builder = new Builder(new Processor(mavenProperties, false));){
            builder.setTrace(this.log.isDebugEnabled());
            builder.setBase(this.project.getBasedir());
            this.loadProjectProperties(builder, this.project);
            builder.setProperty("project.output", this.targetDir.getCanonicalPath());
            if (Builder.isTrue((String)builder.getProperty("-nobundles"))) {
                this.log.debug((CharSequence)"-nobundles: true");
                return;
            }
            List subs = builder.getSubBuilders();
            if (subs.size() != 1 || !builder.equals(subs.get(0))) {
                throw new MojoExecutionException("Sub-bundles not permitted in a maven build");
            }
            if (this.classesDir.isDirectory()) {
                Jar classesDirJar = new Jar(this.project.getName(), this.classesDir);
                classesDirJar.setManifest(new Manifest());
                builder.setJar(classesDirJar);
            }
            Set artifacts = this.project.getArtifacts();
            ArrayList<Object> buildpath = new ArrayList<Object>(artifacts.size());
            for (Artifact artifact : artifacts) {
                if (!artifact.getType().equals("jar")) continue;
                File cpe = artifact.getFile().getCanonicalFile();
                if (cpe.isDirectory()) {
                    Jar cpeJar = new Jar(cpe);
                    builder.addClose((Closeable)cpeJar);
                    builder.updateModified(cpeJar.lastModified(), cpe.getPath());
                    buildpath.add(cpeJar);
                    continue;
                }
                builder.updateModified(cpe.lastModified(), cpe.getPath());
                buildpath.add(cpe);
            }
            builder.setProperty("project.buildpath", Strings.join((String)File.pathSeparator, buildpath));
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("builder classpath: " + builder.getProperty("project.buildpath")));
            }
            boolean delta = !this.buildContext.isIncremental() || !this.manifestPath.exists();
            ArrayList<File> sourcepath = new ArrayList<File>();
            if (this.sourceDir.exists()) {
                sourcepath.add(this.sourceDir.getCanonicalFile());
                delta |= this.buildContext.hasDelta(this.sourceDir);
            }
            for (Resource resource : this.resources) {
                File resourceDir = new File(resource.getDirectory());
                if (!resourceDir.exists()) continue;
                sourcepath.add(resourceDir.getCanonicalFile());
                delta |= this.buildContext.hasDelta(resourceDir);
            }
            builder.setProperty("project.sourcepath", Strings.join((String)File.pathSeparator, sourcepath));
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("builder sourcepath: " + builder.getProperty("project.sourcepath")));
            }
            if (builder.getProperty("Bundle-SymbolicName") == null) {
                builder.setProperty("Bundle-SymbolicName", this.project.getArtifactId());
            }
            if (builder.getProperty("Bundle-Name") == null) {
                builder.setProperty("Bundle-Name", this.project.getName());
            }
            Version version = MavenVersion.parseString((String)this.project.getVersion()).getOSGiVersion();
            builder.setProperty("Bundle-Version", version.toString());
            if (builder.getProperty("-snapshot") == null) {
                builder.setProperty("-snapshot", TSTAMP);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("builder properties: " + builder.getProperties()));
                this.log.debug((CharSequence)("builder delta: " + delta));
            }
            if (delta || builder.getJar() == null || builder.lastModified() > builder.getJar().lastModified()) {
                builder.setClasspath(buildpath);
                builder.setSourcepath(sourcepath.toArray(new File[0]));
                Jar bndJar = builder.build();
                this.expandJar(bndJar, this.classesDir);
            } else {
                this.log.debug((CharSequence)"No build");
            }
            this.reportErrorsAndWarnings(builder);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("bnd error: " + e.getMessage(), e);
        }
    }

    private void loadProjectProperties(Builder builder, MavenProject project) throws Exception {
        Xpp3Dom bndElement;
        MavenProject parentProject = project.getParent();
        if (parentProject != null) {
            this.loadProjectProperties(builder, parentProject);
        }
        Xpp3Dom configuration = project.getGoalConfiguration("biz.aQute.bnd", "bnd-maven-plugin", null, null);
        File baseDir = project.getBasedir();
        if (baseDir != null) {
            File bndFile;
            Xpp3Dom bndfileElement;
            File pomFile = project.getFile();
            builder.updateModified(pomFile.lastModified(), "POM: " + pomFile);
            String bndFileName = "bnd.bnd";
            if (configuration != null && (bndfileElement = configuration.getChild("bndfile")) != null) {
                bndFileName = bndfileElement.getValue();
            }
            if ((bndFile = IO.getFile((File)baseDir, (String)bndFileName)).isFile()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("loading bnd properties from file: " + bndFile));
                }
                builder.setProperties(bndFile.getParentFile(), builder.loadProperties(bndFile));
                return;
            }
        }
        if (configuration != null && (bndElement = configuration.getChild("bnd")) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("loading bnd properties from bnd element in pom: " + bndElement.getValue()));
            }
            UTF8Properties properties = new UTF8Properties();
            properties.load(bndElement.getValue(), project.getFile(), (Reporter)builder);
            builder.setProperties(baseDir, (Properties)properties);
            return;
        }
    }

    private void reportErrorsAndWarnings(Builder builder) throws MojoExecutionException {
        Log log = this.getLog();
        File defaultFile = new File(this.project.getBasedir(), "bnd.bnd");
        if (!defaultFile.exists()) {
            defaultFile = this.project.getFile();
        }
        List warnings = builder.getWarnings();
        for (String warning : warnings) {
            Report.Location location = builder.getLocation(warning);
            if (location == null) {
                location = new Report.Location();
                location.message = warning;
            }
            this.buildContext.addMessage(location.file == null ? defaultFile : new File(location.file), location.line, location.length, location.message, 1, null);
        }
        List errors = builder.getErrors();
        for (String error : errors) {
            Report.Location location = builder.getLocation(error);
            if (location == null) {
                location = new Report.Location();
                location.message = error;
            }
            this.buildContext.addMessage(location.file == null ? defaultFile : new File(location.file), location.line, location.length, location.message, 2, null);
        }
        if (!builder.isOk()) {
            if (errors.size() == 1) {
                throw new MojoExecutionException((String)errors.get(0));
            }
            throw new MojoExecutionException("Errors in bnd processing, see log for details.");
        }
    }

    private void expandJar(Jar jar, File dir) throws Exception {
        long lastModified = jar.lastModified();
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)String.format("Bundle lastModified: %tF %<tT.%<tL", lastModified));
        }
        dir = dir.getAbsoluteFile();
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        for (Map.Entry entry : jar.getResources().entrySet()) {
            FileResource fr;
            File outFile = IO.getFile((File)dir, (String)((String)entry.getKey()));
            aQute.bnd.osgi.Resource resource = (aQute.bnd.osgi.Resource)entry.getValue();
            if (resource instanceof FileResource && outFile.equals((fr = (FileResource)resource).getFile()) || outFile.exists() && outFile.lastModified() >= lastModified) continue;
            if (this.log.isDebugEnabled()) {
                if (outFile.exists()) {
                    this.log.debug((CharSequence)String.format("Updating lastModified: %tF %<tT.%<tL '%s'", outFile.lastModified(), outFile));
                } else {
                    this.log.debug((CharSequence)String.format("Creating '%s'", outFile));
                }
            }
            Files.createDirectories(outFile.toPath().getParent(), new FileAttribute[0]);
            OutputStream out = this.buildContext.newFileOutputStream(outFile);
            Throwable throwable = null;
            try {
                IO.copy((InputStream)resource.openInputStream(), (OutputStream)out);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                out.close();
            }
        }
        if (!this.manifestPath.exists() || this.manifestPath.lastModified() < lastModified) {
            if (this.log.isDebugEnabled()) {
                if (this.manifestPath.exists()) {
                    this.log.debug((CharSequence)String.format("Updating lastModified: %tF %<tT.%<tL '%s'", this.manifestPath.lastModified(), this.manifestPath));
                } else {
                    this.log.debug((CharSequence)String.format("Creating '%s'", this.manifestPath));
                }
            }
            Files.createDirectories(this.manifestPath.toPath().getParent(), new FileAttribute[0]);
            try (OutputStream manifestOut = this.buildContext.newFileOutputStream(this.manifestPath);){
                jar.writeManifest(manifestOut);
            }
        }
    }

    private class BeanProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        BeanProperties() {
        }

        @Override
        public String getProperty(String key) {
            int i = key.indexOf(46);
            String name = i > 0 ? key.substring(0, i) : key;
            Object value = this.get(name);
            if (value != null && i > 0) {
                value = this.getField(value, key.substring(i + 1));
            }
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        private Object getField(Object target, String key) {
            int i = key.indexOf(46);
            String fieldName = i > 0 ? key.substring(0, i) : key;
            String getterSuffix = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            Object value = null;
            try {
                Method getter;
                Class<?> targetClass = target.getClass();
                while (!Modifier.isPublic(targetClass.getModifiers())) {
                    targetClass = targetClass.getSuperclass();
                }
                try {
                    getter = targetClass.getMethod("get" + getterSuffix, new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    getter = targetClass.getMethod("is" + getterSuffix, new Class[0]);
                }
                value = getter.invoke(target, new Object[0]);
            }
            catch (Exception e) {
                BndMavenPlugin.this.log.debug((CharSequence)("Could not find getter method for field: " + fieldName), (Throwable)e);
            }
            if (value != null && i > 0) {
                value = this.getField(value, key.substring(i + 1));
            }
            return value;
        }
    }
}

