/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.resolver.plugin;

import aQute.bnd.maven.lib.configuration.Bndruns;
import aQute.bnd.maven.lib.configuration.Bundles;
import aQute.bnd.maven.lib.resolve.BndrunContainer;
import aQute.bnd.maven.lib.resolve.Operation;
import aQute.bnd.maven.lib.resolve.Scope;
import biz.aQute.resolve.Bndrun;
import biz.aQute.resolve.ResolveProcess;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.osgi.service.resolver.ResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="resolve", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class ResolverMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(ResolverMojo.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repositorySession;
    @Parameter
    private Bndruns bndruns = new Bndruns();
    @Parameter
    private Bundles bundles = new Bundles();
    @Parameter(defaultValue="true")
    private boolean useMavenDependencies;
    @Parameter(defaultValue="true")
    private boolean failOnChanges;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDir;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="bnd.resolve.include.dependency.management", defaultValue="false")
    private boolean includeDependencyManagement;
    @Parameter(defaultValue="true")
    private boolean reportOptional;
    @Parameter(property="bnd.resolve.scopes", defaultValue="compile,runtime")
    private Set<Scope> scopes = new HashSet<Scope>(Arrays.asList(Scope.compile, Scope.runtime));
    @Parameter(property="bnd.resolve.skip", defaultValue="false")
    private boolean skip;
    @Component
    private RepositorySystem system;
    @Component
    private ProjectDependenciesResolver resolver;
    @Component
    private ArtifactFactory artifactFactory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            logger.debug("skip project as configured");
            return;
        }
        int errors = 0;
        try {
            BndrunContainer container = new BndrunContainer.Builder(this.project, this.session, this.repositorySession, this.resolver, this.artifactFactory, this.system).setBundles(this.bundles.getFiles(this.project.getBasedir(), new String[0])).setIncludeDependencyManagement(this.includeDependencyManagement).setScopes(this.scopes).setUseMavenDependencies(this.useMavenDependencies).build();
            Operation operation = this.getOperation();
            for (File runFile : this.bndruns.getFiles(this.project.getBasedir(), new String[]{"*.bndrun"})) {
                errors += container.execute(runFile, "resolve", this.targetDir, operation);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (errors > 0) {
            throw new MojoFailureException(errors + " errors found");
        }
    }

    private Operation getOperation() {
        return (file, runName, run) -> {
            try {
                run.resolve(this.failOnChanges, true);
            }
            catch (ResolutionException re) {
                logger.error(ResolveProcess.format((ResolutionException)re, (boolean)this.reportOptional));
                throw re;
            }
            finally {
                int errors = BndrunContainer.report((Bndrun)run);
                if (errors > 0) {
                    return errors;
                }
            }
            return 0;
        };
    }
}

