/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.compiler;

import biz.gabrys.lesscss.compiler.CompilerException;
import biz.gabrys.lesscss.compiler.CompilerOptions;
import biz.gabrys.lesscss.compiler.IOUtils;
import biz.gabrys.lesscss.compiler.InitializationException;
import biz.gabrys.lesscss.compiler.LessCompiler;
import biz.gabrys.lesscss.compiler.ResolveImportException;
import biz.gabrys.lesscss.compiler.SyntaxException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;

public class LessCompilerImpl
implements LessCompiler {
    private static final Pattern IMPORT_ERROR_PATTERN = Pattern.compile("^FileError:\\s+'(.+)'\\s+wasn't\\s+found\\s+(?s).*");
    private static final int IMPORT_ERROR_FILE_NAME_GROUP_INDEX = 1;
    private static final String CHARSET = "UTF-8";
    private final Object mutex = new Object();
    private Scriptable scope;
    private ByteArrayOutputStream console;
    private Function compiler;

    public String compile(File source) throws CompilerException {
        return this.compile(source, new CompilerOptions());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String compile(File input, CompilerOptions options) throws CompilerException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.compiler == null) {
                this.initialize();
            }
            try {
                Context context = Context.enter();
                ScriptableObject compileScope = (ScriptableObject)context.newObject(this.scope);
                compileScope.setParentScope(null);
                compileScope.setPrototype(this.scope);
                Scriptable arguments = context.newArray((Scriptable)compileScope, LessCompilerImpl.prepareCompilerArguments(input, options));
                compileScope.defineProperty("arguments", (Object)arguments, 2);
                this.compiler.call(context, (Scriptable)compileScope, null, new Object[0]);
                String string = this.console.toString(CHARSET);
                return string;
            }
            catch (JavaScriptException e) {
                throw LessCompilerImpl.parseException(e);
            }
            catch (Exception e) {
                throw new CompilerException(e);
            }
            finally {
                this.console.reset();
                Context.exit();
            }
        }
    }

    private void initialize() throws InitializationException {
        InputStreamReader reader = null;
        try {
            Context context = Context.enter();
            context.setLanguageVersion(180);
            Global global = new Global();
            global.init(context);
            this.scope = context.initStandardObjects((ScriptableObject)global);
            this.console = new ByteArrayOutputStream();
            global.setOut(new PrintStream((OutputStream)this.console, false, CHARSET));
            URL lessFile = LessCompilerImpl.class.getResource("/less/less-rhino-1.7.5.js");
            URL lesscFile = LessCompilerImpl.class.getResource("/less/lessc-rhino-1.7.5.js");
            ArrayList<InputStream> streams = new ArrayList<InputStream>();
            streams.add(lessFile.openConnection().getInputStream());
            streams.add(lesscFile.openConnection().getInputStream());
            reader = new InputStreamReader((InputStream)new SequenceInputStream(Collections.enumeration(streams)), CHARSET);
            this.compiler = (Function)context.compileReader((Reader)reader, lessFile.toString(), 1, null);
        }
        catch (Exception e) {
            try {
                throw new InitializationException("Failed to initialize Less compiler", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                Context.exit();
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        Context.exit();
    }

    private static Object[] prepareCompilerArguments(File sourceFile, CompilerOptions options) {
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.addAll(options.getArguments());
        arguments.add(sourceFile.getAbsolutePath());
        return arguments.toArray();
    }

    private static CompilerException parseException(JavaScriptException exception) {
        Scriptable value = (Scriptable)exception.getValue();
        if (value != null && ScriptableObject.hasProperty((Scriptable)value, (String)"message")) {
            String message = ScriptableObject.getProperty((Scriptable)value, (String)"message").toString();
            Matcher matcher = IMPORT_ERROR_PATTERN.matcher(message);
            if (matcher.find()) {
                return new ResolveImportException(message, matcher.group(1), exception);
            }
            return new SyntaxException(message, exception);
        }
        return new SyntaxException(exception);
    }
}

