/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.aem;

import biz.netcentric.cq.tools.actool.helper.AccessControlUtils;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcToolCqActions {
    private static final Logger LOG = LoggerFactory.getLogger(AcToolCqActions.class);
    private static final String CONTENT_RESTRICTION = "*/jcr:content*";
    private static final String REPLICATE_PRIVILEGE = "{http://www.day.com/crx/1.0}replicate";
    private final Session session;
    private final Map<String, Set<Privilege>> map = new HashMap<String, Set<Privilege>>();

    public AcToolCqActions(Session session) throws RepositoryException {
        this.session = session;
        AccessControlManager acMgr = session.getAccessControlManager();
        this.map.put(CqActions.read.name(), AcToolCqActions.getPrivilegeSet("{http://www.jcp.org/jcr/1.0}read", acMgr));
        this.map.put(CqActions.modify.name(), AcToolCqActions.getPrivilegeSet(new String[]{"{http://www.jcp.org/jcr/1.0}modifyProperties", "{http://www.jcp.org/jcr/1.0}lockManagement", "{http://www.jcp.org/jcr/1.0}versionManagement"}, acMgr));
        this.map.put(CqActions.create.name(), AcToolCqActions.getPrivilegeSet(new String[]{"{http://www.jcp.org/jcr/1.0}addChildNodes", "{http://www.jcp.org/jcr/1.0}nodeTypeManagement"}, acMgr));
        this.map.put(CqActions.delete.name(), AcToolCqActions.getPrivilegeSet(new String[]{"{http://www.jcp.org/jcr/1.0}removeChildNodes", "{http://www.jcp.org/jcr/1.0}removeNode"}, acMgr));
        this.map.put(CqActions.acl_read.name(), AcToolCqActions.getPrivilegeSet("{http://www.jcp.org/jcr/1.0}readAccessControl", acMgr));
        this.map.put(CqActions.acl_edit.name(), AcToolCqActions.getPrivilegeSet("{http://www.jcp.org/jcr/1.0}modifyAccessControl", acMgr));
        try {
            this.map.put(CqActions.replicate.name(), AcToolCqActions.getPrivilegeSet(REPLICATE_PRIVILEGE, acMgr));
        }
        catch (AccessControlException e) {
            LOG.warn("Replicate privilege not registered");
        }
    }

    public Set<Privilege> getPrivileges(String action) {
        return this.map.get(action);
    }

    public Collection<String> getAllowedActions(String nodePath, Set<Principal> principals) throws RepositoryException {
        AccessControlManager acMgr = this.session.getAccessControlManager();
        HashSet<String> granted = new HashSet<String>();
        Set<Privilege> privileges = AcToolCqActions.getPrivileges(nodePath, principals, acMgr);
        for (Map.Entry<String, Set<Privilege>> e : this.map.entrySet()) {
            if (!privileges.containsAll((Collection)e.getValue())) continue;
            granted.add(e.getKey());
        }
        if (AcToolCqActions.definesContent(this.session.getNode(nodePath))) {
            String contentPath = nodePath + "/" + "jcr:content";
            if (!(!granted.contains(CqActions.modify.name()) || this.session.nodeExists(contentPath) && AcToolCqActions.getPrivileges(contentPath, principals, acMgr).containsAll(AcToolCqActions.getPrivilegeSet("rep:write", acMgr)))) {
                granted.remove(CqActions.modify.name());
            }
        }
        return granted;
    }

    public void installActions(String nodePath, Principal principal, Map<String, Boolean> actionMap, Collection<String> inheritedAllows) throws RepositoryException {
        if (actionMap.isEmpty()) {
            return;
        }
        AccessControlManager acMgr = this.session.getAccessControlManager();
        JackrabbitAccessControlList acl = AccessControlUtils.getModifiableAcl(acMgr, nodePath);
        for (String string : actionMap.keySet()) {
            int isAllow = actionMap.get(string).booleanValue();
            Set<Privilege> privileges = this.map.get(string);
            if (privileges == null) continue;
            acl.addEntry(principal, privileges.toArray(new Privilege[privileges.size()]), isAllow != 0);
        }
        if (AcToolCqActions.definesContent(this.session.getNode(nodePath))) {
            Map<String, Value> restrictions = null;
            for (String rName : acl.getRestrictionNames()) {
                if (!"rep:glob".equals(rName)) continue;
                Value v = this.session.getValueFactory().createValue(CONTENT_RESTRICTION, acl.getRestrictionType(rName));
                restrictions = Collections.singletonMap(rName, v);
                break;
            }
            if (restrictions == null) {
                LOG.warn("Cannot install special permissions node with jcr:content primary item. rep:glob restriction not supported by AC model.");
            } else {
                boolean modify;
                HashSet<Privilege> hashSet = new HashSet<Privilege>();
                HashSet<Privilege> denyPrivs = new HashSet<Privilege>();
                if (actionMap.containsKey(CqActions.modify.name())) {
                    List<Privilege> contentModify = Arrays.asList(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}nodeTypeManagement"), acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes"), acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes"), acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode"));
                    if (actionMap.get(CqActions.modify.name()).booleanValue()) {
                        hashSet.addAll(contentModify);
                    } else {
                        denyPrivs.addAll(contentModify);
                    }
                    modify = actionMap.get(CqActions.modify.name());
                } else {
                    modify = inheritedAllows.contains(CqActions.modify.name());
                }
                if (!modify) {
                    if (actionMap.containsKey(CqActions.create.name()) && actionMap.get(CqActions.create.name()).booleanValue()) {
                        denyPrivs.add(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes"));
                        denyPrivs.add(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}nodeTypeManagement"));
                    }
                    if (actionMap.containsKey(CqActions.delete.name()) && actionMap.get(CqActions.delete.name()).booleanValue()) {
                        denyPrivs.add(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes"));
                        denyPrivs.add(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode"));
                    }
                } else {
                    if (actionMap.containsKey(CqActions.create.name()) && !actionMap.get(CqActions.create.name()).booleanValue()) {
                        hashSet.add(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes"));
                        hashSet.add(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}nodeTypeManagement"));
                    }
                    if (actionMap.containsKey(CqActions.delete.name()) && !actionMap.get(CqActions.delete.name()).booleanValue()) {
                        hashSet.add(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes"));
                        hashSet.add(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode"));
                    }
                }
                if (!hashSet.isEmpty()) {
                    acl.addEntry(principal, hashSet.toArray(new Privilege[hashSet.size()]), true, restrictions);
                }
                if (!denyPrivs.isEmpty()) {
                    acl.addEntry(principal, denyPrivs.toArray(new Privilege[denyPrivs.size()]), false, restrictions);
                }
            }
        }
        acMgr.setPolicy(nodePath, (AccessControlPolicy)acl);
    }

    public static boolean definesContent(Node node) throws RepositoryException {
        NodeType nt = node.getPrimaryNodeType();
        for (NodeDefinition cnd : nt.getChildNodeDefinitions()) {
            if (!"jcr:content".equals(cnd.getName())) continue;
            return true;
        }
        return false;
    }

    private static Set<Privilege> getPrivileges(String path, Set<Principal> principals, AccessControlManager acMgr) throws RepositoryException {
        HashSet<Privilege> privileges = new HashSet<Privilege>();
        Privilege[] privs = principals == null ? acMgr.getPrivileges(path) : ((JackrabbitAccessControlManager)acMgr).getPrivileges(path, principals);
        for (Privilege priv : privs) {
            if (priv.isAggregate()) {
                privileges.addAll(Arrays.asList(priv.getAggregatePrivileges()));
                continue;
            }
            privileges.add(priv);
        }
        return privileges;
    }

    private static Set<Privilege> getPrivilegeSet(String privName, AccessControlManager acMgr) throws RepositoryException {
        Privilege p = acMgr.privilegeFromName(privName);
        Set<Privilege> privileges = p.isAggregate() ? new HashSet<Privilege>(Arrays.asList(p.getAggregatePrivileges())) : Collections.singleton(p);
        return privileges;
    }

    private static Set<Privilege> getPrivilegeSet(String[] privNames, AccessControlManager acMgr) throws RepositoryException {
        HashSet<Privilege> privileges = new HashSet<Privilege>(privNames.length);
        for (String name : privNames) {
            Privilege p = acMgr.privilegeFromName(name);
            if (p.isAggregate()) {
                privileges.addAll(Arrays.asList(p.getAggregatePrivileges()));
                continue;
            }
            privileges.add(p);
        }
        return privileges;
    }

    public static enum CqActions {
        read,
        modify,
        create,
        delete,
        acl_read,
        acl_edit,
        replicate;

    }
}

