/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.helper;

import biz.netcentric.cq.tools.actool.configmodel.Restriction;
import biz.netcentric.cq.tools.actool.helper.ContentHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictionsHolder {
    public static final Logger LOG = LoggerFactory.getLogger(ContentHelper.class);
    private static final RestrictionsHolder EMPTY = new RestrictionsHolder(Collections.unmodifiableList(new ArrayList()), null, null);
    private List<Restriction> restrictions;
    private final ValueFactory valueFactory;
    private final JackrabbitAccessControlList acl;
    private Map<String, Value> singleValuedRestrictions = new HashMap<String, Value>();
    private Map<String, Value[]> multiValuedRestrictions = new HashMap<String, Value[]>();

    public RestrictionsHolder(List<Restriction> restrictions, ValueFactory valueFactory, JackrabbitAccessControlList acl) {
        this.restrictions = restrictions;
        this.valueFactory = valueFactory;
        this.acl = acl;
        this.buildRestrictionsMaps(valueFactory, acl);
    }

    private void buildRestrictionsMaps(ValueFactory valueFactory, JackrabbitAccessControlList acl) {
        for (Restriction restriction : this.restrictions) {
            try {
                if (restriction.isMultivalued()) {
                    List<String> strValues = restriction.getValues();
                    Value[] values = new Value[strValues.size()];
                    for (int i = 0; i < strValues.size(); ++i) {
                        Value value;
                        values[i] = value = valueFactory.createValue(strValues.get(i), acl.getRestrictionType(restriction.getName()));
                    }
                    this.multiValuedRestrictions.put(restriction.getName(), values);
                    continue;
                }
                Value value = valueFactory.createValue(restriction.getValue(), acl.getRestrictionType(restriction.getName()));
                this.singleValuedRestrictions.put(restriction.getName(), value);
            }
            catch (Exception e) {
                LOG.warn("Could not create value for restriction " + restriction.getName() + ", e=" + e, (Throwable)e);
            }
        }
    }

    public List<Restriction> getRestrictions() {
        return this.restrictions;
    }

    public boolean isEmpty() {
        return this.restrictions.isEmpty();
    }

    public static RestrictionsHolder empty() {
        return EMPTY;
    }

    public Map<String, Value> getSingleValuedRestrictionsMap() throws ValueFormatException, RepositoryException {
        return this.singleValuedRestrictions;
    }

    public Map<String, Value[]> getMultiValuedRestrictionsMap() throws ValueFormatException, RepositoryException {
        return this.multiValuedRestrictions;
    }
}

