/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.validators;

import biz.netcentric.cq.tools.actool.configmodel.GlobalConfiguration;
import org.osgi.framework.FrameworkUtil;

public class GlobalConfigurationValidator {
    public static void validate(GlobalConfiguration globalConfiguration) {
        if (globalConfiguration != null && globalConfiguration.getMinRequiredVersion() != null) {
            GlobalConfigurationValidator.checkForValidVersion(globalConfiguration.getMinRequiredVersion());
        }
    }

    private static void checkForValidVersion(String configuredMinRequiredVersion) {
        boolean isVersionValid;
        String bundleVersion = FrameworkUtil.getBundle(GlobalConfigurationValidator.class).getVersion().toString();
        boolean bl = isVersionValid = GlobalConfigurationValidator.versionCompare(bundleVersion, configuredMinRequiredVersion) >= 0;
        if (!isVersionValid) {
            throw new IllegalArgumentException("AC Tool Version " + bundleVersion + " is too old for configuration (MinRequiredVersion=" + configuredMinRequiredVersion + ")");
        }
    }

    public static boolean versionIsNewerOrEqualTo(String str1, String str2) {
        return GlobalConfigurationValidator.versionCompare(str1, str2) >= 0;
    }

    public static int versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff;
            try {
                diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            }
            catch (NumberFormatException e) {
                diff = vals1[i].compareTo(vals2[i]);
            }
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }
}

